/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration for the domain cluster, such as the type and number of instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ElasticsearchClusterConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ElasticsearchClusterConfig.Builder, ElasticsearchClusterConfig> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(ElasticsearchClusterConfig::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount").getter(getter(ElasticsearchClusterConfig::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<Boolean> DEDICATED_MASTER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DedicatedMasterEnabled").getter(getter(ElasticsearchClusterConfig::dedicatedMasterEnabled))
            .setter(setter(Builder::dedicatedMasterEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedMasterEnabled").build())
            .build();

    private static final SdkField<Boolean> ZONE_AWARENESS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ZoneAwarenessEnabled").getter(getter(ElasticsearchClusterConfig::zoneAwarenessEnabled))
            .setter(setter(Builder::zoneAwarenessEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneAwarenessEnabled").build())
            .build();

    private static final SdkField<ZoneAwarenessConfig> ZONE_AWARENESS_CONFIG_FIELD = SdkField
            .<ZoneAwarenessConfig> builder(MarshallingType.SDK_POJO).memberName("ZoneAwarenessConfig")
            .getter(getter(ElasticsearchClusterConfig::zoneAwarenessConfig)).setter(setter(Builder::zoneAwarenessConfig))
            .constructor(ZoneAwarenessConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneAwarenessConfig").build())
            .build();

    private static final SdkField<String> DEDICATED_MASTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DedicatedMasterType").getter(getter(ElasticsearchClusterConfig::dedicatedMasterTypeAsString))
            .setter(setter(Builder::dedicatedMasterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedMasterType").build())
            .build();

    private static final SdkField<Integer> DEDICATED_MASTER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DedicatedMasterCount").getter(getter(ElasticsearchClusterConfig::dedicatedMasterCount))
            .setter(setter(Builder::dedicatedMasterCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedMasterCount").build())
            .build();

    private static final SdkField<Boolean> WARM_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("WarmEnabled").getter(getter(ElasticsearchClusterConfig::warmEnabled))
            .setter(setter(Builder::warmEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmEnabled").build()).build();

    private static final SdkField<String> WARM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WarmType").getter(getter(ElasticsearchClusterConfig::warmTypeAsString))
            .setter(setter(Builder::warmType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmType").build()).build();

    private static final SdkField<Integer> WARM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WarmCount").getter(getter(ElasticsearchClusterConfig::warmCount)).setter(setter(Builder::warmCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmCount").build()).build();

    private static final SdkField<ColdStorageOptions> COLD_STORAGE_OPTIONS_FIELD = SdkField
            .<ColdStorageOptions> builder(MarshallingType.SDK_POJO).memberName("ColdStorageOptions")
            .getter(getter(ElasticsearchClusterConfig::coldStorageOptions)).setter(setter(Builder::coldStorageOptions))
            .constructor(ColdStorageOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColdStorageOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            INSTANCE_COUNT_FIELD, DEDICATED_MASTER_ENABLED_FIELD, ZONE_AWARENESS_ENABLED_FIELD, ZONE_AWARENESS_CONFIG_FIELD,
            DEDICATED_MASTER_TYPE_FIELD, DEDICATED_MASTER_COUNT_FIELD, WARM_ENABLED_FIELD, WARM_TYPE_FIELD, WARM_COUNT_FIELD,
            COLD_STORAGE_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private final Integer instanceCount;

    private final Boolean dedicatedMasterEnabled;

    private final Boolean zoneAwarenessEnabled;

    private final ZoneAwarenessConfig zoneAwarenessConfig;

    private final String dedicatedMasterType;

    private final Integer dedicatedMasterCount;

    private final Boolean warmEnabled;

    private final String warmType;

    private final Integer warmCount;

    private final ColdStorageOptions coldStorageOptions;

    private ElasticsearchClusterConfig(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.dedicatedMasterEnabled = builder.dedicatedMasterEnabled;
        this.zoneAwarenessEnabled = builder.zoneAwarenessEnabled;
        this.zoneAwarenessConfig = builder.zoneAwarenessConfig;
        this.dedicatedMasterType = builder.dedicatedMasterType;
        this.dedicatedMasterCount = builder.dedicatedMasterCount;
        this.warmEnabled = builder.warmEnabled;
        this.warmType = builder.warmType;
        this.warmCount = builder.warmCount;
        this.coldStorageOptions = builder.coldStorageOptions;
    }

    /**
     * <p>
     * The instance type for an Elasticsearch cluster. UltraWarm instance types are not supported for data instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ESPartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type for an Elasticsearch cluster. UltraWarm instance types are not supported for data
     *         instances.
     * @see ESPartitionInstanceType
     */
    public final ESPartitionInstanceType instanceType() {
        return ESPartitionInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type for an Elasticsearch cluster. UltraWarm instance types are not supported for data instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ESPartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type for an Elasticsearch cluster. UltraWarm instance types are not supported for data
     *         instances.
     * @see ESPartitionInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The number of instances in the specified domain cluster.
     * </p>
     * 
     * @return The number of instances in the specified domain cluster.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * A boolean value to indicate whether a dedicated master node is enabled. See <a href=
     * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes"
     * target="_blank">About Dedicated Master Nodes</a> for more information.
     * </p>
     * 
     * @return A boolean value to indicate whether a dedicated master node is enabled. See <a href=
     *         "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes"
     *         target="_blank">About Dedicated Master Nodes</a> for more information.
     */
    public final Boolean dedicatedMasterEnabled() {
        return dedicatedMasterEnabled;
    }

    /**
     * <p>
     * A boolean value to indicate whether zone awareness is enabled. See <a href=
     * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness"
     * target="_blank">About Zone Awareness</a> for more information.
     * </p>
     * 
     * @return A boolean value to indicate whether zone awareness is enabled. See <a href=
     *         "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness"
     *         target="_blank">About Zone Awareness</a> for more information.
     */
    public final Boolean zoneAwarenessEnabled() {
        return zoneAwarenessEnabled;
    }

    /**
     * <p>
     * Specifies the zone awareness configuration for a domain when zone awareness is enabled.
     * </p>
     * 
     * @return Specifies the zone awareness configuration for a domain when zone awareness is enabled.
     */
    public final ZoneAwarenessConfig zoneAwarenessConfig() {
        return zoneAwarenessConfig;
    }

    /**
     * <p>
     * The instance type for a dedicated master node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dedicatedMasterType} will return {@link ESPartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dedicatedMasterTypeAsString}.
     * </p>
     * 
     * @return The instance type for a dedicated master node.
     * @see ESPartitionInstanceType
     */
    public final ESPartitionInstanceType dedicatedMasterType() {
        return ESPartitionInstanceType.fromValue(dedicatedMasterType);
    }

    /**
     * <p>
     * The instance type for a dedicated master node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dedicatedMasterType} will return {@link ESPartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dedicatedMasterTypeAsString}.
     * </p>
     * 
     * @return The instance type for a dedicated master node.
     * @see ESPartitionInstanceType
     */
    public final String dedicatedMasterTypeAsString() {
        return dedicatedMasterType;
    }

    /**
     * <p>
     * Total number of dedicated master nodes, active and on standby, for the cluster.
     * </p>
     * 
     * @return Total number of dedicated master nodes, active and on standby, for the cluster.
     */
    public final Integer dedicatedMasterCount() {
        return dedicatedMasterCount;
    }

    /**
     * <p>
     * True to enable warm storage.
     * </p>
     * 
     * @return True to enable warm storage.
     */
    public final Boolean warmEnabled() {
        return warmEnabled;
    }

    /**
     * <p>
     * The instance type for the Elasticsearch cluster's warm nodes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #warmType} will
     * return {@link ESWarmPartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #warmTypeAsString}.
     * </p>
     * 
     * @return The instance type for the Elasticsearch cluster's warm nodes.
     * @see ESWarmPartitionInstanceType
     */
    public final ESWarmPartitionInstanceType warmType() {
        return ESWarmPartitionInstanceType.fromValue(warmType);
    }

    /**
     * <p>
     * The instance type for the Elasticsearch cluster's warm nodes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #warmType} will
     * return {@link ESWarmPartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #warmTypeAsString}.
     * </p>
     * 
     * @return The instance type for the Elasticsearch cluster's warm nodes.
     * @see ESWarmPartitionInstanceType
     */
    public final String warmTypeAsString() {
        return warmType;
    }

    /**
     * <p>
     * The number of warm nodes in the cluster.
     * </p>
     * 
     * @return The number of warm nodes in the cluster.
     */
    public final Integer warmCount() {
        return warmCount;
    }

    /**
     * <p>
     * Specifies the <code>ColdStorageOptions</code> config for Elasticsearch Domain
     * </p>
     * 
     * @return Specifies the <code>ColdStorageOptions</code> config for Elasticsearch Domain
     */
    public final ColdStorageOptions coldStorageOptions() {
        return coldStorageOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedMasterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(zoneAwarenessEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(zoneAwarenessConfig());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedMasterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedMasterCount());
        hashCode = 31 * hashCode + Objects.hashCode(warmEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(warmTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(warmCount());
        hashCode = 31 * hashCode + Objects.hashCode(coldStorageOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchClusterConfig)) {
            return false;
        }
        ElasticsearchClusterConfig other = (ElasticsearchClusterConfig) obj;
        return Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(dedicatedMasterEnabled(), other.dedicatedMasterEnabled())
                && Objects.equals(zoneAwarenessEnabled(), other.zoneAwarenessEnabled())
                && Objects.equals(zoneAwarenessConfig(), other.zoneAwarenessConfig())
                && Objects.equals(dedicatedMasterTypeAsString(), other.dedicatedMasterTypeAsString())
                && Objects.equals(dedicatedMasterCount(), other.dedicatedMasterCount())
                && Objects.equals(warmEnabled(), other.warmEnabled())
                && Objects.equals(warmTypeAsString(), other.warmTypeAsString()) && Objects.equals(warmCount(), other.warmCount())
                && Objects.equals(coldStorageOptions(), other.coldStorageOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ElasticsearchClusterConfig").add("InstanceType", instanceTypeAsString())
                .add("InstanceCount", instanceCount()).add("DedicatedMasterEnabled", dedicatedMasterEnabled())
                .add("ZoneAwarenessEnabled", zoneAwarenessEnabled()).add("ZoneAwarenessConfig", zoneAwarenessConfig())
                .add("DedicatedMasterType", dedicatedMasterTypeAsString()).add("DedicatedMasterCount", dedicatedMasterCount())
                .add("WarmEnabled", warmEnabled()).add("WarmType", warmTypeAsString()).add("WarmCount", warmCount())
                .add("ColdStorageOptions", coldStorageOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "DedicatedMasterEnabled":
            return Optional.ofNullable(clazz.cast(dedicatedMasterEnabled()));
        case "ZoneAwarenessEnabled":
            return Optional.ofNullable(clazz.cast(zoneAwarenessEnabled()));
        case "ZoneAwarenessConfig":
            return Optional.ofNullable(clazz.cast(zoneAwarenessConfig()));
        case "DedicatedMasterType":
            return Optional.ofNullable(clazz.cast(dedicatedMasterTypeAsString()));
        case "DedicatedMasterCount":
            return Optional.ofNullable(clazz.cast(dedicatedMasterCount()));
        case "WarmEnabled":
            return Optional.ofNullable(clazz.cast(warmEnabled()));
        case "WarmType":
            return Optional.ofNullable(clazz.cast(warmTypeAsString()));
        case "WarmCount":
            return Optional.ofNullable(clazz.cast(warmCount()));
        case "ColdStorageOptions":
            return Optional.ofNullable(clazz.cast(coldStorageOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("DedicatedMasterEnabled", DEDICATED_MASTER_ENABLED_FIELD);
        map.put("ZoneAwarenessEnabled", ZONE_AWARENESS_ENABLED_FIELD);
        map.put("ZoneAwarenessConfig", ZONE_AWARENESS_CONFIG_FIELD);
        map.put("DedicatedMasterType", DEDICATED_MASTER_TYPE_FIELD);
        map.put("DedicatedMasterCount", DEDICATED_MASTER_COUNT_FIELD);
        map.put("WarmEnabled", WARM_ENABLED_FIELD);
        map.put("WarmType", WARM_TYPE_FIELD);
        map.put("WarmCount", WARM_COUNT_FIELD);
        map.put("ColdStorageOptions", COLD_STORAGE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ElasticsearchClusterConfig, T> g) {
        return obj -> g.apply((ElasticsearchClusterConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ElasticsearchClusterConfig> {
        /**
         * <p>
         * The instance type for an Elasticsearch cluster. UltraWarm instance types are not supported for data
         * instances.
         * </p>
         * 
         * @param instanceType
         *        The instance type for an Elasticsearch cluster. UltraWarm instance types are not supported for data
         *        instances.
         * @see ESPartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ESPartitionInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type for an Elasticsearch cluster. UltraWarm instance types are not supported for data
         * instances.
         * </p>
         * 
         * @param instanceType
         *        The instance type for an Elasticsearch cluster. UltraWarm instance types are not supported for data
         *        instances.
         * @see ESPartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ESPartitionInstanceType
         */
        Builder instanceType(ESPartitionInstanceType instanceType);

        /**
         * <p>
         * The number of instances in the specified domain cluster.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances in the specified domain cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * A boolean value to indicate whether a dedicated master node is enabled. See <a href=
         * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes"
         * target="_blank">About Dedicated Master Nodes</a> for more information.
         * </p>
         * 
         * @param dedicatedMasterEnabled
         *        A boolean value to indicate whether a dedicated master node is enabled. See <a href=
         *        "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes"
         *        target="_blank">About Dedicated Master Nodes</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedMasterEnabled(Boolean dedicatedMasterEnabled);

        /**
         * <p>
         * A boolean value to indicate whether zone awareness is enabled. See <a href=
         * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness"
         * target="_blank">About Zone Awareness</a> for more information.
         * </p>
         * 
         * @param zoneAwarenessEnabled
         *        A boolean value to indicate whether zone awareness is enabled. See <a href=
         *        "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness"
         *        target="_blank">About Zone Awareness</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneAwarenessEnabled(Boolean zoneAwarenessEnabled);

        /**
         * <p>
         * Specifies the zone awareness configuration for a domain when zone awareness is enabled.
         * </p>
         * 
         * @param zoneAwarenessConfig
         *        Specifies the zone awareness configuration for a domain when zone awareness is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneAwarenessConfig(ZoneAwarenessConfig zoneAwarenessConfig);

        /**
         * <p>
         * Specifies the zone awareness configuration for a domain when zone awareness is enabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link ZoneAwarenessConfig.Builder} avoiding the
         * need to create one manually via {@link ZoneAwarenessConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ZoneAwarenessConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #zoneAwarenessConfig(ZoneAwarenessConfig)}.
         * 
         * @param zoneAwarenessConfig
         *        a consumer that will call methods on {@link ZoneAwarenessConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zoneAwarenessConfig(ZoneAwarenessConfig)
         */
        default Builder zoneAwarenessConfig(Consumer<ZoneAwarenessConfig.Builder> zoneAwarenessConfig) {
            return zoneAwarenessConfig(ZoneAwarenessConfig.builder().applyMutation(zoneAwarenessConfig).build());
        }

        /**
         * <p>
         * The instance type for a dedicated master node.
         * </p>
         * 
         * @param dedicatedMasterType
         *        The instance type for a dedicated master node.
         * @see ESPartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ESPartitionInstanceType
         */
        Builder dedicatedMasterType(String dedicatedMasterType);

        /**
         * <p>
         * The instance type for a dedicated master node.
         * </p>
         * 
         * @param dedicatedMasterType
         *        The instance type for a dedicated master node.
         * @see ESPartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ESPartitionInstanceType
         */
        Builder dedicatedMasterType(ESPartitionInstanceType dedicatedMasterType);

        /**
         * <p>
         * Total number of dedicated master nodes, active and on standby, for the cluster.
         * </p>
         * 
         * @param dedicatedMasterCount
         *        Total number of dedicated master nodes, active and on standby, for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedMasterCount(Integer dedicatedMasterCount);

        /**
         * <p>
         * True to enable warm storage.
         * </p>
         * 
         * @param warmEnabled
         *        True to enable warm storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmEnabled(Boolean warmEnabled);

        /**
         * <p>
         * The instance type for the Elasticsearch cluster's warm nodes.
         * </p>
         * 
         * @param warmType
         *        The instance type for the Elasticsearch cluster's warm nodes.
         * @see ESWarmPartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ESWarmPartitionInstanceType
         */
        Builder warmType(String warmType);

        /**
         * <p>
         * The instance type for the Elasticsearch cluster's warm nodes.
         * </p>
         * 
         * @param warmType
         *        The instance type for the Elasticsearch cluster's warm nodes.
         * @see ESWarmPartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ESWarmPartitionInstanceType
         */
        Builder warmType(ESWarmPartitionInstanceType warmType);

        /**
         * <p>
         * The number of warm nodes in the cluster.
         * </p>
         * 
         * @param warmCount
         *        The number of warm nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmCount(Integer warmCount);

        /**
         * <p>
         * Specifies the <code>ColdStorageOptions</code> config for Elasticsearch Domain
         * </p>
         * 
         * @param coldStorageOptions
         *        Specifies the <code>ColdStorageOptions</code> config for Elasticsearch Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coldStorageOptions(ColdStorageOptions coldStorageOptions);

        /**
         * <p>
         * Specifies the <code>ColdStorageOptions</code> config for Elasticsearch Domain
         * </p>
         * This is a convenience method that creates an instance of the {@link ColdStorageOptions.Builder} avoiding the
         * need to create one manually via {@link ColdStorageOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColdStorageOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #coldStorageOptions(ColdStorageOptions)}.
         * 
         * @param coldStorageOptions
         *        a consumer that will call methods on {@link ColdStorageOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coldStorageOptions(ColdStorageOptions)
         */
        default Builder coldStorageOptions(Consumer<ColdStorageOptions.Builder> coldStorageOptions) {
            return coldStorageOptions(ColdStorageOptions.builder().applyMutation(coldStorageOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private Integer instanceCount;

        private Boolean dedicatedMasterEnabled;

        private Boolean zoneAwarenessEnabled;

        private ZoneAwarenessConfig zoneAwarenessConfig;

        private String dedicatedMasterType;

        private Integer dedicatedMasterCount;

        private Boolean warmEnabled;

        private String warmType;

        private Integer warmCount;

        private ColdStorageOptions coldStorageOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchClusterConfig model) {
            instanceType(model.instanceType);
            instanceCount(model.instanceCount);
            dedicatedMasterEnabled(model.dedicatedMasterEnabled);
            zoneAwarenessEnabled(model.zoneAwarenessEnabled);
            zoneAwarenessConfig(model.zoneAwarenessConfig);
            dedicatedMasterType(model.dedicatedMasterType);
            dedicatedMasterCount(model.dedicatedMasterCount);
            warmEnabled(model.warmEnabled);
            warmType(model.warmType);
            warmCount(model.warmCount);
            coldStorageOptions(model.coldStorageOptions);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ESPartitionInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Boolean getDedicatedMasterEnabled() {
            return dedicatedMasterEnabled;
        }

        public final void setDedicatedMasterEnabled(Boolean dedicatedMasterEnabled) {
            this.dedicatedMasterEnabled = dedicatedMasterEnabled;
        }

        @Override
        public final Builder dedicatedMasterEnabled(Boolean dedicatedMasterEnabled) {
            this.dedicatedMasterEnabled = dedicatedMasterEnabled;
            return this;
        }

        public final Boolean getZoneAwarenessEnabled() {
            return zoneAwarenessEnabled;
        }

        public final void setZoneAwarenessEnabled(Boolean zoneAwarenessEnabled) {
            this.zoneAwarenessEnabled = zoneAwarenessEnabled;
        }

        @Override
        public final Builder zoneAwarenessEnabled(Boolean zoneAwarenessEnabled) {
            this.zoneAwarenessEnabled = zoneAwarenessEnabled;
            return this;
        }

        public final ZoneAwarenessConfig.Builder getZoneAwarenessConfig() {
            return zoneAwarenessConfig != null ? zoneAwarenessConfig.toBuilder() : null;
        }

        public final void setZoneAwarenessConfig(ZoneAwarenessConfig.BuilderImpl zoneAwarenessConfig) {
            this.zoneAwarenessConfig = zoneAwarenessConfig != null ? zoneAwarenessConfig.build() : null;
        }

        @Override
        public final Builder zoneAwarenessConfig(ZoneAwarenessConfig zoneAwarenessConfig) {
            this.zoneAwarenessConfig = zoneAwarenessConfig;
            return this;
        }

        public final String getDedicatedMasterType() {
            return dedicatedMasterType;
        }

        public final void setDedicatedMasterType(String dedicatedMasterType) {
            this.dedicatedMasterType = dedicatedMasterType;
        }

        @Override
        public final Builder dedicatedMasterType(String dedicatedMasterType) {
            this.dedicatedMasterType = dedicatedMasterType;
            return this;
        }

        @Override
        public final Builder dedicatedMasterType(ESPartitionInstanceType dedicatedMasterType) {
            this.dedicatedMasterType(dedicatedMasterType == null ? null : dedicatedMasterType.toString());
            return this;
        }

        public final Integer getDedicatedMasterCount() {
            return dedicatedMasterCount;
        }

        public final void setDedicatedMasterCount(Integer dedicatedMasterCount) {
            this.dedicatedMasterCount = dedicatedMasterCount;
        }

        @Override
        public final Builder dedicatedMasterCount(Integer dedicatedMasterCount) {
            this.dedicatedMasterCount = dedicatedMasterCount;
            return this;
        }

        public final Boolean getWarmEnabled() {
            return warmEnabled;
        }

        public final void setWarmEnabled(Boolean warmEnabled) {
            this.warmEnabled = warmEnabled;
        }

        @Override
        public final Builder warmEnabled(Boolean warmEnabled) {
            this.warmEnabled = warmEnabled;
            return this;
        }

        public final String getWarmType() {
            return warmType;
        }

        public final void setWarmType(String warmType) {
            this.warmType = warmType;
        }

        @Override
        public final Builder warmType(String warmType) {
            this.warmType = warmType;
            return this;
        }

        @Override
        public final Builder warmType(ESWarmPartitionInstanceType warmType) {
            this.warmType(warmType == null ? null : warmType.toString());
            return this;
        }

        public final Integer getWarmCount() {
            return warmCount;
        }

        public final void setWarmCount(Integer warmCount) {
            this.warmCount = warmCount;
        }

        @Override
        public final Builder warmCount(Integer warmCount) {
            this.warmCount = warmCount;
            return this;
        }

        public final ColdStorageOptions.Builder getColdStorageOptions() {
            return coldStorageOptions != null ? coldStorageOptions.toBuilder() : null;
        }

        public final void setColdStorageOptions(ColdStorageOptions.BuilderImpl coldStorageOptions) {
            this.coldStorageOptions = coldStorageOptions != null ? coldStorageOptions.build() : null;
        }

        @Override
        public final Builder coldStorageOptions(ColdStorageOptions coldStorageOptions) {
            this.coldStorageOptions = coldStorageOptions;
            return this;
        }

        @Override
        public ElasticsearchClusterConfig build() {
            return new ElasticsearchClusterConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
