/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies Auto-Tune maitenance schedule. See the <a
 * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
 * target="_blank">Developer Guide</a> for more information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoTuneMaintenanceSchedule implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoTuneMaintenanceSchedule.Builder, AutoTuneMaintenanceSchedule> {
    private static final SdkField<Instant> START_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartAt").getter(getter(AutoTuneMaintenanceSchedule::startAt)).setter(setter(Builder::startAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartAt").build()).build();

    private static final SdkField<Duration> DURATION_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("Duration").getter(getter(AutoTuneMaintenanceSchedule::duration)).setter(setter(Builder::duration))
            .constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<String> CRON_EXPRESSION_FOR_RECURRENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CronExpressionForRecurrence")
            .getter(getter(AutoTuneMaintenanceSchedule::cronExpressionForRecurrence))
            .setter(setter(Builder::cronExpressionForRecurrence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CronExpressionForRecurrence")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_AT_FIELD,
            DURATION_FIELD, CRON_EXPRESSION_FOR_RECURRENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant startAt;

    private final Duration duration;

    private final String cronExpressionForRecurrence;

    private AutoTuneMaintenanceSchedule(BuilderImpl builder) {
        this.startAt = builder.startAt;
        this.duration = builder.duration;
        this.cronExpressionForRecurrence = builder.cronExpressionForRecurrence;
    }

    /**
     * <p>
     * Specifies timestamp at which Auto-Tune maintenance schedule start.
     * </p>
     * 
     * @return Specifies timestamp at which Auto-Tune maintenance schedule start.
     */
    public final Instant startAt() {
        return startAt;
    }

    /**
     * <p>
     * Specifies maintenance schedule duration: duration value and duration unit. See the <a
     * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
     * target="_blank">Developer Guide</a> for more information.
     * </p>
     * 
     * @return Specifies maintenance schedule duration: duration value and duration unit. See the <a
     *         href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
     *         target="_blank">Developer Guide</a> for more information.
     */
    public final Duration duration() {
        return duration;
    }

    /**
     * <p>
     * Specifies cron expression for a recurring maintenance schedule. See the <a
     * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
     * target="_blank">Developer Guide</a> for more information.
     * </p>
     * 
     * @return Specifies cron expression for a recurring maintenance schedule. See the <a
     *         href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
     *         target="_blank">Developer Guide</a> for more information.
     */
    public final String cronExpressionForRecurrence() {
        return cronExpressionForRecurrence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startAt());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(cronExpressionForRecurrence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoTuneMaintenanceSchedule)) {
            return false;
        }
        AutoTuneMaintenanceSchedule other = (AutoTuneMaintenanceSchedule) obj;
        return Objects.equals(startAt(), other.startAt()) && Objects.equals(duration(), other.duration())
                && Objects.equals(cronExpressionForRecurrence(), other.cronExpressionForRecurrence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoTuneMaintenanceSchedule").add("StartAt", startAt()).add("Duration", duration())
                .add("CronExpressionForRecurrence", cronExpressionForRecurrence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartAt":
            return Optional.ofNullable(clazz.cast(startAt()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "CronExpressionForRecurrence":
            return Optional.ofNullable(clazz.cast(cronExpressionForRecurrence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartAt", START_AT_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("CronExpressionForRecurrence", CRON_EXPRESSION_FOR_RECURRENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoTuneMaintenanceSchedule, T> g) {
        return obj -> g.apply((AutoTuneMaintenanceSchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoTuneMaintenanceSchedule> {
        /**
         * <p>
         * Specifies timestamp at which Auto-Tune maintenance schedule start.
         * </p>
         * 
         * @param startAt
         *        Specifies timestamp at which Auto-Tune maintenance schedule start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startAt(Instant startAt);

        /**
         * <p>
         * Specifies maintenance schedule duration: duration value and duration unit. See the <a
         * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         * target="_blank">Developer Guide</a> for more information.
         * </p>
         * 
         * @param duration
         *        Specifies maintenance schedule duration: duration value and duration unit. See the <a
         *        href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         *        target="_blank">Developer Guide</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Duration duration);

        /**
         * <p>
         * Specifies maintenance schedule duration: duration value and duration unit. See the <a
         * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         * target="_blank">Developer Guide</a> for more information.
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #duration(Duration)}.
         * 
         * @param duration
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #duration(Duration)
         */
        default Builder duration(Consumer<Duration.Builder> duration) {
            return duration(Duration.builder().applyMutation(duration).build());
        }

        /**
         * <p>
         * Specifies cron expression for a recurring maintenance schedule. See the <a
         * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         * target="_blank">Developer Guide</a> for more information.
         * </p>
         * 
         * @param cronExpressionForRecurrence
         *        Specifies cron expression for a recurring maintenance schedule. See the <a
         *        href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         *        target="_blank">Developer Guide</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cronExpressionForRecurrence(String cronExpressionForRecurrence);
    }

    static final class BuilderImpl implements Builder {
        private Instant startAt;

        private Duration duration;

        private String cronExpressionForRecurrence;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoTuneMaintenanceSchedule model) {
            startAt(model.startAt);
            duration(model.duration);
            cronExpressionForRecurrence(model.cronExpressionForRecurrence);
        }

        public final Instant getStartAt() {
            return startAt;
        }

        public final void setStartAt(Instant startAt) {
            this.startAt = startAt;
        }

        @Override
        public final Builder startAt(Instant startAt) {
            this.startAt = startAt;
            return this;
        }

        public final Duration.Builder getDuration() {
            return duration != null ? duration.toBuilder() : null;
        }

        public final void setDuration(Duration.BuilderImpl duration) {
            this.duration = duration != null ? duration.build() : null;
        }

        @Override
        public final Builder duration(Duration duration) {
            this.duration = duration;
            return this;
        }

        public final String getCronExpressionForRecurrence() {
            return cronExpressionForRecurrence;
        }

        public final void setCronExpressionForRecurrence(String cronExpressionForRecurrence) {
            this.cronExpressionForRecurrence = cronExpressionForRecurrence;
        }

        @Override
        public final Builder cronExpressionForRecurrence(String cronExpressionForRecurrence) {
            this.cronExpressionForRecurrence = cronExpressionForRecurrence;
            return this;
        }

        @Override
        public AutoTuneMaintenanceSchedule build() {
            return new AutoTuneMaintenanceSchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
