/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryResponse;

public class GetPackageVersionHistoryIterable
implements SdkIterable<GetPackageVersionHistoryResponse> {
    private final ElasticsearchClient client;
    private final GetPackageVersionHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetPackageVersionHistoryIterable(ElasticsearchClient client, GetPackageVersionHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetPackageVersionHistoryResponseFetcher();
    }

    public Iterator<GetPackageVersionHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetPackageVersionHistoryResponseFetcher
    implements SyncPageFetcher<GetPackageVersionHistoryResponse> {
        private GetPackageVersionHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetPackageVersionHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetPackageVersionHistoryResponse nextPage(GetPackageVersionHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetPackageVersionHistoryIterable.this.client.getPackageVersionHistory(GetPackageVersionHistoryIterable.this.firstRequest);
            }
            return GetPackageVersionHistoryIterable.this.client.getPackageVersionHistory((GetPackageVersionHistoryRequest)((Object)GetPackageVersionHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

