/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.AccessPoliciesStatus;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.ChangeProgressDetails;
import software.amazon.awssdk.services.elasticsearch.model.CognitoOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.EBSOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfigStatus;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchVersionStatus;
import software.amazon.awssdk.services.elasticsearch.model.EncryptionAtRestOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.ModifyingProperties;
import software.amazon.awssdk.services.elasticsearch.model.ModifyingPropertiesListCopier;
import software.amazon.awssdk.services.elasticsearch.model.NodeToNodeEncryptionOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.SnapshotOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfoStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticsearchDomainConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ElasticsearchDomainConfig> {
    private static final SdkField<ElasticsearchVersionStatus> ELASTICSEARCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ElasticsearchVersion").getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::elasticsearchVersion)).setter(ElasticsearchDomainConfig.setter(Builder::elasticsearchVersion)).constructor(ElasticsearchVersionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchVersion").build()}).build();
    private static final SdkField<ElasticsearchClusterConfigStatus> ELASTICSEARCH_CLUSTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ElasticsearchClusterConfig").getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::elasticsearchClusterConfig)).setter(ElasticsearchDomainConfig.setter(Builder::elasticsearchClusterConfig)).constructor(ElasticsearchClusterConfigStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchClusterConfig").build()}).build();
    private static final SdkField<EBSOptionsStatus> EBS_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EBSOptions").getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::ebsOptions)).setter(ElasticsearchDomainConfig.setter(Builder::ebsOptions)).constructor(EBSOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSOptions").build()}).build();
    private static final SdkField<AccessPoliciesStatus> ACCESS_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessPolicies").getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::accessPolicies)).setter(ElasticsearchDomainConfig.setter(Builder::accessPolicies)).constructor(AccessPoliciesStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()}).build();
    private static final SdkField<SnapshotOptionsStatus> SNAPSHOT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnapshotOptions").getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::snapshotOptions)).setter(ElasticsearchDomainConfig.setter(Builder::snapshotOptions)).constructor(SnapshotOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotOptions").build()}).build();
    private static final SdkField<VPCDerivedInfoStatus> VPC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VPCOptions").getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::vpcOptions)).setter(ElasticsearchDomainConfig.setter(Builder::vpcOptions)).constructor(VPCDerivedInfoStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCOptions").build()}).build();
    private static final SdkField<CognitoOptionsStatus> COGNITO_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CognitoOptions").getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::cognitoOptions)).setter(ElasticsearchDomainConfig.setter(Builder::cognitoOptions)).constructor(CognitoOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoOptions").build()}).build();
    private static final SdkField<EncryptionAtRestOptionsStatus> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionAtRestOptions").getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::encryptionAtRestOptions)).setter(ElasticsearchDomainConfig.setter(Builder::encryptionAtRestOptions)).constructor(EncryptionAtRestOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build()}).build();
    private static final SdkField<NodeToNodeEncryptionOptionsStatus> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NodeToNodeEncryptionOptions").getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::nodeToNodeEncryptionOptions)).setter(ElasticsearchDomainConfig.setter(Builder::nodeToNodeEncryptionOptions)).constructor(NodeToNodeEncryptionOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions").build()}).build();
    private static final SdkField<AdvancedOptionsStatus> ADVANCED_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdvancedOptions").getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::advancedOptions)).setter(ElasticsearchDomainConfig.setter(Builder::advancedOptions)).constructor(AdvancedOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build()}).build();
    private static final SdkField<LogPublishingOptionsStatus> LOG_PUBLISHING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogPublishingOptions").getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::logPublishingOptions)).setter(ElasticsearchDomainConfig.setter(Builder::logPublishingOptions)).constructor(LogPublishingOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build()}).build();
    private static final SdkField<DomainEndpointOptionsStatus> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainEndpointOptions").getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::domainEndpointOptions)).setter(ElasticsearchDomainConfig.setter(Builder::domainEndpointOptions)).constructor(DomainEndpointOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build()}).build();
    private static final SdkField<AdvancedSecurityOptionsStatus> ADVANCED_SECURITY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdvancedSecurityOptions").getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::advancedSecurityOptions)).setter(ElasticsearchDomainConfig.setter(Builder::advancedSecurityOptions)).constructor(AdvancedSecurityOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedSecurityOptions").build()}).build();
    private static final SdkField<AutoTuneOptionsStatus> AUTO_TUNE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoTuneOptions").getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::autoTuneOptions)).setter(ElasticsearchDomainConfig.setter(Builder::autoTuneOptions)).constructor(AutoTuneOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTuneOptions").build()}).build();
    private static final SdkField<ChangeProgressDetails> CHANGE_PROGRESS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChangeProgressDetails").getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::changeProgressDetails)).setter(ElasticsearchDomainConfig.setter(Builder::changeProgressDetails)).constructor(ChangeProgressDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeProgressDetails").build()}).build();
    private static final SdkField<List<ModifyingProperties>> MODIFYING_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModifyingProperties").getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::modifyingProperties)).setter(ElasticsearchDomainConfig.setter(Builder::modifyingProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifyingProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModifyingProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTICSEARCH_VERSION_FIELD, ELASTICSEARCH_CLUSTER_CONFIG_FIELD, EBS_OPTIONS_FIELD, ACCESS_POLICIES_FIELD, SNAPSHOT_OPTIONS_FIELD, VPC_OPTIONS_FIELD, COGNITO_OPTIONS_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD, NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD, ADVANCED_OPTIONS_FIELD, LOG_PUBLISHING_OPTIONS_FIELD, DOMAIN_ENDPOINT_OPTIONS_FIELD, ADVANCED_SECURITY_OPTIONS_FIELD, AUTO_TUNE_OPTIONS_FIELD, CHANGE_PROGRESS_DETAILS_FIELD, MODIFYING_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ElasticsearchDomainConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ElasticsearchVersionStatus elasticsearchVersion;
    private final ElasticsearchClusterConfigStatus elasticsearchClusterConfig;
    private final EBSOptionsStatus ebsOptions;
    private final AccessPoliciesStatus accessPolicies;
    private final SnapshotOptionsStatus snapshotOptions;
    private final VPCDerivedInfoStatus vpcOptions;
    private final CognitoOptionsStatus cognitoOptions;
    private final EncryptionAtRestOptionsStatus encryptionAtRestOptions;
    private final NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions;
    private final AdvancedOptionsStatus advancedOptions;
    private final LogPublishingOptionsStatus logPublishingOptions;
    private final DomainEndpointOptionsStatus domainEndpointOptions;
    private final AdvancedSecurityOptionsStatus advancedSecurityOptions;
    private final AutoTuneOptionsStatus autoTuneOptions;
    private final ChangeProgressDetails changeProgressDetails;
    private final List<ModifyingProperties> modifyingProperties;

    private ElasticsearchDomainConfig(BuilderImpl builder) {
        this.elasticsearchVersion = builder.elasticsearchVersion;
        this.elasticsearchClusterConfig = builder.elasticsearchClusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.accessPolicies = builder.accessPolicies;
        this.snapshotOptions = builder.snapshotOptions;
        this.vpcOptions = builder.vpcOptions;
        this.cognitoOptions = builder.cognitoOptions;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.advancedOptions = builder.advancedOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.advancedSecurityOptions = builder.advancedSecurityOptions;
        this.autoTuneOptions = builder.autoTuneOptions;
        this.changeProgressDetails = builder.changeProgressDetails;
        this.modifyingProperties = builder.modifyingProperties;
    }

    public final ElasticsearchVersionStatus elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public final ElasticsearchClusterConfigStatus elasticsearchClusterConfig() {
        return this.elasticsearchClusterConfig;
    }

    public final EBSOptionsStatus ebsOptions() {
        return this.ebsOptions;
    }

    public final AccessPoliciesStatus accessPolicies() {
        return this.accessPolicies;
    }

    public final SnapshotOptionsStatus snapshotOptions() {
        return this.snapshotOptions;
    }

    public final VPCDerivedInfoStatus vpcOptions() {
        return this.vpcOptions;
    }

    public final CognitoOptionsStatus cognitoOptions() {
        return this.cognitoOptions;
    }

    public final EncryptionAtRestOptionsStatus encryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    public final NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions() {
        return this.nodeToNodeEncryptionOptions;
    }

    public final AdvancedOptionsStatus advancedOptions() {
        return this.advancedOptions;
    }

    public final LogPublishingOptionsStatus logPublishingOptions() {
        return this.logPublishingOptions;
    }

    public final DomainEndpointOptionsStatus domainEndpointOptions() {
        return this.domainEndpointOptions;
    }

    public final AdvancedSecurityOptionsStatus advancedSecurityOptions() {
        return this.advancedSecurityOptions;
    }

    public final AutoTuneOptionsStatus autoTuneOptions() {
        return this.autoTuneOptions;
    }

    public final ChangeProgressDetails changeProgressDetails() {
        return this.changeProgressDetails;
    }

    public final boolean hasModifyingProperties() {
        return this.modifyingProperties != null && !(this.modifyingProperties instanceof SdkAutoConstructList);
    }

    public final List<ModifyingProperties> modifyingProperties() {
        return this.modifyingProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchClusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedSecurityOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoTuneOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeProgressDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModifyingProperties() ? this.modifyingProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDomainConfig)) {
            return false;
        }
        ElasticsearchDomainConfig other = (ElasticsearchDomainConfig)obj;
        return Objects.equals(this.elasticsearchVersion(), other.elasticsearchVersion()) && Objects.equals(this.elasticsearchClusterConfig(), other.elasticsearchClusterConfig()) && Objects.equals(this.ebsOptions(), other.ebsOptions()) && Objects.equals(this.accessPolicies(), other.accessPolicies()) && Objects.equals(this.snapshotOptions(), other.snapshotOptions()) && Objects.equals(this.vpcOptions(), other.vpcOptions()) && Objects.equals(this.cognitoOptions(), other.cognitoOptions()) && Objects.equals(this.encryptionAtRestOptions(), other.encryptionAtRestOptions()) && Objects.equals(this.nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions()) && Objects.equals(this.advancedOptions(), other.advancedOptions()) && Objects.equals(this.logPublishingOptions(), other.logPublishingOptions()) && Objects.equals(this.domainEndpointOptions(), other.domainEndpointOptions()) && Objects.equals(this.advancedSecurityOptions(), other.advancedSecurityOptions()) && Objects.equals(this.autoTuneOptions(), other.autoTuneOptions()) && Objects.equals(this.changeProgressDetails(), other.changeProgressDetails()) && this.hasModifyingProperties() == other.hasModifyingProperties() && Objects.equals(this.modifyingProperties(), other.modifyingProperties());
    }

    public final String toString() {
        return ToString.builder((String)"ElasticsearchDomainConfig").add("ElasticsearchVersion", (Object)this.elasticsearchVersion()).add("ElasticsearchClusterConfig", (Object)this.elasticsearchClusterConfig()).add("EBSOptions", (Object)this.ebsOptions()).add("AccessPolicies", (Object)this.accessPolicies()).add("SnapshotOptions", (Object)this.snapshotOptions()).add("VPCOptions", (Object)this.vpcOptions()).add("CognitoOptions", (Object)this.cognitoOptions()).add("EncryptionAtRestOptions", (Object)this.encryptionAtRestOptions()).add("NodeToNodeEncryptionOptions", (Object)this.nodeToNodeEncryptionOptions()).add("AdvancedOptions", (Object)this.advancedOptions()).add("LogPublishingOptions", (Object)this.logPublishingOptions()).add("DomainEndpointOptions", (Object)this.domainEndpointOptions()).add("AdvancedSecurityOptions", (Object)this.advancedSecurityOptions()).add("AutoTuneOptions", (Object)this.autoTuneOptions()).add("ChangeProgressDetails", (Object)this.changeProgressDetails()).add("ModifyingProperties", this.hasModifyingProperties() ? this.modifyingProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticsearchVersion": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchVersion()));
            }
            case "ElasticsearchClusterConfig": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchClusterConfig()));
            }
            case "EBSOptions": {
                return Optional.ofNullable(clazz.cast(this.ebsOptions()));
            }
            case "AccessPolicies": {
                return Optional.ofNullable(clazz.cast(this.accessPolicies()));
            }
            case "SnapshotOptions": {
                return Optional.ofNullable(clazz.cast(this.snapshotOptions()));
            }
            case "VPCOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcOptions()));
            }
            case "CognitoOptions": {
                return Optional.ofNullable(clazz.cast(this.cognitoOptions()));
            }
            case "EncryptionAtRestOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRestOptions()));
            }
            case "NodeToNodeEncryptionOptions": {
                return Optional.ofNullable(clazz.cast(this.nodeToNodeEncryptionOptions()));
            }
            case "AdvancedOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedOptions()));
            }
            case "LogPublishingOptions": {
                return Optional.ofNullable(clazz.cast(this.logPublishingOptions()));
            }
            case "DomainEndpointOptions": {
                return Optional.ofNullable(clazz.cast(this.domainEndpointOptions()));
            }
            case "AdvancedSecurityOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedSecurityOptions()));
            }
            case "AutoTuneOptions": {
                return Optional.ofNullable(clazz.cast(this.autoTuneOptions()));
            }
            case "ChangeProgressDetails": {
                return Optional.ofNullable(clazz.cast(this.changeProgressDetails()));
            }
            case "ModifyingProperties": {
                return Optional.ofNullable(clazz.cast(this.modifyingProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ElasticsearchVersion", ELASTICSEARCH_VERSION_FIELD);
        map.put("ElasticsearchClusterConfig", ELASTICSEARCH_CLUSTER_CONFIG_FIELD);
        map.put("EBSOptions", EBS_OPTIONS_FIELD);
        map.put("AccessPolicies", ACCESS_POLICIES_FIELD);
        map.put("SnapshotOptions", SNAPSHOT_OPTIONS_FIELD);
        map.put("VPCOptions", VPC_OPTIONS_FIELD);
        map.put("CognitoOptions", COGNITO_OPTIONS_FIELD);
        map.put("EncryptionAtRestOptions", ENCRYPTION_AT_REST_OPTIONS_FIELD);
        map.put("NodeToNodeEncryptionOptions", NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD);
        map.put("AdvancedOptions", ADVANCED_OPTIONS_FIELD);
        map.put("LogPublishingOptions", LOG_PUBLISHING_OPTIONS_FIELD);
        map.put("DomainEndpointOptions", DOMAIN_ENDPOINT_OPTIONS_FIELD);
        map.put("AdvancedSecurityOptions", ADVANCED_SECURITY_OPTIONS_FIELD);
        map.put("AutoTuneOptions", AUTO_TUNE_OPTIONS_FIELD);
        map.put("ChangeProgressDetails", CHANGE_PROGRESS_DETAILS_FIELD);
        map.put("ModifyingProperties", MODIFYING_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ElasticsearchDomainConfig, T> g) {
        return obj -> g.apply((ElasticsearchDomainConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ElasticsearchVersionStatus elasticsearchVersion;
        private ElasticsearchClusterConfigStatus elasticsearchClusterConfig;
        private EBSOptionsStatus ebsOptions;
        private AccessPoliciesStatus accessPolicies;
        private SnapshotOptionsStatus snapshotOptions;
        private VPCDerivedInfoStatus vpcOptions;
        private CognitoOptionsStatus cognitoOptions;
        private EncryptionAtRestOptionsStatus encryptionAtRestOptions;
        private NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions;
        private AdvancedOptionsStatus advancedOptions;
        private LogPublishingOptionsStatus logPublishingOptions;
        private DomainEndpointOptionsStatus domainEndpointOptions;
        private AdvancedSecurityOptionsStatus advancedSecurityOptions;
        private AutoTuneOptionsStatus autoTuneOptions;
        private ChangeProgressDetails changeProgressDetails;
        private List<ModifyingProperties> modifyingProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDomainConfig model) {
            this.elasticsearchVersion(model.elasticsearchVersion);
            this.elasticsearchClusterConfig(model.elasticsearchClusterConfig);
            this.ebsOptions(model.ebsOptions);
            this.accessPolicies(model.accessPolicies);
            this.snapshotOptions(model.snapshotOptions);
            this.vpcOptions(model.vpcOptions);
            this.cognitoOptions(model.cognitoOptions);
            this.encryptionAtRestOptions(model.encryptionAtRestOptions);
            this.nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            this.advancedOptions(model.advancedOptions);
            this.logPublishingOptions(model.logPublishingOptions);
            this.domainEndpointOptions(model.domainEndpointOptions);
            this.advancedSecurityOptions(model.advancedSecurityOptions);
            this.autoTuneOptions(model.autoTuneOptions);
            this.changeProgressDetails(model.changeProgressDetails);
            this.modifyingProperties(model.modifyingProperties);
        }

        public final ElasticsearchVersionStatus.Builder getElasticsearchVersion() {
            return this.elasticsearchVersion != null ? this.elasticsearchVersion.toBuilder() : null;
        }

        public final void setElasticsearchVersion(ElasticsearchVersionStatus.BuilderImpl elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion != null ? elasticsearchVersion.build() : null;
        }

        @Override
        public final Builder elasticsearchVersion(ElasticsearchVersionStatus elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final ElasticsearchClusterConfigStatus.Builder getElasticsearchClusterConfig() {
            return this.elasticsearchClusterConfig != null ? this.elasticsearchClusterConfig.toBuilder() : null;
        }

        public final void setElasticsearchClusterConfig(ElasticsearchClusterConfigStatus.BuilderImpl elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig != null ? elasticsearchClusterConfig.build() : null;
        }

        @Override
        public final Builder elasticsearchClusterConfig(ElasticsearchClusterConfigStatus elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
            return this;
        }

        public final EBSOptionsStatus.Builder getEbsOptions() {
            return this.ebsOptions != null ? this.ebsOptions.toBuilder() : null;
        }

        public final void setEbsOptions(EBSOptionsStatus.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        @Override
        public final Builder ebsOptions(EBSOptionsStatus ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final AccessPoliciesStatus.Builder getAccessPolicies() {
            return this.accessPolicies != null ? this.accessPolicies.toBuilder() : null;
        }

        public final void setAccessPolicies(AccessPoliciesStatus.BuilderImpl accessPolicies) {
            this.accessPolicies = accessPolicies != null ? accessPolicies.build() : null;
        }

        @Override
        public final Builder accessPolicies(AccessPoliciesStatus accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final SnapshotOptionsStatus.Builder getSnapshotOptions() {
            return this.snapshotOptions != null ? this.snapshotOptions.toBuilder() : null;
        }

        public final void setSnapshotOptions(SnapshotOptionsStatus.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptionsStatus snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final VPCDerivedInfoStatus.Builder getVpcOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(VPCDerivedInfoStatus.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(VPCDerivedInfoStatus vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final CognitoOptionsStatus.Builder getCognitoOptions() {
            return this.cognitoOptions != null ? this.cognitoOptions.toBuilder() : null;
        }

        public final void setCognitoOptions(CognitoOptionsStatus.BuilderImpl cognitoOptions) {
            this.cognitoOptions = cognitoOptions != null ? cognitoOptions.build() : null;
        }

        @Override
        public final Builder cognitoOptions(CognitoOptionsStatus cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        public final EncryptionAtRestOptionsStatus.Builder getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(EncryptionAtRestOptionsStatus.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(EncryptionAtRestOptionsStatus encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final NodeToNodeEncryptionOptionsStatus.Builder getNodeToNodeEncryptionOptions() {
            return this.nodeToNodeEncryptionOptions != null ? this.nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        public final void setNodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        @Override
        public final Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final AdvancedOptionsStatus.Builder getAdvancedOptions() {
            return this.advancedOptions != null ? this.advancedOptions.toBuilder() : null;
        }

        public final void setAdvancedOptions(AdvancedOptionsStatus.BuilderImpl advancedOptions) {
            this.advancedOptions = advancedOptions != null ? advancedOptions.build() : null;
        }

        @Override
        public final Builder advancedOptions(AdvancedOptionsStatus advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        public final LogPublishingOptionsStatus.Builder getLogPublishingOptions() {
            return this.logPublishingOptions != null ? this.logPublishingOptions.toBuilder() : null;
        }

        public final void setLogPublishingOptions(LogPublishingOptionsStatus.BuilderImpl logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions != null ? logPublishingOptions.build() : null;
        }

        @Override
        public final Builder logPublishingOptions(LogPublishingOptionsStatus logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        public final DomainEndpointOptionsStatus.Builder getDomainEndpointOptions() {
            return this.domainEndpointOptions != null ? this.domainEndpointOptions.toBuilder() : null;
        }

        public final void setDomainEndpointOptions(DomainEndpointOptionsStatus.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        @Override
        public final Builder domainEndpointOptions(DomainEndpointOptionsStatus domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final AdvancedSecurityOptionsStatus.Builder getAdvancedSecurityOptions() {
            return this.advancedSecurityOptions != null ? this.advancedSecurityOptions.toBuilder() : null;
        }

        public final void setAdvancedSecurityOptions(AdvancedSecurityOptionsStatus.BuilderImpl advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions != null ? advancedSecurityOptions.build() : null;
        }

        @Override
        public final Builder advancedSecurityOptions(AdvancedSecurityOptionsStatus advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        public final AutoTuneOptionsStatus.Builder getAutoTuneOptions() {
            return this.autoTuneOptions != null ? this.autoTuneOptions.toBuilder() : null;
        }

        public final void setAutoTuneOptions(AutoTuneOptionsStatus.BuilderImpl autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions != null ? autoTuneOptions.build() : null;
        }

        @Override
        public final Builder autoTuneOptions(AutoTuneOptionsStatus autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions;
            return this;
        }

        public final ChangeProgressDetails.Builder getChangeProgressDetails() {
            return this.changeProgressDetails != null ? this.changeProgressDetails.toBuilder() : null;
        }

        public final void setChangeProgressDetails(ChangeProgressDetails.BuilderImpl changeProgressDetails) {
            this.changeProgressDetails = changeProgressDetails != null ? changeProgressDetails.build() : null;
        }

        @Override
        public final Builder changeProgressDetails(ChangeProgressDetails changeProgressDetails) {
            this.changeProgressDetails = changeProgressDetails;
            return this;
        }

        public final List<ModifyingProperties.Builder> getModifyingProperties() {
            List<ModifyingProperties.Builder> result = ModifyingPropertiesListCopier.copyToBuilder(this.modifyingProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModifyingProperties(Collection<ModifyingProperties.BuilderImpl> modifyingProperties) {
            this.modifyingProperties = ModifyingPropertiesListCopier.copyFromBuilder(modifyingProperties);
        }

        @Override
        public final Builder modifyingProperties(Collection<ModifyingProperties> modifyingProperties) {
            this.modifyingProperties = ModifyingPropertiesListCopier.copy(modifyingProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modifyingProperties(ModifyingProperties ... modifyingProperties) {
            this.modifyingProperties(Arrays.asList(modifyingProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modifyingProperties(Consumer<ModifyingProperties.Builder> ... modifyingProperties) {
            this.modifyingProperties(Stream.of(modifyingProperties).map(c -> (ModifyingProperties)((ModifyingProperties.Builder)ModifyingProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ElasticsearchDomainConfig build() {
            return new ElasticsearchDomainConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ElasticsearchDomainConfig> {
        public Builder elasticsearchVersion(ElasticsearchVersionStatus var1);

        default public Builder elasticsearchVersion(Consumer<ElasticsearchVersionStatus.Builder> elasticsearchVersion) {
            return this.elasticsearchVersion((ElasticsearchVersionStatus)((ElasticsearchVersionStatus.Builder)ElasticsearchVersionStatus.builder().applyMutation(elasticsearchVersion)).build());
        }

        public Builder elasticsearchClusterConfig(ElasticsearchClusterConfigStatus var1);

        default public Builder elasticsearchClusterConfig(Consumer<ElasticsearchClusterConfigStatus.Builder> elasticsearchClusterConfig) {
            return this.elasticsearchClusterConfig((ElasticsearchClusterConfigStatus)((ElasticsearchClusterConfigStatus.Builder)ElasticsearchClusterConfigStatus.builder().applyMutation(elasticsearchClusterConfig)).build());
        }

        public Builder ebsOptions(EBSOptionsStatus var1);

        default public Builder ebsOptions(Consumer<EBSOptionsStatus.Builder> ebsOptions) {
            return this.ebsOptions((EBSOptionsStatus)((EBSOptionsStatus.Builder)EBSOptionsStatus.builder().applyMutation(ebsOptions)).build());
        }

        public Builder accessPolicies(AccessPoliciesStatus var1);

        default public Builder accessPolicies(Consumer<AccessPoliciesStatus.Builder> accessPolicies) {
            return this.accessPolicies((AccessPoliciesStatus)((AccessPoliciesStatus.Builder)AccessPoliciesStatus.builder().applyMutation(accessPolicies)).build());
        }

        public Builder snapshotOptions(SnapshotOptionsStatus var1);

        default public Builder snapshotOptions(Consumer<SnapshotOptionsStatus.Builder> snapshotOptions) {
            return this.snapshotOptions((SnapshotOptionsStatus)((SnapshotOptionsStatus.Builder)SnapshotOptionsStatus.builder().applyMutation(snapshotOptions)).build());
        }

        public Builder vpcOptions(VPCDerivedInfoStatus var1);

        default public Builder vpcOptions(Consumer<VPCDerivedInfoStatus.Builder> vpcOptions) {
            return this.vpcOptions((VPCDerivedInfoStatus)((VPCDerivedInfoStatus.Builder)VPCDerivedInfoStatus.builder().applyMutation(vpcOptions)).build());
        }

        public Builder cognitoOptions(CognitoOptionsStatus var1);

        default public Builder cognitoOptions(Consumer<CognitoOptionsStatus.Builder> cognitoOptions) {
            return this.cognitoOptions((CognitoOptionsStatus)((CognitoOptionsStatus.Builder)CognitoOptionsStatus.builder().applyMutation(cognitoOptions)).build());
        }

        public Builder encryptionAtRestOptions(EncryptionAtRestOptionsStatus var1);

        default public Builder encryptionAtRestOptions(Consumer<EncryptionAtRestOptionsStatus.Builder> encryptionAtRestOptions) {
            return this.encryptionAtRestOptions((EncryptionAtRestOptionsStatus)((EncryptionAtRestOptionsStatus.Builder)EncryptionAtRestOptionsStatus.builder().applyMutation(encryptionAtRestOptions)).build());
        }

        public Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus var1);

        default public Builder nodeToNodeEncryptionOptions(Consumer<NodeToNodeEncryptionOptionsStatus.Builder> nodeToNodeEncryptionOptions) {
            return this.nodeToNodeEncryptionOptions((NodeToNodeEncryptionOptionsStatus)((NodeToNodeEncryptionOptionsStatus.Builder)NodeToNodeEncryptionOptionsStatus.builder().applyMutation(nodeToNodeEncryptionOptions)).build());
        }

        public Builder advancedOptions(AdvancedOptionsStatus var1);

        default public Builder advancedOptions(Consumer<AdvancedOptionsStatus.Builder> advancedOptions) {
            return this.advancedOptions((AdvancedOptionsStatus)((AdvancedOptionsStatus.Builder)AdvancedOptionsStatus.builder().applyMutation(advancedOptions)).build());
        }

        public Builder logPublishingOptions(LogPublishingOptionsStatus var1);

        default public Builder logPublishingOptions(Consumer<LogPublishingOptionsStatus.Builder> logPublishingOptions) {
            return this.logPublishingOptions((LogPublishingOptionsStatus)((LogPublishingOptionsStatus.Builder)LogPublishingOptionsStatus.builder().applyMutation(logPublishingOptions)).build());
        }

        public Builder domainEndpointOptions(DomainEndpointOptionsStatus var1);

        default public Builder domainEndpointOptions(Consumer<DomainEndpointOptionsStatus.Builder> domainEndpointOptions) {
            return this.domainEndpointOptions((DomainEndpointOptionsStatus)((DomainEndpointOptionsStatus.Builder)DomainEndpointOptionsStatus.builder().applyMutation(domainEndpointOptions)).build());
        }

        public Builder advancedSecurityOptions(AdvancedSecurityOptionsStatus var1);

        default public Builder advancedSecurityOptions(Consumer<AdvancedSecurityOptionsStatus.Builder> advancedSecurityOptions) {
            return this.advancedSecurityOptions((AdvancedSecurityOptionsStatus)((AdvancedSecurityOptionsStatus.Builder)AdvancedSecurityOptionsStatus.builder().applyMutation(advancedSecurityOptions)).build());
        }

        public Builder autoTuneOptions(AutoTuneOptionsStatus var1);

        default public Builder autoTuneOptions(Consumer<AutoTuneOptionsStatus.Builder> autoTuneOptions) {
            return this.autoTuneOptions((AutoTuneOptionsStatus)((AutoTuneOptionsStatus.Builder)AutoTuneOptionsStatus.builder().applyMutation(autoTuneOptions)).build());
        }

        public Builder changeProgressDetails(ChangeProgressDetails var1);

        default public Builder changeProgressDetails(Consumer<ChangeProgressDetails.Builder> changeProgressDetails) {
            return this.changeProgressDetails((ChangeProgressDetails)((ChangeProgressDetails.Builder)ChangeProgressDetails.builder().applyMutation(changeProgressDetails)).build());
        }

        public Builder modifyingProperties(Collection<ModifyingProperties> var1);

        public Builder modifyingProperties(ModifyingProperties ... var1);

        public Builder modifyingProperties(Consumer<ModifyingProperties.Builder> ... var1);
    }
}

