/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.CancelledChangeProperty;
import software.amazon.awssdk.services.elasticsearch.model.CancelledChangePropertyListCopier;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.services.elasticsearch.model.GUIDListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelDomainConfigChangeResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, CancelDomainConfigChangeResponse> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CancelDomainConfigChangeResponse.getter(CancelDomainConfigChangeResponse::dryRun)).setter(CancelDomainConfigChangeResponse.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final SdkField<List<String>> CANCELLED_CHANGE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CancelledChangeIds").getter(CancelDomainConfigChangeResponse.getter(CancelDomainConfigChangeResponse::cancelledChangeIds)).setter(CancelDomainConfigChangeResponse.setter(Builder::cancelledChangeIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancelledChangeIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CancelledChangeProperty>> CANCELLED_CHANGE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CancelledChangeProperties").getter(CancelDomainConfigChangeResponse.getter(CancelDomainConfigChangeResponse::cancelledChangeProperties)).setter(CancelDomainConfigChangeResponse.setter(Builder::cancelledChangeProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancelledChangeProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CancelledChangeProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, CANCELLED_CHANGE_IDS_FIELD, CANCELLED_CHANGE_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CancelDomainConfigChangeResponse.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final List<String> cancelledChangeIds;
    private final List<CancelledChangeProperty> cancelledChangeProperties;

    private CancelDomainConfigChangeResponse(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.cancelledChangeIds = builder.cancelledChangeIds;
        this.cancelledChangeProperties = builder.cancelledChangeProperties;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasCancelledChangeIds() {
        return this.cancelledChangeIds != null && !(this.cancelledChangeIds instanceof SdkAutoConstructList);
    }

    public final List<String> cancelledChangeIds() {
        return this.cancelledChangeIds;
    }

    public final boolean hasCancelledChangeProperties() {
        return this.cancelledChangeProperties != null && !(this.cancelledChangeProperties instanceof SdkAutoConstructList);
    }

    public final List<CancelledChangeProperty> cancelledChangeProperties() {
        return this.cancelledChangeProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCancelledChangeIds() ? this.cancelledChangeIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCancelledChangeProperties() ? this.cancelledChangeProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelDomainConfigChangeResponse)) {
            return false;
        }
        CancelDomainConfigChangeResponse other = (CancelDomainConfigChangeResponse)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && this.hasCancelledChangeIds() == other.hasCancelledChangeIds() && Objects.equals(this.cancelledChangeIds(), other.cancelledChangeIds()) && this.hasCancelledChangeProperties() == other.hasCancelledChangeProperties() && Objects.equals(this.cancelledChangeProperties(), other.cancelledChangeProperties());
    }

    public final String toString() {
        return ToString.builder((String)"CancelDomainConfigChangeResponse").add("DryRun", (Object)this.dryRun()).add("CancelledChangeIds", this.hasCancelledChangeIds() ? this.cancelledChangeIds() : null).add("CancelledChangeProperties", this.hasCancelledChangeProperties() ? this.cancelledChangeProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "CancelledChangeIds": {
                return Optional.ofNullable(clazz.cast(this.cancelledChangeIds()));
            }
            case "CancelledChangeProperties": {
                return Optional.ofNullable(clazz.cast(this.cancelledChangeProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("CancelledChangeIds", CANCELLED_CHANGE_IDS_FIELD);
        map.put("CancelledChangeProperties", CANCELLED_CHANGE_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelDomainConfigChangeResponse, T> g) {
        return obj -> g.apply((CancelDomainConfigChangeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private List<String> cancelledChangeIds = DefaultSdkAutoConstructList.getInstance();
        private List<CancelledChangeProperty> cancelledChangeProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelDomainConfigChangeResponse model) {
            super(model);
            this.dryRun(model.dryRun);
            this.cancelledChangeIds(model.cancelledChangeIds);
            this.cancelledChangeProperties(model.cancelledChangeProperties);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Collection<String> getCancelledChangeIds() {
            if (this.cancelledChangeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cancelledChangeIds;
        }

        public final void setCancelledChangeIds(Collection<String> cancelledChangeIds) {
            this.cancelledChangeIds = GUIDListCopier.copy(cancelledChangeIds);
        }

        @Override
        public final Builder cancelledChangeIds(Collection<String> cancelledChangeIds) {
            this.cancelledChangeIds = GUIDListCopier.copy(cancelledChangeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancelledChangeIds(String ... cancelledChangeIds) {
            this.cancelledChangeIds(Arrays.asList(cancelledChangeIds));
            return this;
        }

        public final List<CancelledChangeProperty.Builder> getCancelledChangeProperties() {
            List<CancelledChangeProperty.Builder> result = CancelledChangePropertyListCopier.copyToBuilder(this.cancelledChangeProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCancelledChangeProperties(Collection<CancelledChangeProperty.BuilderImpl> cancelledChangeProperties) {
            this.cancelledChangeProperties = CancelledChangePropertyListCopier.copyFromBuilder(cancelledChangeProperties);
        }

        @Override
        public final Builder cancelledChangeProperties(Collection<CancelledChangeProperty> cancelledChangeProperties) {
            this.cancelledChangeProperties = CancelledChangePropertyListCopier.copy(cancelledChangeProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancelledChangeProperties(CancelledChangeProperty ... cancelledChangeProperties) {
            this.cancelledChangeProperties(Arrays.asList(cancelledChangeProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancelledChangeProperties(Consumer<CancelledChangeProperty.Builder> ... cancelledChangeProperties) {
            this.cancelledChangeProperties(Stream.of(cancelledChangeProperties).map(c -> (CancelledChangeProperty)((CancelledChangeProperty.Builder)CancelledChangeProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CancelDomainConfigChangeResponse build() {
            return new CancelDomainConfigChangeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelDomainConfigChangeResponse> {
        public Builder dryRun(Boolean var1);

        public Builder cancelledChangeIds(Collection<String> var1);

        public Builder cancelledChangeIds(String ... var1);

        public Builder cancelledChangeProperties(Collection<CancelledChangeProperty> var1);

        public Builder cancelledChangeProperties(CancelledChangeProperty ... var1);

        public Builder cancelledChangeProperties(Consumer<CancelledChangeProperty.Builder> ... var1);
    }
}

