/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UpgradeStep {
    PRE_UPGRADE_CHECK("PRE_UPGRADE_CHECK"),
    SNAPSHOT("SNAPSHOT"),
    UPGRADE("UPGRADE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UpgradeStep> VALUE_MAP;
    private final String value;

    private UpgradeStep(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UpgradeStep fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UpgradeStep> knownValues() {
        EnumSet<UpgradeStep> knownValues = EnumSet.allOf(UpgradeStep.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UpgradeStep.class, UpgradeStep::toString);
    }
}

