/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstance;
import software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstanceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedElasticsearchInstancesResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, DescribeReservedElasticsearchInstancesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeReservedElasticsearchInstancesResponse.getter(DescribeReservedElasticsearchInstancesResponse::nextToken)).setter(DescribeReservedElasticsearchInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ReservedElasticsearchInstance>> RESERVED_ELASTICSEARCH_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedElasticsearchInstances").getter(DescribeReservedElasticsearchInstancesResponse.getter(DescribeReservedElasticsearchInstancesResponse::reservedElasticsearchInstances)).setter(DescribeReservedElasticsearchInstancesResponse.setter(Builder::reservedElasticsearchInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedElasticsearchInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedElasticsearchInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESERVED_ELASTICSEARCH_INSTANCES_FIELD));
    private final String nextToken;
    private final List<ReservedElasticsearchInstance> reservedElasticsearchInstances;

    private DescribeReservedElasticsearchInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedElasticsearchInstances = builder.reservedElasticsearchInstances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasReservedElasticsearchInstances() {
        return this.reservedElasticsearchInstances != null && !(this.reservedElasticsearchInstances instanceof SdkAutoConstructList);
    }

    public final List<ReservedElasticsearchInstance> reservedElasticsearchInstances() {
        return this.reservedElasticsearchInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedElasticsearchInstances() ? this.reservedElasticsearchInstances() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedElasticsearchInstancesResponse)) {
            return false;
        }
        DescribeReservedElasticsearchInstancesResponse other = (DescribeReservedElasticsearchInstancesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasReservedElasticsearchInstances() == other.hasReservedElasticsearchInstances() && Objects.equals(this.reservedElasticsearchInstances(), other.reservedElasticsearchInstances());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReservedElasticsearchInstancesResponse").add("NextToken", (Object)this.nextToken()).add("ReservedElasticsearchInstances", this.hasReservedElasticsearchInstances() ? this.reservedElasticsearchInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ReservedElasticsearchInstances": {
                return Optional.ofNullable(clazz.cast(this.reservedElasticsearchInstances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedElasticsearchInstancesResponse, T> g) {
        return obj -> g.apply((DescribeReservedElasticsearchInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ReservedElasticsearchInstance> reservedElasticsearchInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedElasticsearchInstancesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.reservedElasticsearchInstances(model.reservedElasticsearchInstances);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ReservedElasticsearchInstance.Builder> getReservedElasticsearchInstances() {
            List<ReservedElasticsearchInstance.Builder> result = ReservedElasticsearchInstanceListCopier.copyToBuilder(this.reservedElasticsearchInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedElasticsearchInstances(Collection<ReservedElasticsearchInstance.BuilderImpl> reservedElasticsearchInstances) {
            this.reservedElasticsearchInstances = ReservedElasticsearchInstanceListCopier.copyFromBuilder(reservedElasticsearchInstances);
        }

        @Override
        public final Builder reservedElasticsearchInstances(Collection<ReservedElasticsearchInstance> reservedElasticsearchInstances) {
            this.reservedElasticsearchInstances = ReservedElasticsearchInstanceListCopier.copy(reservedElasticsearchInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedElasticsearchInstances(ReservedElasticsearchInstance ... reservedElasticsearchInstances) {
            this.reservedElasticsearchInstances(Arrays.asList(reservedElasticsearchInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedElasticsearchInstances(Consumer<ReservedElasticsearchInstance.Builder> ... reservedElasticsearchInstances) {
            this.reservedElasticsearchInstances(Stream.of(reservedElasticsearchInstances).map(c -> (ReservedElasticsearchInstance)((ReservedElasticsearchInstance.Builder)ReservedElasticsearchInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReservedElasticsearchInstancesResponse build() {
            return new DescribeReservedElasticsearchInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedElasticsearchInstancesResponse> {
        public Builder nextToken(String var1);

        public Builder reservedElasticsearchInstances(Collection<ReservedElasticsearchInstance> var1);

        public Builder reservedElasticsearchInstances(ReservedElasticsearchInstance ... var1);

        public Builder reservedElasticsearchInstances(Consumer<ReservedElasticsearchInstance.Builder> ... var1);
    }
}

