/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * InstanceCountLimits represents the limits on number of instances that be created in Amazon Elasticsearch for given
 * InstanceType.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceCountLimits implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceCountLimits.Builder, InstanceCountLimits> {
    private static final SdkField<Integer> MINIMUM_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumInstanceCount").getter(getter(InstanceCountLimits::minimumInstanceCount))
            .setter(setter(Builder::minimumInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumInstanceCount").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumInstanceCount").getter(getter(InstanceCountLimits::maximumInstanceCount))
            .setter(setter(Builder::maximumInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumInstanceCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_INSTANCE_COUNT_FIELD,
            MAXIMUM_INSTANCE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer minimumInstanceCount;

    private final Integer maximumInstanceCount;

    private InstanceCountLimits(BuilderImpl builder) {
        this.minimumInstanceCount = builder.minimumInstanceCount;
        this.maximumInstanceCount = builder.maximumInstanceCount;
    }

    /**
     * Returns the value of the MinimumInstanceCount property for this object.
     * 
     * @return The value of the MinimumInstanceCount property for this object.
     */
    public final Integer minimumInstanceCount() {
        return minimumInstanceCount;
    }

    /**
     * Returns the value of the MaximumInstanceCount property for this object.
     * 
     * @return The value of the MaximumInstanceCount property for this object.
     */
    public final Integer maximumInstanceCount() {
        return maximumInstanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minimumInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(maximumInstanceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCountLimits)) {
            return false;
        }
        InstanceCountLimits other = (InstanceCountLimits) obj;
        return Objects.equals(minimumInstanceCount(), other.minimumInstanceCount())
                && Objects.equals(maximumInstanceCount(), other.maximumInstanceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceCountLimits").add("MinimumInstanceCount", minimumInstanceCount())
                .add("MaximumInstanceCount", maximumInstanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinimumInstanceCount":
            return Optional.ofNullable(clazz.cast(minimumInstanceCount()));
        case "MaximumInstanceCount":
            return Optional.ofNullable(clazz.cast(maximumInstanceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceCountLimits, T> g) {
        return obj -> g.apply((InstanceCountLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceCountLimits> {
        /**
         * Sets the value of the MinimumInstanceCount property for this object.
         *
         * @param minimumInstanceCount
         *        The new value for the MinimumInstanceCount property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumInstanceCount(Integer minimumInstanceCount);

        /**
         * Sets the value of the MaximumInstanceCount property for this object.
         *
         * @param maximumInstanceCount
         *        The new value for the MaximumInstanceCount property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumInstanceCount(Integer maximumInstanceCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer minimumInstanceCount;

        private Integer maximumInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCountLimits model) {
            minimumInstanceCount(model.minimumInstanceCount);
            maximumInstanceCount(model.maximumInstanceCount);
        }

        public final Integer getMinimumInstanceCount() {
            return minimumInstanceCount;
        }

        @Override
        public final Builder minimumInstanceCount(Integer minimumInstanceCount) {
            this.minimumInstanceCount = minimumInstanceCount;
            return this;
        }

        public final void setMinimumInstanceCount(Integer minimumInstanceCount) {
            this.minimumInstanceCount = minimumInstanceCount;
        }

        public final Integer getMaximumInstanceCount() {
            return maximumInstanceCount;
        }

        @Override
        public final Builder maximumInstanceCount(Integer maximumInstanceCount) {
            this.maximumInstanceCount = maximumInstanceCount;
            return this;
        }

        public final void setMaximumInstanceCount(Integer maximumInstanceCount) {
            this.maximumInstanceCount = maximumInstanceCount;
        }

        @Override
        public InstanceCountLimits build() {
            return new InstanceCountLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
