/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of <code>DescribeDomainAutoTunes</code> request. See the <a
 * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
 * target="_blank">Developer Guide</a> for more information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDomainAutoTunesResponse extends ElasticsearchResponse implements
        ToCopyableBuilder<DescribeDomainAutoTunesResponse.Builder, DescribeDomainAutoTunesResponse> {
    private static final SdkField<List<AutoTune>> AUTO_TUNES_FIELD = SdkField
            .<List<AutoTune>> builder(MarshallingType.LIST)
            .memberName("AutoTunes")
            .getter(getter(DescribeDomainAutoTunesResponse::autoTunes))
            .setter(setter(Builder::autoTunes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTunes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoTune> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoTune::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeDomainAutoTunesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_TUNES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AutoTune> autoTunes;

    private final String nextToken;

    private DescribeDomainAutoTunesResponse(BuilderImpl builder) {
        super(builder);
        this.autoTunes = builder.autoTunes;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AutoTunes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAutoTunes() {
        return autoTunes != null && !(autoTunes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the list of setting adjustments that Auto-Tune has made to the domain. See the <a
     * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
     * target="_blank">Developer Guide</a> for more information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAutoTunes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the list of setting adjustments that Auto-Tune has made to the domain. See the <a
     *         href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
     *         target="_blank">Developer Guide</a> for more information.
     */
    public final List<AutoTune> autoTunes() {
        return autoTunes;
    }

    /**
     * <p>
     * Specifies an identifier to allow retrieval of paginated results.
     * </p>
     * 
     * @return Specifies an identifier to allow retrieval of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoTunes() ? autoTunes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainAutoTunesResponse)) {
            return false;
        }
        DescribeDomainAutoTunesResponse other = (DescribeDomainAutoTunesResponse) obj;
        return hasAutoTunes() == other.hasAutoTunes() && Objects.equals(autoTunes(), other.autoTunes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDomainAutoTunesResponse").add("AutoTunes", hasAutoTunes() ? autoTunes() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoTunes":
            return Optional.ofNullable(clazz.cast(autoTunes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainAutoTunesResponse, T> g) {
        return obj -> g.apply((DescribeDomainAutoTunesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDomainAutoTunesResponse> {
        /**
         * <p>
         * Specifies the list of setting adjustments that Auto-Tune has made to the domain. See the <a
         * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         * target="_blank">Developer Guide</a> for more information.
         * </p>
         * 
         * @param autoTunes
         *        Specifies the list of setting adjustments that Auto-Tune has made to the domain. See the <a
         *        href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         *        target="_blank">Developer Guide</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoTunes(Collection<AutoTune> autoTunes);

        /**
         * <p>
         * Specifies the list of setting adjustments that Auto-Tune has made to the domain. See the <a
         * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         * target="_blank">Developer Guide</a> for more information.
         * </p>
         * 
         * @param autoTunes
         *        Specifies the list of setting adjustments that Auto-Tune has made to the domain. See the <a
         *        href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         *        target="_blank">Developer Guide</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoTunes(AutoTune... autoTunes);

        /**
         * <p>
         * Specifies the list of setting adjustments that Auto-Tune has made to the domain. See the <a
         * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html"
         * target="_blank">Developer Guide</a> for more information.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AutoTune>.Builder} avoiding the need to
         * create one manually via {@link List<AutoTune>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AutoTune>.Builder#build()} is called immediately and its
         * result is passed to {@link #autoTunes(List<AutoTune>)}.
         * 
         * @param autoTunes
         *        a consumer that will call methods on {@link List<AutoTune>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoTunes(List<AutoTune>)
         */
        Builder autoTunes(Consumer<AutoTune.Builder>... autoTunes);

        /**
         * <p>
         * Specifies an identifier to allow retrieval of paginated results.
         * </p>
         * 
         * @param nextToken
         *        Specifies an identifier to allow retrieval of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private List<AutoTune> autoTunes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainAutoTunesResponse model) {
            super(model);
            autoTunes(model.autoTunes);
            nextToken(model.nextToken);
        }

        public final List<AutoTune.Builder> getAutoTunes() {
            List<AutoTune.Builder> result = AutoTuneListCopier.copyToBuilder(this.autoTunes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder autoTunes(Collection<AutoTune> autoTunes) {
            this.autoTunes = AutoTuneListCopier.copy(autoTunes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoTunes(AutoTune... autoTunes) {
            autoTunes(Arrays.asList(autoTunes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoTunes(Consumer<AutoTune.Builder>... autoTunes) {
            autoTunes(Stream.of(autoTunes).map(c -> AutoTune.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAutoTunes(Collection<AutoTune.BuilderImpl> autoTunes) {
            this.autoTunes = AutoTuneListCopier.copyFromBuilder(autoTunes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDomainAutoTunesResponse build() {
            return new DescribeDomainAutoTunesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
