/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.AccessDeniedException;
import software.amazon.awssdk.services.elasticsearch.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.AssociatePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.AssociatePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.BaseException;
import software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.elasticsearch.model.ConflictException;
import software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.CreatePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreatePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchServiceRoleRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchServiceRoleResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeletePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeletePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse;
import software.amazon.awssdk.services.elasticsearch.model.DisabledOperationException;
import software.amazon.awssdk.services.elasticsearch.model.DissociatePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.DissociatePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchException;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusResponse;
import software.amazon.awssdk.services.elasticsearch.model.InternalException;
import software.amazon.awssdk.services.elasticsearch.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.elasticsearch.model.InvalidTypeException;
import software.amazon.awssdk.services.elasticsearch.model.LimitExceededException;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest;
import software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse;
import software.amazon.awssdk.services.elasticsearch.model.RejectInboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.elasticsearch.model.ResourceNotFoundException;
import software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpdatePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpdatePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.ValidationException;
import software.amazon.awssdk.services.elasticsearch.paginators.DescribeDomainAutoTunesPublisher;
import software.amazon.awssdk.services.elasticsearch.paginators.DescribeInboundCrossClusterSearchConnectionsPublisher;
import software.amazon.awssdk.services.elasticsearch.paginators.DescribeOutboundCrossClusterSearchConnectionsPublisher;
import software.amazon.awssdk.services.elasticsearch.paginators.DescribePackagesPublisher;
import software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsPublisher;
import software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesPublisher;
import software.amazon.awssdk.services.elasticsearch.paginators.GetPackageVersionHistoryPublisher;
import software.amazon.awssdk.services.elasticsearch.paginators.GetUpgradeHistoryPublisher;
import software.amazon.awssdk.services.elasticsearch.paginators.ListDomainsForPackagePublisher;
import software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchInstanceTypesPublisher;
import software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsPublisher;
import software.amazon.awssdk.services.elasticsearch.paginators.ListPackagesForDomainPublisher;
import software.amazon.awssdk.services.elasticsearch.transform.AcceptInboundCrossClusterSearchConnectionRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.AssociatePackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CancelElasticsearchServiceSoftwareUpdateRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CreateElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CreateOutboundCrossClusterSearchConnectionRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CreatePackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteElasticsearchServiceRoleRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteInboundCrossClusterSearchConnectionRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteOutboundCrossClusterSearchConnectionRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeletePackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeDomainAutoTunesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainConfigRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchInstanceTypeLimitsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeInboundCrossClusterSearchConnectionsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeOutboundCrossClusterSearchConnectionsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribePackagesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeReservedElasticsearchInstanceOfferingsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeReservedElasticsearchInstancesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DissociatePackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.GetCompatibleElasticsearchVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.GetPackageVersionHistoryRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.GetUpgradeHistoryRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.GetUpgradeStatusRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListDomainsForPackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListElasticsearchInstanceTypesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListElasticsearchVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListPackagesForDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.PurchaseReservedElasticsearchInstanceOfferingRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.RejectInboundCrossClusterSearchConnectionRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.StartElasticsearchServiceSoftwareUpdateRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.UpdateElasticsearchDomainConfigRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.UpdatePackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.UpgradeElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ElasticsearchAsyncClient}.
 *
 * @see ElasticsearchAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultElasticsearchAsyncClient implements ElasticsearchAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultElasticsearchAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElasticsearchAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Allows the destination domain owner to accept an inbound cross-cluster search connection request.
     * </p>
     *
     * @param acceptInboundCrossClusterSearchConnectionRequest
     *        Container for the parameters to the <code><a>AcceptInboundCrossClusterSearchConnection</a></code>
     *        operation.
     * @return A Java Future containing the result of the AcceptInboundCrossClusterSearchConnection operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.AcceptInboundCrossClusterSearchConnection
     */
    @Override
    public CompletableFuture<AcceptInboundCrossClusterSearchConnectionResponse> acceptInboundCrossClusterSearchConnection(
            AcceptInboundCrossClusterSearchConnectionRequest acceptInboundCrossClusterSearchConnectionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptInboundCrossClusterSearchConnectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptInboundCrossClusterSearchConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptInboundCrossClusterSearchConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AcceptInboundCrossClusterSearchConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AcceptInboundCrossClusterSearchConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptInboundCrossClusterSearchConnectionRequest, AcceptInboundCrossClusterSearchConnectionResponse>()
                            .withOperationName("AcceptInboundCrossClusterSearchConnection")
                            .withMarshaller(new AcceptInboundCrossClusterSearchConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptInboundCrossClusterSearchConnectionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = acceptInboundCrossClusterSearchConnectionRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<AcceptInboundCrossClusterSearchConnectionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An
     * Elasticsearch domain may have up to 10 tags. See <a href=
     * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging"
     * target="_blank"> Tagging Amazon Elasticsearch Service Domains for more information.</a>
     * </p>
     *
     * @param addTagsRequest
     *        Container for the parameters to the <code><a>AddTags</a></code> operation. Specify the tags that you want
     *        to attach to the Elasticsearch domain.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.AddTags
     */
    @Override
    public CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AddTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsRequest, AddTagsResponse>().withOperationName("AddTags")
                            .withMarshaller(new AddTagsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(addTagsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = addTagsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<AddTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a package with an Amazon ES domain.
     * </p>
     *
     * @param associatePackageRequest
     *        Container for request parameters to <code> <a>AssociatePackage</a> </code> operation.
     * @return A Java Future containing the result of the AssociatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use. Returns HTTP status code 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.AssociatePackage
     */
    @Override
    public CompletableFuture<AssociatePackageResponse> associatePackage(AssociatePackageRequest associatePackageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associatePackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociatePackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociatePackageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociatePackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociatePackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociatePackageRequest, AssociatePackageResponse>()
                            .withOperationName("AssociatePackage")
                            .withMarshaller(new AssociatePackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associatePackageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associatePackageRequest.overrideConfiguration().orElse(null);
            CompletableFuture<AssociatePackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before
     * the <code>AutomatedUpdateDate</code> and when the <code>UpdateStatus</code> is in the <code>PENDING_UPDATE</code>
     * state.
     * </p>
     *
     * @param cancelElasticsearchServiceSoftwareUpdateRequest
     *        Container for the parameters to the <code><a>CancelElasticsearchServiceSoftwareUpdate</a></code>
     *        operation. Specifies the name of the Elasticsearch domain that you wish to cancel a service software
     *        update on.
     * @return A Java Future containing the result of the CancelElasticsearchServiceSoftwareUpdate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.CancelElasticsearchServiceSoftwareUpdate
     */
    @Override
    public CompletableFuture<CancelElasticsearchServiceSoftwareUpdateResponse> cancelElasticsearchServiceSoftwareUpdate(
            CancelElasticsearchServiceSoftwareUpdateRequest cancelElasticsearchServiceSoftwareUpdateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelElasticsearchServiceSoftwareUpdateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelElasticsearchServiceSoftwareUpdate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelElasticsearchServiceSoftwareUpdateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CancelElasticsearchServiceSoftwareUpdateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelElasticsearchServiceSoftwareUpdateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelElasticsearchServiceSoftwareUpdateRequest, CancelElasticsearchServiceSoftwareUpdateResponse>()
                            .withOperationName("CancelElasticsearchServiceSoftwareUpdate")
                            .withMarshaller(new CancelElasticsearchServiceSoftwareUpdateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelElasticsearchServiceSoftwareUpdateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = cancelElasticsearchServiceSoftwareUpdateRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<CancelElasticsearchServiceSoftwareUpdateResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Elasticsearch domain. For more information, see <a href=
     * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains"
     * target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.
     * </p>
     *
     * @param createElasticsearchDomainRequest
     * @return A Java Future containing the result of the CreateElasticsearchDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.CreateElasticsearchDomain
     */
    @Override
    public CompletableFuture<CreateElasticsearchDomainResponse> createElasticsearchDomain(
            CreateElasticsearchDomainRequest createElasticsearchDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createElasticsearchDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateElasticsearchDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateElasticsearchDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateElasticsearchDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateElasticsearchDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateElasticsearchDomainRequest, CreateElasticsearchDomainResponse>()
                            .withOperationName("CreateElasticsearchDomain")
                            .withMarshaller(new CreateElasticsearchDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createElasticsearchDomainRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createElasticsearchDomainRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateElasticsearchDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new cross-cluster search connection from a source domain to a destination domain.
     * </p>
     *
     * @param createOutboundCrossClusterSearchConnectionRequest
     *        Container for the parameters to the <code><a>CreateOutboundCrossClusterSearchConnection</a></code>
     *        operation.
     * @return A Java Future containing the result of the CreateOutboundCrossClusterSearchConnection operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.CreateOutboundCrossClusterSearchConnection
     */
    @Override
    public CompletableFuture<CreateOutboundCrossClusterSearchConnectionResponse> createOutboundCrossClusterSearchConnection(
            CreateOutboundCrossClusterSearchConnectionRequest createOutboundCrossClusterSearchConnectionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createOutboundCrossClusterSearchConnectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOutboundCrossClusterSearchConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateOutboundCrossClusterSearchConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateOutboundCrossClusterSearchConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateOutboundCrossClusterSearchConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOutboundCrossClusterSearchConnectionRequest, CreateOutboundCrossClusterSearchConnectionResponse>()
                            .withOperationName("CreateOutboundCrossClusterSearchConnection")
                            .withMarshaller(new CreateOutboundCrossClusterSearchConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(createOutboundCrossClusterSearchConnectionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createOutboundCrossClusterSearchConnectionRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<CreateOutboundCrossClusterSearchConnectionResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a package for use with Amazon ES domains.
     * </p>
     *
     * @param createPackageRequest
     *        Container for request parameters to <code> <a>CreatePackage</a> </code> operation.
     * @return A Java Future containing the result of the CreatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.CreatePackage
     */
    @Override
    public CompletableFuture<CreatePackageResponse> createPackage(CreatePackageRequest createPackageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreatePackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePackageRequest, CreatePackageResponse>()
                            .withOperationName("CreatePackage")
                            .withMarshaller(new CreatePackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createPackageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createPackageRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreatePackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot
     * be recovered.
     * </p>
     *
     * @param deleteElasticsearchDomainRequest
     *        Container for the parameters to the <code><a>DeleteElasticsearchDomain</a></code> operation. Specifies the
     *        name of the Elasticsearch domain that you want to delete.
     * @return A Java Future containing the result of the DeleteElasticsearchDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DeleteElasticsearchDomain
     */
    @Override
    public CompletableFuture<DeleteElasticsearchDomainResponse> deleteElasticsearchDomain(
            DeleteElasticsearchDomainRequest deleteElasticsearchDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteElasticsearchDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteElasticsearchDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteElasticsearchDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteElasticsearchDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteElasticsearchDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteElasticsearchDomainRequest, DeleteElasticsearchDomainResponse>()
                            .withOperationName("DeleteElasticsearchDomain")
                            .withMarshaller(new DeleteElasticsearchDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteElasticsearchDomainRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteElasticsearchDomainRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteElasticsearchDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion
     * will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before
     * deleting the role. See <a
     * href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr"
     * target="_blank">Deleting Elasticsearch Service Role</a> in <i>VPC Endpoints for Amazon Elasticsearch Service
     * Domains</i>.
     * </p>
     *
     * @param deleteElasticsearchServiceRoleRequest
     * @return A Java Future containing the result of the DeleteElasticsearchServiceRole operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DeleteElasticsearchServiceRole
     */
    @Override
    public CompletableFuture<DeleteElasticsearchServiceRoleResponse> deleteElasticsearchServiceRole(
            DeleteElasticsearchServiceRoleRequest deleteElasticsearchServiceRoleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteElasticsearchServiceRoleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteElasticsearchServiceRole");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteElasticsearchServiceRoleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteElasticsearchServiceRoleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteElasticsearchServiceRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteElasticsearchServiceRoleRequest, DeleteElasticsearchServiceRoleResponse>()
                            .withOperationName("DeleteElasticsearchServiceRole")
                            .withMarshaller(new DeleteElasticsearchServiceRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteElasticsearchServiceRoleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteElasticsearchServiceRoleRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteElasticsearchServiceRoleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the destination domain owner to delete an existing inbound cross-cluster search connection.
     * </p>
     *
     * @param deleteInboundCrossClusterSearchConnectionRequest
     *        Container for the parameters to the <code><a>DeleteInboundCrossClusterSearchConnection</a></code>
     *        operation.
     * @return A Java Future containing the result of the DeleteInboundCrossClusterSearchConnection operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DeleteInboundCrossClusterSearchConnection
     */
    @Override
    public CompletableFuture<DeleteInboundCrossClusterSearchConnectionResponse> deleteInboundCrossClusterSearchConnection(
            DeleteInboundCrossClusterSearchConnectionRequest deleteInboundCrossClusterSearchConnectionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteInboundCrossClusterSearchConnectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInboundCrossClusterSearchConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInboundCrossClusterSearchConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteInboundCrossClusterSearchConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInboundCrossClusterSearchConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInboundCrossClusterSearchConnectionRequest, DeleteInboundCrossClusterSearchConnectionResponse>()
                            .withOperationName("DeleteInboundCrossClusterSearchConnection")
                            .withMarshaller(new DeleteInboundCrossClusterSearchConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInboundCrossClusterSearchConnectionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteInboundCrossClusterSearchConnectionRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DeleteInboundCrossClusterSearchConnectionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the source domain owner to delete an existing outbound cross-cluster search connection.
     * </p>
     *
     * @param deleteOutboundCrossClusterSearchConnectionRequest
     *        Container for the parameters to the <code><a>DeleteOutboundCrossClusterSearchConnection</a></code>
     *        operation.
     * @return A Java Future containing the result of the DeleteOutboundCrossClusterSearchConnection operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DeleteOutboundCrossClusterSearchConnection
     */
    @Override
    public CompletableFuture<DeleteOutboundCrossClusterSearchConnectionResponse> deleteOutboundCrossClusterSearchConnection(
            DeleteOutboundCrossClusterSearchConnectionRequest deleteOutboundCrossClusterSearchConnectionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteOutboundCrossClusterSearchConnectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOutboundCrossClusterSearchConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOutboundCrossClusterSearchConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteOutboundCrossClusterSearchConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteOutboundCrossClusterSearchConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOutboundCrossClusterSearchConnectionRequest, DeleteOutboundCrossClusterSearchConnectionResponse>()
                            .withOperationName("DeleteOutboundCrossClusterSearchConnection")
                            .withMarshaller(new DeleteOutboundCrossClusterSearchConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteOutboundCrossClusterSearchConnectionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteOutboundCrossClusterSearchConnectionRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DeleteOutboundCrossClusterSearchConnectionResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete the package.
     * </p>
     *
     * @param deletePackageRequest
     *        Container for request parameters to <code> <a>DeletePackage</a> </code> operation.
     * @return A Java Future containing the result of the DeletePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use. Returns HTTP status code 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DeletePackage
     */
    @Override
    public CompletableFuture<DeletePackageResponse> deletePackage(DeletePackageRequest deletePackageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeletePackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePackageRequest, DeletePackageResponse>()
                            .withOperationName("DeletePackage")
                            .withMarshaller(new DeletePackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deletePackageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deletePackageRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeletePackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type,
     * description, severity, and scheduled date.
     * </p>
     *
     * @param describeDomainAutoTunesRequest
     *        Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.
     * @return A Java Future containing the result of the DescribeDomainAutoTunes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeDomainAutoTunes
     */
    @Override
    public CompletableFuture<DescribeDomainAutoTunesResponse> describeDomainAutoTunes(
            DescribeDomainAutoTunesRequest describeDomainAutoTunesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainAutoTunesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomainAutoTunes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDomainAutoTunesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDomainAutoTunesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDomainAutoTunesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDomainAutoTunesRequest, DescribeDomainAutoTunesResponse>()
                            .withOperationName("DescribeDomainAutoTunes")
                            .withMarshaller(new DescribeDomainAutoTunesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDomainAutoTunesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDomainAutoTunesRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeDomainAutoTunesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type,
     * description, severity, and scheduled date.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDomainAutoTunes(software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeDomainAutoTunesPublisher publisher = client.describeDomainAutoTunesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeDomainAutoTunesPublisher publisher = client.describeDomainAutoTunesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDomainAutoTunes(software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDomainAutoTunesRequest
     *        Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeDomainAutoTunes
     */
    public DescribeDomainAutoTunesPublisher describeDomainAutoTunesPaginator(
            DescribeDomainAutoTunesRequest describeDomainAutoTunesRequest) {
        return new DescribeDomainAutoTunesPublisher(this, applyPaginatorUserAgent(describeDomainAutoTunesRequest));
    }

    /**
     * <p>
     * Returns domain configuration information about the specified Elasticsearch domain, including the domain ID,
     * domain endpoint, and domain ARN.
     * </p>
     *
     * @param describeElasticsearchDomainRequest
     *        Container for the parameters to the <code><a>DescribeElasticsearchDomain</a></code> operation.
     * @return A Java Future containing the result of the DescribeElasticsearchDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeElasticsearchDomain
     */
    @Override
    public CompletableFuture<DescribeElasticsearchDomainResponse> describeElasticsearchDomain(
            DescribeElasticsearchDomainRequest describeElasticsearchDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeElasticsearchDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeElasticsearchDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeElasticsearchDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeElasticsearchDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeElasticsearchDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeElasticsearchDomainRequest, DescribeElasticsearchDomainResponse>()
                            .withOperationName("DescribeElasticsearchDomain")
                            .withMarshaller(new DescribeElasticsearchDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeElasticsearchDomainRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeElasticsearchDomainRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeElasticsearchDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation
     * date, update version, and update date for cluster options.
     * </p>
     *
     * @param describeElasticsearchDomainConfigRequest
     *        Container for the parameters to the <code>DescribeElasticsearchDomainConfig</code> operation. Specifies
     *        the domain name for which you want configuration information.
     * @return A Java Future containing the result of the DescribeElasticsearchDomainConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeElasticsearchDomainConfig
     */
    @Override
    public CompletableFuture<DescribeElasticsearchDomainConfigResponse> describeElasticsearchDomainConfig(
            DescribeElasticsearchDomainConfigRequest describeElasticsearchDomainConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeElasticsearchDomainConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeElasticsearchDomainConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeElasticsearchDomainConfigResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeElasticsearchDomainConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeElasticsearchDomainConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeElasticsearchDomainConfigRequest, DescribeElasticsearchDomainConfigResponse>()
                            .withOperationName("DescribeElasticsearchDomainConfig")
                            .withMarshaller(new DescribeElasticsearchDomainConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeElasticsearchDomainConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeElasticsearchDomainConfigRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DescribeElasticsearchDomainConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns domain configuration information about the specified Elasticsearch domains, including the domain ID,
     * domain endpoint, and domain ARN.
     * </p>
     *
     * @param describeElasticsearchDomainsRequest
     *        Container for the parameters to the <code><a>DescribeElasticsearchDomains</a></code> operation. By
     *        default, the API returns the status of all Elasticsearch domains.
     * @return A Java Future containing the result of the DescribeElasticsearchDomains operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeElasticsearchDomains
     */
    @Override
    public CompletableFuture<DescribeElasticsearchDomainsResponse> describeElasticsearchDomains(
            DescribeElasticsearchDomainsRequest describeElasticsearchDomainsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeElasticsearchDomainsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeElasticsearchDomains");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeElasticsearchDomainsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeElasticsearchDomainsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeElasticsearchDomainsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeElasticsearchDomainsRequest, DescribeElasticsearchDomainsResponse>()
                            .withOperationName("DescribeElasticsearchDomains")
                            .withMarshaller(new DescribeElasticsearchDomainsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeElasticsearchDomainsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeElasticsearchDomainsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeElasticsearchDomainsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion. When modifying existing Domain,
     * specify the <code> <a>DomainName</a> </code> to know what Limits are supported for modifying.
     * </p>
     *
     * @param describeElasticsearchInstanceTypeLimitsRequest
     *        Container for the parameters to <code> <a>DescribeElasticsearchInstanceTypeLimits</a> </code> operation.
     * @return A Java Future containing the result of the DescribeElasticsearchInstanceTypeLimits operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeElasticsearchInstanceTypeLimits
     */
    @Override
    public CompletableFuture<DescribeElasticsearchInstanceTypeLimitsResponse> describeElasticsearchInstanceTypeLimits(
            DescribeElasticsearchInstanceTypeLimitsRequest describeElasticsearchInstanceTypeLimitsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeElasticsearchInstanceTypeLimitsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeElasticsearchInstanceTypeLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeElasticsearchInstanceTypeLimitsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeElasticsearchInstanceTypeLimitsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeElasticsearchInstanceTypeLimitsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeElasticsearchInstanceTypeLimitsRequest, DescribeElasticsearchInstanceTypeLimitsResponse>()
                            .withOperationName("DescribeElasticsearchInstanceTypeLimits")
                            .withMarshaller(new DescribeElasticsearchInstanceTypeLimitsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeElasticsearchInstanceTypeLimitsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeElasticsearchInstanceTypeLimitsRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DescribeElasticsearchInstanceTypeLimitsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the inbound cross-cluster search connections for a destination domain.
     * </p>
     *
     * @param describeInboundCrossClusterSearchConnectionsRequest
     *        Container for the parameters to the <code><a>DescribeInboundCrossClusterSearchConnections</a></code>
     *        operation.
     * @return A Java Future containing the result of the DescribeInboundCrossClusterSearchConnections operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationTokenException The request processing has failed because of invalid pagination token
     *         provided by customer. Returns an HTTP status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeInboundCrossClusterSearchConnections
     */
    @Override
    public CompletableFuture<DescribeInboundCrossClusterSearchConnectionsResponse> describeInboundCrossClusterSearchConnections(
            DescribeInboundCrossClusterSearchConnectionsRequest describeInboundCrossClusterSearchConnectionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeInboundCrossClusterSearchConnectionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInboundCrossClusterSearchConnections");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInboundCrossClusterSearchConnectionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeInboundCrossClusterSearchConnectionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInboundCrossClusterSearchConnectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInboundCrossClusterSearchConnectionsRequest, DescribeInboundCrossClusterSearchConnectionsResponse>()
                            .withOperationName("DescribeInboundCrossClusterSearchConnections")
                            .withMarshaller(new DescribeInboundCrossClusterSearchConnectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeInboundCrossClusterSearchConnectionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeInboundCrossClusterSearchConnectionsRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DescribeInboundCrossClusterSearchConnectionsResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the inbound cross-cluster search connections for a destination domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInboundCrossClusterSearchConnections(software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeInboundCrossClusterSearchConnectionsPublisher publisher = client.describeInboundCrossClusterSearchConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeInboundCrossClusterSearchConnectionsPublisher publisher = client.describeInboundCrossClusterSearchConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInboundCrossClusterSearchConnections(software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInboundCrossClusterSearchConnectionsRequest
     *        Container for the parameters to the <code><a>DescribeInboundCrossClusterSearchConnections</a></code>
     *        operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationTokenException The request processing has failed because of invalid pagination token
     *         provided by customer. Returns an HTTP status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeInboundCrossClusterSearchConnections
     */
    public DescribeInboundCrossClusterSearchConnectionsPublisher describeInboundCrossClusterSearchConnectionsPaginator(
            DescribeInboundCrossClusterSearchConnectionsRequest describeInboundCrossClusterSearchConnectionsRequest) {
        return new DescribeInboundCrossClusterSearchConnectionsPublisher(this,
                applyPaginatorUserAgent(describeInboundCrossClusterSearchConnectionsRequest));
    }

    /**
     * <p>
     * Lists all the outbound cross-cluster search connections for a source domain.
     * </p>
     *
     * @param describeOutboundCrossClusterSearchConnectionsRequest
     *        Container for the parameters to the <code><a>DescribeOutboundCrossClusterSearchConnections</a></code>
     *        operation.
     * @return A Java Future containing the result of the DescribeOutboundCrossClusterSearchConnections operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationTokenException The request processing has failed because of invalid pagination token
     *         provided by customer. Returns an HTTP status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeOutboundCrossClusterSearchConnections
     */
    @Override
    public CompletableFuture<DescribeOutboundCrossClusterSearchConnectionsResponse> describeOutboundCrossClusterSearchConnections(
            DescribeOutboundCrossClusterSearchConnectionsRequest describeOutboundCrossClusterSearchConnectionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOutboundCrossClusterSearchConnectionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOutboundCrossClusterSearchConnections");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOutboundCrossClusterSearchConnectionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeOutboundCrossClusterSearchConnectionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOutboundCrossClusterSearchConnectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOutboundCrossClusterSearchConnectionsRequest, DescribeOutboundCrossClusterSearchConnectionsResponse>()
                            .withOperationName("DescribeOutboundCrossClusterSearchConnections")
                            .withMarshaller(new DescribeOutboundCrossClusterSearchConnectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeOutboundCrossClusterSearchConnectionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeOutboundCrossClusterSearchConnectionsRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DescribeOutboundCrossClusterSearchConnectionsResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the outbound cross-cluster search connections for a source domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOutboundCrossClusterSearchConnections(software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeOutboundCrossClusterSearchConnectionsPublisher publisher = client.describeOutboundCrossClusterSearchConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeOutboundCrossClusterSearchConnectionsPublisher publisher = client.describeOutboundCrossClusterSearchConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOutboundCrossClusterSearchConnections(software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOutboundCrossClusterSearchConnectionsRequest
     *        Container for the parameters to the <code><a>DescribeOutboundCrossClusterSearchConnections</a></code>
     *        operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationTokenException The request processing has failed because of invalid pagination token
     *         provided by customer. Returns an HTTP status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeOutboundCrossClusterSearchConnections
     */
    public DescribeOutboundCrossClusterSearchConnectionsPublisher describeOutboundCrossClusterSearchConnectionsPaginator(
            DescribeOutboundCrossClusterSearchConnectionsRequest describeOutboundCrossClusterSearchConnectionsRequest) {
        return new DescribeOutboundCrossClusterSearchConnectionsPublisher(this,
                applyPaginatorUserAgent(describeOutboundCrossClusterSearchConnectionsRequest));
    }

    /**
     * <p>
     * Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results,
     * and pagination.
     * </p>
     *
     * @param describePackagesRequest
     *        Container for request parameters to <code> <a>DescribePackage</a> </code> operation.
     * @return A Java Future containing the result of the DescribePackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribePackages
     */
    @Override
    public CompletableFuture<DescribePackagesResponse> describePackages(DescribePackagesRequest describePackagesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePackagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePackages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePackagesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePackagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePackagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePackagesRequest, DescribePackagesResponse>()
                            .withOperationName("DescribePackages")
                            .withMarshaller(new DescribePackagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describePackagesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describePackagesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DescribePackagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results,
     * and pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePackages(software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribePackagesPublisher publisher = client.describePackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribePackagesPublisher publisher = client.describePackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePackages(software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePackagesRequest
     *        Container for request parameters to <code> <a>DescribePackage</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribePackages
     */
    public DescribePackagesPublisher describePackagesPaginator(DescribePackagesRequest describePackagesRequest) {
        return new DescribePackagesPublisher(this, applyPaginatorUserAgent(describePackagesRequest));
    }

    /**
     * <p>
     * Lists available reserved Elasticsearch instance offerings.
     * </p>
     *
     * @param describeReservedElasticsearchInstanceOfferingsRequest
     *        Container for parameters to <code>DescribeReservedElasticsearchInstanceOfferings</code>
     * @return A Java Future containing the result of the DescribeReservedElasticsearchInstanceOfferings operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstanceOfferings
     */
    @Override
    public CompletableFuture<DescribeReservedElasticsearchInstanceOfferingsResponse> describeReservedElasticsearchInstanceOfferings(
            DescribeReservedElasticsearchInstanceOfferingsRequest describeReservedElasticsearchInstanceOfferingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReservedElasticsearchInstanceOfferingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedElasticsearchInstanceOfferings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReservedElasticsearchInstanceOfferingsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeReservedElasticsearchInstanceOfferingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeReservedElasticsearchInstanceOfferingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedElasticsearchInstanceOfferingsRequest, DescribeReservedElasticsearchInstanceOfferingsResponse>()
                            .withOperationName("DescribeReservedElasticsearchInstanceOfferings")
                            .withMarshaller(new DescribeReservedElasticsearchInstanceOfferingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReservedElasticsearchInstanceOfferingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeReservedElasticsearchInstanceOfferingsRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DescribeReservedElasticsearchInstanceOfferingsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists available reserved Elasticsearch instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedElasticsearchInstanceOfferings(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsPublisher publisher = client.describeReservedElasticsearchInstanceOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsPublisher publisher = client.describeReservedElasticsearchInstanceOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedElasticsearchInstanceOfferings(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedElasticsearchInstanceOfferingsRequest
     *        Container for parameters to <code>DescribeReservedElasticsearchInstanceOfferings</code>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstanceOfferings
     */
    public DescribeReservedElasticsearchInstanceOfferingsPublisher describeReservedElasticsearchInstanceOfferingsPaginator(
            DescribeReservedElasticsearchInstanceOfferingsRequest describeReservedElasticsearchInstanceOfferingsRequest) {
        return new DescribeReservedElasticsearchInstanceOfferingsPublisher(this,
                applyPaginatorUserAgent(describeReservedElasticsearchInstanceOfferingsRequest));
    }

    /**
     * <p>
     * Returns information about reserved Elasticsearch instances for this account.
     * </p>
     *
     * @param describeReservedElasticsearchInstancesRequest
     *        Container for parameters to <code>DescribeReservedElasticsearchInstances</code>
     * @return A Java Future containing the result of the DescribeReservedElasticsearchInstances operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstances
     */
    @Override
    public CompletableFuture<DescribeReservedElasticsearchInstancesResponse> describeReservedElasticsearchInstances(
            DescribeReservedElasticsearchInstancesRequest describeReservedElasticsearchInstancesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReservedElasticsearchInstancesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedElasticsearchInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReservedElasticsearchInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeReservedElasticsearchInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeReservedElasticsearchInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedElasticsearchInstancesRequest, DescribeReservedElasticsearchInstancesResponse>()
                            .withOperationName("DescribeReservedElasticsearchInstances")
                            .withMarshaller(new DescribeReservedElasticsearchInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeReservedElasticsearchInstancesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeReservedElasticsearchInstancesRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DescribeReservedElasticsearchInstancesResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about reserved Elasticsearch instances for this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedElasticsearchInstances(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesPublisher publisher = client.describeReservedElasticsearchInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesPublisher publisher = client.describeReservedElasticsearchInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedElasticsearchInstances(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedElasticsearchInstancesRequest
     *        Container for parameters to <code>DescribeReservedElasticsearchInstances</code>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstances
     */
    public DescribeReservedElasticsearchInstancesPublisher describeReservedElasticsearchInstancesPaginator(
            DescribeReservedElasticsearchInstancesRequest describeReservedElasticsearchInstancesRequest) {
        return new DescribeReservedElasticsearchInstancesPublisher(this,
                applyPaginatorUserAgent(describeReservedElasticsearchInstancesRequest));
    }

    /**
     * <p>
     * Dissociates a package from the Amazon ES domain.
     * </p>
     *
     * @param dissociatePackageRequest
     *        Container for request parameters to <code> <a>DissociatePackage</a> </code> operation.
     * @return A Java Future containing the result of the DissociatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use. Returns HTTP status code 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DissociatePackage
     */
    @Override
    public CompletableFuture<DissociatePackageResponse> dissociatePackage(DissociatePackageRequest dissociatePackageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, dissociatePackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DissociatePackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DissociatePackageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DissociatePackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DissociatePackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DissociatePackageRequest, DissociatePackageResponse>()
                            .withOperationName("DissociatePackage")
                            .withMarshaller(new DissociatePackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(dissociatePackageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = dissociatePackageRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DissociatePackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a
     * <code> <a>DomainName</a> </code> to get all upgrade compatible Elasticsearch versions for that specific domain.
     * </p>
     *
     * @param getCompatibleElasticsearchVersionsRequest
     *        Container for request parameters to <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation.
     * @return A Java Future containing the result of the GetCompatibleElasticsearchVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetCompatibleElasticsearchVersions
     */
    @Override
    public CompletableFuture<GetCompatibleElasticsearchVersionsResponse> getCompatibleElasticsearchVersions(
            GetCompatibleElasticsearchVersionsRequest getCompatibleElasticsearchVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCompatibleElasticsearchVersionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCompatibleElasticsearchVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCompatibleElasticsearchVersionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetCompatibleElasticsearchVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCompatibleElasticsearchVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCompatibleElasticsearchVersionsRequest, GetCompatibleElasticsearchVersionsResponse>()
                            .withOperationName("GetCompatibleElasticsearchVersions")
                            .withMarshaller(new GetCompatibleElasticsearchVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getCompatibleElasticsearchVersionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCompatibleElasticsearchVersionsRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<GetCompatibleElasticsearchVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of versions of the package, along with their creation time and commit message.
     * </p>
     *
     * @param getPackageVersionHistoryRequest
     *        Container for request parameters to <code> <a>GetPackageVersionHistory</a> </code> operation.
     * @return A Java Future containing the result of the GetPackageVersionHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetPackageVersionHistory
     */
    @Override
    public CompletableFuture<GetPackageVersionHistoryResponse> getPackageVersionHistory(
            GetPackageVersionHistoryRequest getPackageVersionHistoryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPackageVersionHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPackageVersionHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPackageVersionHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPackageVersionHistoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPackageVersionHistoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPackageVersionHistoryRequest, GetPackageVersionHistoryResponse>()
                            .withOperationName("GetPackageVersionHistory")
                            .withMarshaller(new GetPackageVersionHistoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getPackageVersionHistoryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getPackageVersionHistoryRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetPackageVersionHistoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of versions of the package, along with their creation time and commit message.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getPackageVersionHistory(software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.GetPackageVersionHistoryPublisher publisher = client.getPackageVersionHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.GetPackageVersionHistoryPublisher publisher = client.getPackageVersionHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPackageVersionHistory(software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getPackageVersionHistoryRequest
     *        Container for request parameters to <code> <a>GetPackageVersionHistory</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetPackageVersionHistory
     */
    public GetPackageVersionHistoryPublisher getPackageVersionHistoryPaginator(
            GetPackageVersionHistoryRequest getPackageVersionHistoryRequest) {
        return new GetPackageVersionHistoryPublisher(this, applyPaginatorUserAgent(getPackageVersionHistoryRequest));
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        Container for request parameters to <code> <a>GetUpgradeHistory</a> </code> operation.
     * @return A Java Future containing the result of the GetUpgradeHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetUpgradeHistory
     */
    @Override
    public CompletableFuture<GetUpgradeHistoryResponse> getUpgradeHistory(GetUpgradeHistoryRequest getUpgradeHistoryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUpgradeHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUpgradeHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUpgradeHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUpgradeHistoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUpgradeHistoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUpgradeHistoryRequest, GetUpgradeHistoryResponse>()
                            .withOperationName("GetUpgradeHistory")
                            .withMarshaller(new GetUpgradeHistoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getUpgradeHistoryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getUpgradeHistoryRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetUpgradeHistoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.GetUpgradeHistoryPublisher publisher = client.getUpgradeHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.GetUpgradeHistoryPublisher publisher = client.getUpgradeHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        Container for request parameters to <code> <a>GetUpgradeHistory</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetUpgradeHistory
     */
    public GetUpgradeHistoryPublisher getUpgradeHistoryPaginator(GetUpgradeHistoryRequest getUpgradeHistoryRequest) {
        return new GetUpgradeHistoryPublisher(this, applyPaginatorUserAgent(getUpgradeHistoryRequest));
    }

    /**
     * <p>
     * Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.
     * </p>
     *
     * @param getUpgradeStatusRequest
     *        Container for request parameters to <code> <a>GetUpgradeStatus</a> </code> operation.
     * @return A Java Future containing the result of the GetUpgradeStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetUpgradeStatus
     */
    @Override
    public CompletableFuture<GetUpgradeStatusResponse> getUpgradeStatus(GetUpgradeStatusRequest getUpgradeStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUpgradeStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUpgradeStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUpgradeStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUpgradeStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUpgradeStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUpgradeStatusRequest, GetUpgradeStatusResponse>()
                            .withOperationName("GetUpgradeStatus")
                            .withMarshaller(new GetUpgradeStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getUpgradeStatusRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getUpgradeStatusRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetUpgradeStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the name of all Elasticsearch domains owned by the current user's account.
     * </p>
     *
     * @param listDomainNamesRequest
     * @return A Java Future containing the result of the ListDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListDomainNames
     */
    @Override
    public CompletableFuture<ListDomainNamesResponse> listDomainNames(ListDomainNamesRequest listDomainNamesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDomainNamesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDomainNames");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDomainNamesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDomainNamesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDomainNamesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDomainNamesRequest, ListDomainNamesResponse>()
                            .withOperationName("ListDomainNames")
                            .withMarshaller(new ListDomainNamesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDomainNamesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDomainNamesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListDomainNamesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all Amazon ES domains associated with the package.
     * </p>
     *
     * @param listDomainsForPackageRequest
     *        Container for request parameters to <code> <a>ListDomainsForPackage</a> </code> operation.
     * @return A Java Future containing the result of the ListDomainsForPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListDomainsForPackage
     */
    @Override
    public CompletableFuture<ListDomainsForPackageResponse> listDomainsForPackage(
            ListDomainsForPackageRequest listDomainsForPackageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDomainsForPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDomainsForPackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDomainsForPackageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDomainsForPackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDomainsForPackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDomainsForPackageRequest, ListDomainsForPackageResponse>()
                            .withOperationName("ListDomainsForPackage")
                            .withMarshaller(new ListDomainsForPackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDomainsForPackageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDomainsForPackageRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListDomainsForPackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all Amazon ES domains associated with the package.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDomainsForPackage(software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListDomainsForPackagePublisher publisher = client.listDomainsForPackagePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListDomainsForPackagePublisher publisher = client.listDomainsForPackagePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainsForPackage(software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDomainsForPackageRequest
     *        Container for request parameters to <code> <a>ListDomainsForPackage</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListDomainsForPackage
     */
    public ListDomainsForPackagePublisher listDomainsForPackagePaginator(ListDomainsForPackageRequest listDomainsForPackageRequest) {
        return new ListDomainsForPackagePublisher(this, applyPaginatorUserAgent(listDomainsForPackageRequest));
    }

    /**
     * <p>
     * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
     * </p>
     *
     * @param listElasticsearchInstanceTypesRequest
     *        Container for the parameters to the <code> <a>ListElasticsearchInstanceTypes</a> </code> operation.
     * @return A Java Future containing the result of the ListElasticsearchInstanceTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListElasticsearchInstanceTypes
     */
    @Override
    public CompletableFuture<ListElasticsearchInstanceTypesResponse> listElasticsearchInstanceTypes(
            ListElasticsearchInstanceTypesRequest listElasticsearchInstanceTypesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listElasticsearchInstanceTypesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListElasticsearchInstanceTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListElasticsearchInstanceTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListElasticsearchInstanceTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListElasticsearchInstanceTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListElasticsearchInstanceTypesRequest, ListElasticsearchInstanceTypesResponse>()
                            .withOperationName("ListElasticsearchInstanceTypes")
                            .withMarshaller(new ListElasticsearchInstanceTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listElasticsearchInstanceTypesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listElasticsearchInstanceTypesRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListElasticsearchInstanceTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listElasticsearchInstanceTypes(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchInstanceTypesPublisher publisher = client.listElasticsearchInstanceTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchInstanceTypesPublisher publisher = client.listElasticsearchInstanceTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listElasticsearchInstanceTypes(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listElasticsearchInstanceTypesRequest
     *        Container for the parameters to the <code> <a>ListElasticsearchInstanceTypes</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListElasticsearchInstanceTypes
     */
    public ListElasticsearchInstanceTypesPublisher listElasticsearchInstanceTypesPaginator(
            ListElasticsearchInstanceTypesRequest listElasticsearchInstanceTypesRequest) {
        return new ListElasticsearchInstanceTypesPublisher(this, applyPaginatorUserAgent(listElasticsearchInstanceTypesRequest));
    }

    /**
     * <p>
     * List all supported Elasticsearch versions
     * </p>
     *
     * @param listElasticsearchVersionsRequest
     *        Container for the parameters to the <code> <a>ListElasticsearchVersions</a> </code> operation.
     *        <p>
     *        Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single
     *        call.
     *        </p>
     *        <p>
     *        Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does
     *        not contain a NextToken, then there are no more results to retrieve.
     *        </p>
     * @return A Java Future containing the result of the ListElasticsearchVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListElasticsearchVersions
     */
    @Override
    public CompletableFuture<ListElasticsearchVersionsResponse> listElasticsearchVersions(
            ListElasticsearchVersionsRequest listElasticsearchVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listElasticsearchVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListElasticsearchVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListElasticsearchVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListElasticsearchVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListElasticsearchVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListElasticsearchVersionsRequest, ListElasticsearchVersionsResponse>()
                            .withOperationName("ListElasticsearchVersions")
                            .withMarshaller(new ListElasticsearchVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listElasticsearchVersionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listElasticsearchVersionsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListElasticsearchVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all supported Elasticsearch versions
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listElasticsearchVersions(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsPublisher publisher = client.listElasticsearchVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsPublisher publisher = client.listElasticsearchVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listElasticsearchVersions(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listElasticsearchVersionsRequest
     *        Container for the parameters to the <code> <a>ListElasticsearchVersions</a> </code> operation.
     *        <p>
     *        Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single
     *        call.
     *        </p>
     *        <p>
     *        Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does
     *        not contain a NextToken, then there are no more results to retrieve.
     *        </p>
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListElasticsearchVersions
     */
    public ListElasticsearchVersionsPublisher listElasticsearchVersionsPaginator(
            ListElasticsearchVersionsRequest listElasticsearchVersionsRequest) {
        return new ListElasticsearchVersionsPublisher(this, applyPaginatorUserAgent(listElasticsearchVersionsRequest));
    }

    /**
     * <p>
     * Lists all packages associated with the Amazon ES domain.
     * </p>
     *
     * @param listPackagesForDomainRequest
     *        Container for request parameters to <code> <a>ListPackagesForDomain</a> </code> operation.
     * @return A Java Future containing the result of the ListPackagesForDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListPackagesForDomain
     */
    @Override
    public CompletableFuture<ListPackagesForDomainResponse> listPackagesForDomain(
            ListPackagesForDomainRequest listPackagesForDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPackagesForDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPackagesForDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPackagesForDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPackagesForDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPackagesForDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPackagesForDomainRequest, ListPackagesForDomainResponse>()
                            .withOperationName("ListPackagesForDomain")
                            .withMarshaller(new ListPackagesForDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listPackagesForDomainRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listPackagesForDomainRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListPackagesForDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all packages associated with the Amazon ES domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPackagesForDomain(software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListPackagesForDomainPublisher publisher = client.listPackagesForDomainPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListPackagesForDomainPublisher publisher = client.listPackagesForDomainPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackagesForDomain(software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPackagesForDomainRequest
     *        Container for request parameters to <code> <a>ListPackagesForDomain</a> </code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListPackagesForDomain
     */
    public ListPackagesForDomainPublisher listPackagesForDomainPaginator(ListPackagesForDomainRequest listPackagesForDomainRequest) {
        return new ListPackagesForDomainPublisher(this, applyPaginatorUserAgent(listPackagesForDomainRequest));
    }

    /**
     * <p>
     * Returns all tags for the given Elasticsearch domain.
     * </p>
     *
     * @param listTagsRequest
     *        Container for the parameters to the <code><a>ListTags</a></code> operation. Specify the <code>ARN</code>
     *        for the Elasticsearch domain to which the tags are attached that you want to view are attached.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListTags
     */
    @Override
    public CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsRequest, ListTagsResponse>().withOperationName("ListTags")
                            .withMarshaller(new ListTagsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows you to purchase reserved Elasticsearch instances.
     * </p>
     *
     * @param purchaseReservedElasticsearchInstanceOfferingRequest
     *        Container for parameters to <code>PurchaseReservedElasticsearchInstanceOffering</code>
     * @return A Java Future containing the result of the PurchaseReservedElasticsearchInstanceOffering operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.PurchaseReservedElasticsearchInstanceOffering
     */
    @Override
    public CompletableFuture<PurchaseReservedElasticsearchInstanceOfferingResponse> purchaseReservedElasticsearchInstanceOffering(
            PurchaseReservedElasticsearchInstanceOfferingRequest purchaseReservedElasticsearchInstanceOfferingRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                purchaseReservedElasticsearchInstanceOfferingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PurchaseReservedElasticsearchInstanceOffering");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PurchaseReservedElasticsearchInstanceOfferingResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PurchaseReservedElasticsearchInstanceOfferingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PurchaseReservedElasticsearchInstanceOfferingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PurchaseReservedElasticsearchInstanceOfferingRequest, PurchaseReservedElasticsearchInstanceOfferingResponse>()
                            .withOperationName("PurchaseReservedElasticsearchInstanceOffering")
                            .withMarshaller(new PurchaseReservedElasticsearchInstanceOfferingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(purchaseReservedElasticsearchInstanceOfferingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = purchaseReservedElasticsearchInstanceOfferingRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<PurchaseReservedElasticsearchInstanceOfferingResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the destination domain owner to reject an inbound cross-cluster search connection request.
     * </p>
     *
     * @param rejectInboundCrossClusterSearchConnectionRequest
     *        Container for the parameters to the <code><a>RejectInboundCrossClusterSearchConnection</a></code>
     *        operation.
     * @return A Java Future containing the result of the RejectInboundCrossClusterSearchConnection operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.RejectInboundCrossClusterSearchConnection
     */
    @Override
    public CompletableFuture<RejectInboundCrossClusterSearchConnectionResponse> rejectInboundCrossClusterSearchConnection(
            RejectInboundCrossClusterSearchConnectionRequest rejectInboundCrossClusterSearchConnectionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                rejectInboundCrossClusterSearchConnectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectInboundCrossClusterSearchConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RejectInboundCrossClusterSearchConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, RejectInboundCrossClusterSearchConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RejectInboundCrossClusterSearchConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RejectInboundCrossClusterSearchConnectionRequest, RejectInboundCrossClusterSearchConnectionResponse>()
                            .withOperationName("RejectInboundCrossClusterSearchConnection")
                            .withMarshaller(new RejectInboundCrossClusterSearchConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(rejectInboundCrossClusterSearchConnectionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = rejectInboundCrossClusterSearchConnectionRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<RejectInboundCrossClusterSearchConnectionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified set of tags from the specified Elasticsearch domain.
     * </p>
     *
     * @param removeTagsRequest
     *        Container for the parameters to the <code><a>RemoveTags</a></code> operation. Specify the <code>ARN</code>
     *        for the Elasticsearch domain from which you want to remove the specified <code>TagKey</code>.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.RemoveTags
     */
    @Override
    public CompletableFuture<RemoveTagsResponse> removeTags(RemoveTagsRequest removeTagsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    RemoveTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsRequest, RemoveTagsResponse>().withOperationName("RemoveTags")
                            .withMarshaller(new RemoveTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(removeTagsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = removeTagsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<RemoveTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Schedules a service software update for an Amazon ES domain.
     * </p>
     *
     * @param startElasticsearchServiceSoftwareUpdateRequest
     *        Container for the parameters to the <code><a>StartElasticsearchServiceSoftwareUpdate</a></code> operation.
     *        Specifies the name of the Elasticsearch domain that you wish to schedule a service software update on.
     * @return A Java Future containing the result of the StartElasticsearchServiceSoftwareUpdate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.StartElasticsearchServiceSoftwareUpdate
     */
    @Override
    public CompletableFuture<StartElasticsearchServiceSoftwareUpdateResponse> startElasticsearchServiceSoftwareUpdate(
            StartElasticsearchServiceSoftwareUpdateRequest startElasticsearchServiceSoftwareUpdateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startElasticsearchServiceSoftwareUpdateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartElasticsearchServiceSoftwareUpdate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartElasticsearchServiceSoftwareUpdateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StartElasticsearchServiceSoftwareUpdateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartElasticsearchServiceSoftwareUpdateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartElasticsearchServiceSoftwareUpdateRequest, StartElasticsearchServiceSoftwareUpdateResponse>()
                            .withOperationName("StartElasticsearchServiceSoftwareUpdate")
                            .withMarshaller(new StartElasticsearchServiceSoftwareUpdateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(startElasticsearchServiceSoftwareUpdateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startElasticsearchServiceSoftwareUpdateRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<StartElasticsearchServiceSoftwareUpdateResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type
     * and the number of instances.
     * </p>
     *
     * @param updateElasticsearchDomainConfigRequest
     *        Container for the parameters to the <code><a>UpdateElasticsearchDomain</a></code> operation. Specifies the
     *        type and number of instances in the domain cluster.
     * @return A Java Future containing the result of the UpdateElasticsearchDomainConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.UpdateElasticsearchDomainConfig
     */
    @Override
    public CompletableFuture<UpdateElasticsearchDomainConfigResponse> updateElasticsearchDomainConfig(
            UpdateElasticsearchDomainConfigRequest updateElasticsearchDomainConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateElasticsearchDomainConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateElasticsearchDomainConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateElasticsearchDomainConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateElasticsearchDomainConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateElasticsearchDomainConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateElasticsearchDomainConfigRequest, UpdateElasticsearchDomainConfigResponse>()
                            .withOperationName("UpdateElasticsearchDomainConfig")
                            .withMarshaller(new UpdateElasticsearchDomainConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateElasticsearchDomainConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateElasticsearchDomainConfigRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<UpdateElasticsearchDomainConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a package for use with Amazon ES domains.
     * </p>
     *
     * @param updatePackageRequest
     *        Container for request parameters to <code> <a>UpdatePackage</a> </code> operation.
     * @return A Java Future containing the result of the UpdatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.UpdatePackage
     */
    @Override
    public CompletableFuture<UpdatePackageResponse> updatePackage(UpdatePackageRequest updatePackageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdatePackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePackageRequest, UpdatePackageResponse>()
                            .withOperationName("UpdatePackage")
                            .withMarshaller(new UpdatePackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updatePackageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updatePackageRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdatePackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows you to either upgrade your domain or perform an Upgrade eligibility check to a compatible Elasticsearch
     * version.
     * </p>
     *
     * @param upgradeElasticsearchDomainRequest
     *        Container for request parameters to <code> <a>UpgradeElasticsearchDomain</a> </code> operation.
     * @return A Java Future containing the result of the UpgradeElasticsearchDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.UpgradeElasticsearchDomain
     */
    @Override
    public CompletableFuture<UpgradeElasticsearchDomainResponse> upgradeElasticsearchDomain(
            UpgradeElasticsearchDomainRequest upgradeElasticsearchDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, upgradeElasticsearchDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpgradeElasticsearchDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpgradeElasticsearchDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpgradeElasticsearchDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpgradeElasticsearchDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpgradeElasticsearchDomainRequest, UpgradeElasticsearchDomainResponse>()
                            .withOperationName("UpgradeElasticsearchDomain")
                            .withMarshaller(new UpgradeElasticsearchDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(upgradeElasticsearchDomainRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = upgradeElasticsearchDomainRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpgradeElasticsearchDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ElasticsearchException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DisabledOperationException")
                                .exceptionBuilderSupplier(DisabledOperationException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTypeException")
                                .exceptionBuilderSupplier(InvalidTypeException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalException")
                                .exceptionBuilderSupplier(InternalException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException")
                                .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends ElasticsearchRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
