/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse;

public class DescribePackagesIterable
implements SdkIterable<DescribePackagesResponse> {
    private final ElasticsearchClient client;
    private final DescribePackagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribePackagesIterable(ElasticsearchClient client, DescribePackagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribePackagesResponseFetcher();
    }

    public Iterator<DescribePackagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribePackagesResponseFetcher
    implements SyncPageFetcher<DescribePackagesResponse> {
        private DescribePackagesResponseFetcher() {
        }

        public boolean hasNextPage(DescribePackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribePackagesResponse nextPage(DescribePackagesResponse previousPage) {
            if (previousPage == null) {
                return DescribePackagesIterable.this.client.describePackages(DescribePackagesIterable.this.firstRequest);
            }
            return DescribePackagesIterable.this.client.describePackages((DescribePackagesRequest)((Object)DescribePackagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

