/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.ColdStorageOptions;
import software.amazon.awssdk.services.elasticsearch.model.ESPartitionInstanceType;
import software.amazon.awssdk.services.elasticsearch.model.ESWarmPartitionInstanceType;
import software.amazon.awssdk.services.elasticsearch.model.ZoneAwarenessConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticsearchClusterConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ElasticsearchClusterConfig> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ElasticsearchClusterConfig.getter(ElasticsearchClusterConfig::instanceTypeAsString)).setter(ElasticsearchClusterConfig.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(ElasticsearchClusterConfig.getter(ElasticsearchClusterConfig::instanceCount)).setter(ElasticsearchClusterConfig.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final SdkField<Boolean> DEDICATED_MASTER_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DedicatedMasterEnabled").getter(ElasticsearchClusterConfig.getter(ElasticsearchClusterConfig::dedicatedMasterEnabled)).setter(ElasticsearchClusterConfig.setter(Builder::dedicatedMasterEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedMasterEnabled").build()}).build();
    private static final SdkField<Boolean> ZONE_AWARENESS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ZoneAwarenessEnabled").getter(ElasticsearchClusterConfig.getter(ElasticsearchClusterConfig::zoneAwarenessEnabled)).setter(ElasticsearchClusterConfig.setter(Builder::zoneAwarenessEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneAwarenessEnabled").build()}).build();
    private static final SdkField<ZoneAwarenessConfig> ZONE_AWARENESS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ZoneAwarenessConfig").getter(ElasticsearchClusterConfig.getter(ElasticsearchClusterConfig::zoneAwarenessConfig)).setter(ElasticsearchClusterConfig.setter(Builder::zoneAwarenessConfig)).constructor(ZoneAwarenessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneAwarenessConfig").build()}).build();
    private static final SdkField<String> DEDICATED_MASTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DedicatedMasterType").getter(ElasticsearchClusterConfig.getter(ElasticsearchClusterConfig::dedicatedMasterTypeAsString)).setter(ElasticsearchClusterConfig.setter(Builder::dedicatedMasterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedMasterType").build()}).build();
    private static final SdkField<Integer> DEDICATED_MASTER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DedicatedMasterCount").getter(ElasticsearchClusterConfig.getter(ElasticsearchClusterConfig::dedicatedMasterCount)).setter(ElasticsearchClusterConfig.setter(Builder::dedicatedMasterCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedMasterCount").build()}).build();
    private static final SdkField<Boolean> WARM_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("WarmEnabled").getter(ElasticsearchClusterConfig.getter(ElasticsearchClusterConfig::warmEnabled)).setter(ElasticsearchClusterConfig.setter(Builder::warmEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmEnabled").build()}).build();
    private static final SdkField<String> WARM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WarmType").getter(ElasticsearchClusterConfig.getter(ElasticsearchClusterConfig::warmTypeAsString)).setter(ElasticsearchClusterConfig.setter(Builder::warmType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmType").build()}).build();
    private static final SdkField<Integer> WARM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WarmCount").getter(ElasticsearchClusterConfig.getter(ElasticsearchClusterConfig::warmCount)).setter(ElasticsearchClusterConfig.setter(Builder::warmCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmCount").build()}).build();
    private static final SdkField<ColdStorageOptions> COLD_STORAGE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColdStorageOptions").getter(ElasticsearchClusterConfig.getter(ElasticsearchClusterConfig::coldStorageOptions)).setter(ElasticsearchClusterConfig.setter(Builder::coldStorageOptions)).constructor(ColdStorageOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColdStorageOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, INSTANCE_COUNT_FIELD, DEDICATED_MASTER_ENABLED_FIELD, ZONE_AWARENESS_ENABLED_FIELD, ZONE_AWARENESS_CONFIG_FIELD, DEDICATED_MASTER_TYPE_FIELD, DEDICATED_MASTER_COUNT_FIELD, WARM_ENABLED_FIELD, WARM_TYPE_FIELD, WARM_COUNT_FIELD, COLD_STORAGE_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final Integer instanceCount;
    private final Boolean dedicatedMasterEnabled;
    private final Boolean zoneAwarenessEnabled;
    private final ZoneAwarenessConfig zoneAwarenessConfig;
    private final String dedicatedMasterType;
    private final Integer dedicatedMasterCount;
    private final Boolean warmEnabled;
    private final String warmType;
    private final Integer warmCount;
    private final ColdStorageOptions coldStorageOptions;

    private ElasticsearchClusterConfig(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.dedicatedMasterEnabled = builder.dedicatedMasterEnabled;
        this.zoneAwarenessEnabled = builder.zoneAwarenessEnabled;
        this.zoneAwarenessConfig = builder.zoneAwarenessConfig;
        this.dedicatedMasterType = builder.dedicatedMasterType;
        this.dedicatedMasterCount = builder.dedicatedMasterCount;
        this.warmEnabled = builder.warmEnabled;
        this.warmType = builder.warmType;
        this.warmCount = builder.warmCount;
        this.coldStorageOptions = builder.coldStorageOptions;
    }

    public final ESPartitionInstanceType instanceType() {
        return ESPartitionInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final Boolean dedicatedMasterEnabled() {
        return this.dedicatedMasterEnabled;
    }

    public final Boolean zoneAwarenessEnabled() {
        return this.zoneAwarenessEnabled;
    }

    public final ZoneAwarenessConfig zoneAwarenessConfig() {
        return this.zoneAwarenessConfig;
    }

    public final ESPartitionInstanceType dedicatedMasterType() {
        return ESPartitionInstanceType.fromValue(this.dedicatedMasterType);
    }

    public final String dedicatedMasterTypeAsString() {
        return this.dedicatedMasterType;
    }

    public final Integer dedicatedMasterCount() {
        return this.dedicatedMasterCount;
    }

    public final Boolean warmEnabled() {
        return this.warmEnabled;
    }

    public final ESWarmPartitionInstanceType warmType() {
        return ESWarmPartitionInstanceType.fromValue(this.warmType);
    }

    public final String warmTypeAsString() {
        return this.warmType;
    }

    public final Integer warmCount() {
        return this.warmCount;
    }

    public final ColdStorageOptions coldStorageOptions() {
        return this.coldStorageOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedMasterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneAwarenessEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneAwarenessConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedMasterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedMasterCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.coldStorageOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchClusterConfig)) {
            return false;
        }
        ElasticsearchClusterConfig other = (ElasticsearchClusterConfig)obj;
        return Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.dedicatedMasterEnabled(), other.dedicatedMasterEnabled()) && Objects.equals(this.zoneAwarenessEnabled(), other.zoneAwarenessEnabled()) && Objects.equals(this.zoneAwarenessConfig(), other.zoneAwarenessConfig()) && Objects.equals(this.dedicatedMasterTypeAsString(), other.dedicatedMasterTypeAsString()) && Objects.equals(this.dedicatedMasterCount(), other.dedicatedMasterCount()) && Objects.equals(this.warmEnabled(), other.warmEnabled()) && Objects.equals(this.warmTypeAsString(), other.warmTypeAsString()) && Objects.equals(this.warmCount(), other.warmCount()) && Objects.equals(this.coldStorageOptions(), other.coldStorageOptions());
    }

    public final String toString() {
        return ToString.builder((String)"ElasticsearchClusterConfig").add("InstanceType", (Object)this.instanceTypeAsString()).add("InstanceCount", (Object)this.instanceCount()).add("DedicatedMasterEnabled", (Object)this.dedicatedMasterEnabled()).add("ZoneAwarenessEnabled", (Object)this.zoneAwarenessEnabled()).add("ZoneAwarenessConfig", (Object)this.zoneAwarenessConfig()).add("DedicatedMasterType", (Object)this.dedicatedMasterTypeAsString()).add("DedicatedMasterCount", (Object)this.dedicatedMasterCount()).add("WarmEnabled", (Object)this.warmEnabled()).add("WarmType", (Object)this.warmTypeAsString()).add("WarmCount", (Object)this.warmCount()).add("ColdStorageOptions", (Object)this.coldStorageOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "DedicatedMasterEnabled": {
                return Optional.ofNullable(clazz.cast(this.dedicatedMasterEnabled()));
            }
            case "ZoneAwarenessEnabled": {
                return Optional.ofNullable(clazz.cast(this.zoneAwarenessEnabled()));
            }
            case "ZoneAwarenessConfig": {
                return Optional.ofNullable(clazz.cast(this.zoneAwarenessConfig()));
            }
            case "DedicatedMasterType": {
                return Optional.ofNullable(clazz.cast(this.dedicatedMasterTypeAsString()));
            }
            case "DedicatedMasterCount": {
                return Optional.ofNullable(clazz.cast(this.dedicatedMasterCount()));
            }
            case "WarmEnabled": {
                return Optional.ofNullable(clazz.cast(this.warmEnabled()));
            }
            case "WarmType": {
                return Optional.ofNullable(clazz.cast(this.warmTypeAsString()));
            }
            case "WarmCount": {
                return Optional.ofNullable(clazz.cast(this.warmCount()));
            }
            case "ColdStorageOptions": {
                return Optional.ofNullable(clazz.cast(this.coldStorageOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticsearchClusterConfig, T> g) {
        return obj -> g.apply((ElasticsearchClusterConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private Integer instanceCount;
        private Boolean dedicatedMasterEnabled;
        private Boolean zoneAwarenessEnabled;
        private ZoneAwarenessConfig zoneAwarenessConfig;
        private String dedicatedMasterType;
        private Integer dedicatedMasterCount;
        private Boolean warmEnabled;
        private String warmType;
        private Integer warmCount;
        private ColdStorageOptions coldStorageOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchClusterConfig model) {
            this.instanceType(model.instanceType);
            this.instanceCount(model.instanceCount);
            this.dedicatedMasterEnabled(model.dedicatedMasterEnabled);
            this.zoneAwarenessEnabled(model.zoneAwarenessEnabled);
            this.zoneAwarenessConfig(model.zoneAwarenessConfig);
            this.dedicatedMasterType(model.dedicatedMasterType);
            this.dedicatedMasterCount(model.dedicatedMasterCount);
            this.warmEnabled(model.warmEnabled);
            this.warmType(model.warmType);
            this.warmCount(model.warmCount);
            this.coldStorageOptions(model.coldStorageOptions);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ESPartitionInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Boolean getDedicatedMasterEnabled() {
            return this.dedicatedMasterEnabled;
        }

        @Override
        public final Builder dedicatedMasterEnabled(Boolean dedicatedMasterEnabled) {
            this.dedicatedMasterEnabled = dedicatedMasterEnabled;
            return this;
        }

        public final void setDedicatedMasterEnabled(Boolean dedicatedMasterEnabled) {
            this.dedicatedMasterEnabled = dedicatedMasterEnabled;
        }

        public final Boolean getZoneAwarenessEnabled() {
            return this.zoneAwarenessEnabled;
        }

        @Override
        public final Builder zoneAwarenessEnabled(Boolean zoneAwarenessEnabled) {
            this.zoneAwarenessEnabled = zoneAwarenessEnabled;
            return this;
        }

        public final void setZoneAwarenessEnabled(Boolean zoneAwarenessEnabled) {
            this.zoneAwarenessEnabled = zoneAwarenessEnabled;
        }

        public final ZoneAwarenessConfig.Builder getZoneAwarenessConfig() {
            return this.zoneAwarenessConfig != null ? this.zoneAwarenessConfig.toBuilder() : null;
        }

        @Override
        public final Builder zoneAwarenessConfig(ZoneAwarenessConfig zoneAwarenessConfig) {
            this.zoneAwarenessConfig = zoneAwarenessConfig;
            return this;
        }

        public final void setZoneAwarenessConfig(ZoneAwarenessConfig.BuilderImpl zoneAwarenessConfig) {
            this.zoneAwarenessConfig = zoneAwarenessConfig != null ? zoneAwarenessConfig.build() : null;
        }

        public final String getDedicatedMasterType() {
            return this.dedicatedMasterType;
        }

        @Override
        public final Builder dedicatedMasterType(String dedicatedMasterType) {
            this.dedicatedMasterType = dedicatedMasterType;
            return this;
        }

        @Override
        public final Builder dedicatedMasterType(ESPartitionInstanceType dedicatedMasterType) {
            this.dedicatedMasterType(dedicatedMasterType == null ? null : dedicatedMasterType.toString());
            return this;
        }

        public final void setDedicatedMasterType(String dedicatedMasterType) {
            this.dedicatedMasterType = dedicatedMasterType;
        }

        public final Integer getDedicatedMasterCount() {
            return this.dedicatedMasterCount;
        }

        @Override
        public final Builder dedicatedMasterCount(Integer dedicatedMasterCount) {
            this.dedicatedMasterCount = dedicatedMasterCount;
            return this;
        }

        public final void setDedicatedMasterCount(Integer dedicatedMasterCount) {
            this.dedicatedMasterCount = dedicatedMasterCount;
        }

        public final Boolean getWarmEnabled() {
            return this.warmEnabled;
        }

        @Override
        public final Builder warmEnabled(Boolean warmEnabled) {
            this.warmEnabled = warmEnabled;
            return this;
        }

        public final void setWarmEnabled(Boolean warmEnabled) {
            this.warmEnabled = warmEnabled;
        }

        public final String getWarmType() {
            return this.warmType;
        }

        @Override
        public final Builder warmType(String warmType) {
            this.warmType = warmType;
            return this;
        }

        @Override
        public final Builder warmType(ESWarmPartitionInstanceType warmType) {
            this.warmType(warmType == null ? null : warmType.toString());
            return this;
        }

        public final void setWarmType(String warmType) {
            this.warmType = warmType;
        }

        public final Integer getWarmCount() {
            return this.warmCount;
        }

        @Override
        public final Builder warmCount(Integer warmCount) {
            this.warmCount = warmCount;
            return this;
        }

        public final void setWarmCount(Integer warmCount) {
            this.warmCount = warmCount;
        }

        public final ColdStorageOptions.Builder getColdStorageOptions() {
            return this.coldStorageOptions != null ? this.coldStorageOptions.toBuilder() : null;
        }

        @Override
        public final Builder coldStorageOptions(ColdStorageOptions coldStorageOptions) {
            this.coldStorageOptions = coldStorageOptions;
            return this;
        }

        public final void setColdStorageOptions(ColdStorageOptions.BuilderImpl coldStorageOptions) {
            this.coldStorageOptions = coldStorageOptions != null ? coldStorageOptions.build() : null;
        }

        public ElasticsearchClusterConfig build() {
            return new ElasticsearchClusterConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ElasticsearchClusterConfig> {
        public Builder instanceType(String var1);

        public Builder instanceType(ESPartitionInstanceType var1);

        public Builder instanceCount(Integer var1);

        public Builder dedicatedMasterEnabled(Boolean var1);

        public Builder zoneAwarenessEnabled(Boolean var1);

        public Builder zoneAwarenessConfig(ZoneAwarenessConfig var1);

        default public Builder zoneAwarenessConfig(Consumer<ZoneAwarenessConfig.Builder> zoneAwarenessConfig) {
            return this.zoneAwarenessConfig((ZoneAwarenessConfig)((ZoneAwarenessConfig.Builder)ZoneAwarenessConfig.builder().applyMutation(zoneAwarenessConfig)).build());
        }

        public Builder dedicatedMasterType(String var1);

        public Builder dedicatedMasterType(ESPartitionInstanceType var1);

        public Builder dedicatedMasterCount(Integer var1);

        public Builder warmEnabled(Boolean var1);

        public Builder warmType(String var1);

        public Builder warmType(ESWarmPartitionInstanceType var1);

        public Builder warmCount(Integer var1);

        public Builder coldStorageOptions(ColdStorageOptions var1);

        default public Builder coldStorageOptions(Consumer<ColdStorageOptions.Builder> coldStorageOptions) {
            return this.coldStorageOptions((ColdStorageOptions)((ColdStorageOptions.Builder)ColdStorageOptions.builder().applyMutation(coldStorageOptions)).build());
        }
    }
}

