/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.StorageTypeLimit;
import software.amazon.awssdk.services.elasticsearch.model.StorageTypeLimitListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StorageType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StorageType> {
    private static final SdkField<String> STORAGE_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageTypeName").getter(StorageType.getter(StorageType::storageTypeName)).setter(StorageType.setter(Builder::storageTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageTypeName").build()}).build();
    private static final SdkField<String> STORAGE_SUB_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageSubTypeName").getter(StorageType.getter(StorageType::storageSubTypeName)).setter(StorageType.setter(Builder::storageSubTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSubTypeName").build()}).build();
    private static final SdkField<List<StorageTypeLimit>> STORAGE_TYPE_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StorageTypeLimits").getter(StorageType.getter(StorageType::storageTypeLimits)).setter(StorageType.setter(Builder::storageTypeLimits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageTypeLimits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StorageTypeLimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_NAME_FIELD, STORAGE_SUB_TYPE_NAME_FIELD, STORAGE_TYPE_LIMITS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String storageTypeName;
    private final String storageSubTypeName;
    private final List<StorageTypeLimit> storageTypeLimits;

    private StorageType(BuilderImpl builder) {
        this.storageTypeName = builder.storageTypeName;
        this.storageSubTypeName = builder.storageSubTypeName;
        this.storageTypeLimits = builder.storageTypeLimits;
    }

    public final String storageTypeName() {
        return this.storageTypeName;
    }

    public final String storageSubTypeName() {
        return this.storageSubTypeName;
    }

    public final boolean hasStorageTypeLimits() {
        return this.storageTypeLimits != null && !(this.storageTypeLimits instanceof SdkAutoConstructList);
    }

    public final List<StorageTypeLimit> storageTypeLimits() {
        return this.storageTypeLimits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageSubTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageTypeLimits() ? this.storageTypeLimits() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageType)) {
            return false;
        }
        StorageType other = (StorageType)obj;
        return Objects.equals(this.storageTypeName(), other.storageTypeName()) && Objects.equals(this.storageSubTypeName(), other.storageSubTypeName()) && this.hasStorageTypeLimits() == other.hasStorageTypeLimits() && Objects.equals(this.storageTypeLimits(), other.storageTypeLimits());
    }

    public final String toString() {
        return ToString.builder((String)"StorageType").add("StorageTypeName", (Object)this.storageTypeName()).add("StorageSubTypeName", (Object)this.storageSubTypeName()).add("StorageTypeLimits", this.hasStorageTypeLimits() ? this.storageTypeLimits() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageTypeName": {
                return Optional.ofNullable(clazz.cast(this.storageTypeName()));
            }
            case "StorageSubTypeName": {
                return Optional.ofNullable(clazz.cast(this.storageSubTypeName()));
            }
            case "StorageTypeLimits": {
                return Optional.ofNullable(clazz.cast(this.storageTypeLimits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorageType, T> g) {
        return obj -> g.apply((StorageType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String storageTypeName;
        private String storageSubTypeName;
        private List<StorageTypeLimit> storageTypeLimits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StorageType model) {
            this.storageTypeName(model.storageTypeName);
            this.storageSubTypeName(model.storageSubTypeName);
            this.storageTypeLimits(model.storageTypeLimits);
        }

        public final String getStorageTypeName() {
            return this.storageTypeName;
        }

        @Override
        public final Builder storageTypeName(String storageTypeName) {
            this.storageTypeName = storageTypeName;
            return this;
        }

        public final void setStorageTypeName(String storageTypeName) {
            this.storageTypeName = storageTypeName;
        }

        public final String getStorageSubTypeName() {
            return this.storageSubTypeName;
        }

        @Override
        public final Builder storageSubTypeName(String storageSubTypeName) {
            this.storageSubTypeName = storageSubTypeName;
            return this;
        }

        public final void setStorageSubTypeName(String storageSubTypeName) {
            this.storageSubTypeName = storageSubTypeName;
        }

        public final Collection<StorageTypeLimit.Builder> getStorageTypeLimits() {
            if (this.storageTypeLimits instanceof SdkAutoConstructList) {
                return null;
            }
            return this.storageTypeLimits != null ? (Collection)this.storageTypeLimits.stream().map(StorageTypeLimit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageTypeLimits(Collection<StorageTypeLimit> storageTypeLimits) {
            this.storageTypeLimits = StorageTypeLimitListCopier.copy(storageTypeLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageTypeLimits(StorageTypeLimit ... storageTypeLimits) {
            this.storageTypeLimits(Arrays.asList(storageTypeLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageTypeLimits(Consumer<StorageTypeLimit.Builder> ... storageTypeLimits) {
            this.storageTypeLimits(Stream.of(storageTypeLimits).map(c -> (StorageTypeLimit)((StorageTypeLimit.Builder)StorageTypeLimit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStorageTypeLimits(Collection<StorageTypeLimit.BuilderImpl> storageTypeLimits) {
            this.storageTypeLimits = StorageTypeLimitListCopier.copyFromBuilder(storageTypeLimits);
        }

        public StorageType build() {
            return new StorageType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StorageType> {
        public Builder storageTypeName(String var1);

        public Builder storageSubTypeName(String var1);

        public Builder storageTypeLimits(Collection<StorageTypeLimit> var1);

        public Builder storageTypeLimits(StorageTypeLimit ... var1);

        public Builder storageTypeLimits(Consumer<StorageTypeLimit.Builder> ... var1);
    }
}

