/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchAsyncClient;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageResponse;

public class ListDomainsForPackagePublisher
implements SdkPublisher<ListDomainsForPackageResponse> {
    private final ElasticsearchAsyncClient client;
    private final ListDomainsForPackageRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDomainsForPackagePublisher(ElasticsearchAsyncClient client, ListDomainsForPackageRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDomainsForPackagePublisher(ElasticsearchAsyncClient client, ListDomainsForPackageRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDomainsForPackageResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDomainsForPackageResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDomainsForPackageResponseFetcher
    implements AsyncPageFetcher<ListDomainsForPackageResponse> {
        private ListDomainsForPackageResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainsForPackageResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDomainsForPackageResponse> nextPage(ListDomainsForPackageResponse previousPage) {
            if (previousPage == null) {
                return ListDomainsForPackagePublisher.this.client.listDomainsForPackage(ListDomainsForPackagePublisher.this.firstRequest);
            }
            return ListDomainsForPackagePublisher.this.client.listDomainsForPackage((ListDomainsForPackageRequest)((Object)ListDomainsForPackagePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

