/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.ClusterVersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterVersionInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterVersionInformation> {
    private static final SdkField<String> CLUSTER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterVersion").getter(ClusterVersionInformation.getter(ClusterVersionInformation::clusterVersion)).setter(ClusterVersionInformation.setter(Builder::clusterVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterVersion").build()}).build();
    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterType").getter(ClusterVersionInformation.getter(ClusterVersionInformation::clusterType)).setter(ClusterVersionInformation.setter(Builder::clusterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()}).build();
    private static final SdkField<String> DEFAULT_PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultPlatformVersion").getter(ClusterVersionInformation.getter(ClusterVersionInformation::defaultPlatformVersion)).setter(ClusterVersionInformation.setter(Builder::defaultPlatformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultPlatformVersion").build()}).build();
    private static final SdkField<Boolean> DEFAULT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("defaultVersion").getter(ClusterVersionInformation.getter(ClusterVersionInformation::defaultVersion)).setter(ClusterVersionInformation.setter(Builder::defaultVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersion").build()}).build();
    private static final SdkField<Instant> RELEASE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("releaseDate").getter(ClusterVersionInformation.getter(ClusterVersionInformation::releaseDate)).setter(ClusterVersionInformation.setter(Builder::releaseDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseDate").build()}).build();
    private static final SdkField<Instant> END_OF_STANDARD_SUPPORT_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endOfStandardSupportDate").getter(ClusterVersionInformation.getter(ClusterVersionInformation::endOfStandardSupportDate)).setter(ClusterVersionInformation.setter(Builder::endOfStandardSupportDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endOfStandardSupportDate").build()}).build();
    private static final SdkField<Instant> END_OF_EXTENDED_SUPPORT_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endOfExtendedSupportDate").getter(ClusterVersionInformation.getter(ClusterVersionInformation::endOfExtendedSupportDate)).setter(ClusterVersionInformation.setter(Builder::endOfExtendedSupportDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endOfExtendedSupportDate").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ClusterVersionInformation.getter(ClusterVersionInformation::statusAsString)).setter(ClusterVersionInformation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> KUBERNETES_PATCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kubernetesPatchVersion").getter(ClusterVersionInformation.getter(ClusterVersionInformation::kubernetesPatchVersion)).setter(ClusterVersionInformation.setter(Builder::kubernetesPatchVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesPatchVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_VERSION_FIELD, CLUSTER_TYPE_FIELD, DEFAULT_PLATFORM_VERSION_FIELD, DEFAULT_VERSION_FIELD, RELEASE_DATE_FIELD, END_OF_STANDARD_SUPPORT_DATE_FIELD, END_OF_EXTENDED_SUPPORT_DATE_FIELD, STATUS_FIELD, KUBERNETES_PATCH_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterVersionInformation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clusterVersion;
    private final String clusterType;
    private final String defaultPlatformVersion;
    private final Boolean defaultVersion;
    private final Instant releaseDate;
    private final Instant endOfStandardSupportDate;
    private final Instant endOfExtendedSupportDate;
    private final String status;
    private final String kubernetesPatchVersion;

    private ClusterVersionInformation(BuilderImpl builder) {
        this.clusterVersion = builder.clusterVersion;
        this.clusterType = builder.clusterType;
        this.defaultPlatformVersion = builder.defaultPlatformVersion;
        this.defaultVersion = builder.defaultVersion;
        this.releaseDate = builder.releaseDate;
        this.endOfStandardSupportDate = builder.endOfStandardSupportDate;
        this.endOfExtendedSupportDate = builder.endOfExtendedSupportDate;
        this.status = builder.status;
        this.kubernetesPatchVersion = builder.kubernetesPatchVersion;
    }

    public final String clusterVersion() {
        return this.clusterVersion;
    }

    public final String clusterType() {
        return this.clusterType;
    }

    public final String defaultPlatformVersion() {
        return this.defaultPlatformVersion;
    }

    public final Boolean defaultVersion() {
        return this.defaultVersion;
    }

    public final Instant releaseDate() {
        return this.releaseDate;
    }

    public final Instant endOfStandardSupportDate() {
        return this.endOfStandardSupportDate;
    }

    public final Instant endOfExtendedSupportDate() {
        return this.endOfExtendedSupportDate;
    }

    public final ClusterVersionStatus status() {
        return ClusterVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String kubernetesPatchVersion() {
        return this.kubernetesPatchVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterType());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultPlatformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOfStandardSupportDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOfExtendedSupportDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetesPatchVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterVersionInformation)) {
            return false;
        }
        ClusterVersionInformation other = (ClusterVersionInformation)obj;
        return Objects.equals(this.clusterVersion(), other.clusterVersion()) && Objects.equals(this.clusterType(), other.clusterType()) && Objects.equals(this.defaultPlatformVersion(), other.defaultPlatformVersion()) && Objects.equals(this.defaultVersion(), other.defaultVersion()) && Objects.equals(this.releaseDate(), other.releaseDate()) && Objects.equals(this.endOfStandardSupportDate(), other.endOfStandardSupportDate()) && Objects.equals(this.endOfExtendedSupportDate(), other.endOfExtendedSupportDate()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.kubernetesPatchVersion(), other.kubernetesPatchVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterVersionInformation").add("ClusterVersion", (Object)this.clusterVersion()).add("ClusterType", (Object)this.clusterType()).add("DefaultPlatformVersion", (Object)this.defaultPlatformVersion()).add("DefaultVersion", (Object)this.defaultVersion()).add("ReleaseDate", (Object)this.releaseDate()).add("EndOfStandardSupportDate", (Object)this.endOfStandardSupportDate()).add("EndOfExtendedSupportDate", (Object)this.endOfExtendedSupportDate()).add("Status", (Object)this.statusAsString()).add("KubernetesPatchVersion", (Object)this.kubernetesPatchVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterVersion": {
                return Optional.ofNullable(clazz.cast(this.clusterVersion()));
            }
            case "clusterType": {
                return Optional.ofNullable(clazz.cast(this.clusterType()));
            }
            case "defaultPlatformVersion": {
                return Optional.ofNullable(clazz.cast(this.defaultPlatformVersion()));
            }
            case "defaultVersion": {
                return Optional.ofNullable(clazz.cast(this.defaultVersion()));
            }
            case "releaseDate": {
                return Optional.ofNullable(clazz.cast(this.releaseDate()));
            }
            case "endOfStandardSupportDate": {
                return Optional.ofNullable(clazz.cast(this.endOfStandardSupportDate()));
            }
            case "endOfExtendedSupportDate": {
                return Optional.ofNullable(clazz.cast(this.endOfExtendedSupportDate()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "kubernetesPatchVersion": {
                return Optional.ofNullable(clazz.cast(this.kubernetesPatchVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clusterVersion", CLUSTER_VERSION_FIELD);
        map.put("clusterType", CLUSTER_TYPE_FIELD);
        map.put("defaultPlatformVersion", DEFAULT_PLATFORM_VERSION_FIELD);
        map.put("defaultVersion", DEFAULT_VERSION_FIELD);
        map.put("releaseDate", RELEASE_DATE_FIELD);
        map.put("endOfStandardSupportDate", END_OF_STANDARD_SUPPORT_DATE_FIELD);
        map.put("endOfExtendedSupportDate", END_OF_EXTENDED_SUPPORT_DATE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("kubernetesPatchVersion", KUBERNETES_PATCH_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterVersionInformation, T> g) {
        return obj -> g.apply((ClusterVersionInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterVersion;
        private String clusterType;
        private String defaultPlatformVersion;
        private Boolean defaultVersion;
        private Instant releaseDate;
        private Instant endOfStandardSupportDate;
        private Instant endOfExtendedSupportDate;
        private String status;
        private String kubernetesPatchVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterVersionInformation model) {
            this.clusterVersion(model.clusterVersion);
            this.clusterType(model.clusterType);
            this.defaultPlatformVersion(model.defaultPlatformVersion);
            this.defaultVersion(model.defaultVersion);
            this.releaseDate(model.releaseDate);
            this.endOfStandardSupportDate(model.endOfStandardSupportDate);
            this.endOfExtendedSupportDate(model.endOfExtendedSupportDate);
            this.status(model.status);
            this.kubernetesPatchVersion(model.kubernetesPatchVersion);
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public final String getDefaultPlatformVersion() {
            return this.defaultPlatformVersion;
        }

        public final void setDefaultPlatformVersion(String defaultPlatformVersion) {
            this.defaultPlatformVersion = defaultPlatformVersion;
        }

        @Override
        public final Builder defaultPlatformVersion(String defaultPlatformVersion) {
            this.defaultPlatformVersion = defaultPlatformVersion;
            return this;
        }

        public final Boolean getDefaultVersion() {
            return this.defaultVersion;
        }

        public final void setDefaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        @Override
        public final Builder defaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final Instant getReleaseDate() {
            return this.releaseDate;
        }

        public final void setReleaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
        }

        @Override
        public final Builder releaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public final Instant getEndOfStandardSupportDate() {
            return this.endOfStandardSupportDate;
        }

        public final void setEndOfStandardSupportDate(Instant endOfStandardSupportDate) {
            this.endOfStandardSupportDate = endOfStandardSupportDate;
        }

        @Override
        public final Builder endOfStandardSupportDate(Instant endOfStandardSupportDate) {
            this.endOfStandardSupportDate = endOfStandardSupportDate;
            return this;
        }

        public final Instant getEndOfExtendedSupportDate() {
            return this.endOfExtendedSupportDate;
        }

        public final void setEndOfExtendedSupportDate(Instant endOfExtendedSupportDate) {
            this.endOfExtendedSupportDate = endOfExtendedSupportDate;
        }

        @Override
        public final Builder endOfExtendedSupportDate(Instant endOfExtendedSupportDate) {
            this.endOfExtendedSupportDate = endOfExtendedSupportDate;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getKubernetesPatchVersion() {
            return this.kubernetesPatchVersion;
        }

        public final void setKubernetesPatchVersion(String kubernetesPatchVersion) {
            this.kubernetesPatchVersion = kubernetesPatchVersion;
        }

        @Override
        public final Builder kubernetesPatchVersion(String kubernetesPatchVersion) {
            this.kubernetesPatchVersion = kubernetesPatchVersion;
            return this;
        }

        public ClusterVersionInformation build() {
            return new ClusterVersionInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterVersionInformation> {
        public Builder clusterVersion(String var1);

        public Builder clusterType(String var1);

        public Builder defaultPlatformVersion(String var1);

        public Builder defaultVersion(Boolean var1);

        public Builder releaseDate(Instant var1);

        public Builder endOfStandardSupportDate(Instant var1);

        public Builder endOfExtendedSupportDate(Instant var1);

        public Builder status(String var1);

        public Builder status(ClusterVersionStatus var1);

        public Builder kubernetesPatchVersion(String var1);
    }
}

