/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.EksAnywhereSubscriptionLicenseType;
import software.amazon.awssdk.services.eks.model.EksAnywhereSubscriptionTerm;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EksAnywhereSubscription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EksAnywhereSubscription> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(EksAnywhereSubscription.getter(EksAnywhereSubscription::id)).setter(EksAnywhereSubscription.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(EksAnywhereSubscription.getter(EksAnywhereSubscription::arn)).setter(EksAnywhereSubscription.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(EksAnywhereSubscription.getter(EksAnywhereSubscription::createdAt)).setter(EksAnywhereSubscription.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> EFFECTIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("effectiveDate").getter(EksAnywhereSubscription.getter(EksAnywhereSubscription::effectiveDate)).setter(EksAnywhereSubscription.setter(Builder::effectiveDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveDate").build()}).build();
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expirationDate").getter(EksAnywhereSubscription.getter(EksAnywhereSubscription::expirationDate)).setter(EksAnywhereSubscription.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build()}).build();
    private static final SdkField<Integer> LICENSE_QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("licenseQuantity").getter(EksAnywhereSubscription.getter(EksAnywhereSubscription::licenseQuantity)).setter(EksAnywhereSubscription.setter(Builder::licenseQuantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseQuantity").build()}).build();
    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseType").getter(EksAnywhereSubscription.getter(EksAnywhereSubscription::licenseTypeAsString)).setter(EksAnywhereSubscription.setter(Builder::licenseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseType").build()}).build();
    private static final SdkField<EksAnywhereSubscriptionTerm> TERM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("term").getter(EksAnywhereSubscription.getter(EksAnywhereSubscription::term)).setter(EksAnywhereSubscription.setter(Builder::term)).constructor(EksAnywhereSubscriptionTerm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("term").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(EksAnywhereSubscription.getter(EksAnywhereSubscription::status)).setter(EksAnywhereSubscription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Boolean> AUTO_RENEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoRenew").getter(EksAnywhereSubscription.getter(EksAnywhereSubscription::autoRenew)).setter(EksAnywhereSubscription.setter(Builder::autoRenew)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRenew").build()}).build();
    private static final SdkField<List<String>> LICENSE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("licenseArns").getter(EksAnywhereSubscription.getter(EksAnywhereSubscription::licenseArns)).setter(EksAnywhereSubscription.setter(Builder::licenseArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(EksAnywhereSubscription.getter(EksAnywhereSubscription::tags)).setter(EksAnywhereSubscription.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, CREATED_AT_FIELD, EFFECTIVE_DATE_FIELD, EXPIRATION_DATE_FIELD, LICENSE_QUANTITY_FIELD, LICENSE_TYPE_FIELD, TERM_FIELD, STATUS_FIELD, AUTO_RENEW_FIELD, LICENSE_ARNS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EksAnywhereSubscription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final Instant createdAt;
    private final Instant effectiveDate;
    private final Instant expirationDate;
    private final Integer licenseQuantity;
    private final String licenseType;
    private final EksAnywhereSubscriptionTerm term;
    private final String status;
    private final Boolean autoRenew;
    private final List<String> licenseArns;
    private final Map<String, String> tags;

    private EksAnywhereSubscription(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.effectiveDate = builder.effectiveDate;
        this.expirationDate = builder.expirationDate;
        this.licenseQuantity = builder.licenseQuantity;
        this.licenseType = builder.licenseType;
        this.term = builder.term;
        this.status = builder.status;
        this.autoRenew = builder.autoRenew;
        this.licenseArns = builder.licenseArns;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant effectiveDate() {
        return this.effectiveDate;
    }

    public final Instant expirationDate() {
        return this.expirationDate;
    }

    public final Integer licenseQuantity() {
        return this.licenseQuantity;
    }

    public final EksAnywhereSubscriptionLicenseType licenseType() {
        return EksAnywhereSubscriptionLicenseType.fromValue(this.licenseType);
    }

    public final String licenseTypeAsString() {
        return this.licenseType;
    }

    public final EksAnywhereSubscriptionTerm term() {
        return this.term;
    }

    public final String status() {
        return this.status;
    }

    public final Boolean autoRenew() {
        return this.autoRenew;
    }

    public final boolean hasLicenseArns() {
        return this.licenseArns != null && !(this.licenseArns instanceof SdkAutoConstructList);
    }

    public final List<String> licenseArns() {
        return this.licenseArns;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.term());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseArns() ? this.licenseArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksAnywhereSubscription)) {
            return false;
        }
        EksAnywhereSubscription other = (EksAnywhereSubscription)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.effectiveDate(), other.effectiveDate()) && Objects.equals(this.expirationDate(), other.expirationDate()) && Objects.equals(this.licenseQuantity(), other.licenseQuantity()) && Objects.equals(this.licenseTypeAsString(), other.licenseTypeAsString()) && Objects.equals(this.term(), other.term()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.autoRenew(), other.autoRenew()) && this.hasLicenseArns() == other.hasLicenseArns() && Objects.equals(this.licenseArns(), other.licenseArns()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"EksAnywhereSubscription").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("EffectiveDate", (Object)this.effectiveDate()).add("ExpirationDate", (Object)this.expirationDate()).add("LicenseQuantity", (Object)this.licenseQuantity()).add("LicenseType", (Object)this.licenseTypeAsString()).add("Term", (Object)this.term()).add("Status", (Object)this.status()).add("AutoRenew", (Object)this.autoRenew()).add("LicenseArns", this.hasLicenseArns() ? this.licenseArns() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "effectiveDate": {
                return Optional.ofNullable(clazz.cast(this.effectiveDate()));
            }
            case "expirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
            case "licenseQuantity": {
                return Optional.ofNullable(clazz.cast(this.licenseQuantity()));
            }
            case "licenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseTypeAsString()));
            }
            case "term": {
                return Optional.ofNullable(clazz.cast(this.term()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "autoRenew": {
                return Optional.ofNullable(clazz.cast(this.autoRenew()));
            }
            case "licenseArns": {
                return Optional.ofNullable(clazz.cast(this.licenseArns()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("effectiveDate", EFFECTIVE_DATE_FIELD);
        map.put("expirationDate", EXPIRATION_DATE_FIELD);
        map.put("licenseQuantity", LICENSE_QUANTITY_FIELD);
        map.put("licenseType", LICENSE_TYPE_FIELD);
        map.put("term", TERM_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("autoRenew", AUTO_RENEW_FIELD);
        map.put("licenseArns", LICENSE_ARNS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EksAnywhereSubscription, T> g) {
        return obj -> g.apply((EksAnywhereSubscription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private Instant createdAt;
        private Instant effectiveDate;
        private Instant expirationDate;
        private Integer licenseQuantity;
        private String licenseType;
        private EksAnywhereSubscriptionTerm term;
        private String status;
        private Boolean autoRenew;
        private List<String> licenseArns = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EksAnywhereSubscription model) {
            this.id(model.id);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.effectiveDate(model.effectiveDate);
            this.expirationDate(model.expirationDate);
            this.licenseQuantity(model.licenseQuantity);
            this.licenseType(model.licenseType);
            this.term(model.term);
            this.status(model.status);
            this.autoRenew(model.autoRenew);
            this.licenseArns(model.licenseArns);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getEffectiveDate() {
            return this.effectiveDate;
        }

        public final void setEffectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        @Override
        public final Builder effectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final Integer getLicenseQuantity() {
            return this.licenseQuantity;
        }

        public final void setLicenseQuantity(Integer licenseQuantity) {
            this.licenseQuantity = licenseQuantity;
        }

        @Override
        public final Builder licenseQuantity(Integer licenseQuantity) {
            this.licenseQuantity = licenseQuantity;
            return this;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(EksAnywhereSubscriptionLicenseType licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final EksAnywhereSubscriptionTerm.Builder getTerm() {
            return this.term != null ? this.term.toBuilder() : null;
        }

        public final void setTerm(EksAnywhereSubscriptionTerm.BuilderImpl term) {
            this.term = term != null ? term.build() : null;
        }

        @Override
        public final Builder term(EksAnywhereSubscriptionTerm term) {
            this.term = term;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Boolean getAutoRenew() {
            return this.autoRenew;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final Collection<String> getLicenseArns() {
            if (this.licenseArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.licenseArns;
        }

        public final void setLicenseArns(Collection<String> licenseArns) {
            this.licenseArns = StringListCopier.copy(licenseArns);
        }

        @Override
        public final Builder licenseArns(Collection<String> licenseArns) {
            this.licenseArns = StringListCopier.copy(licenseArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseArns(String ... licenseArns) {
            this.licenseArns(Arrays.asList(licenseArns));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public EksAnywhereSubscription build() {
            return new EksAnywhereSubscription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EksAnywhereSubscription> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder effectiveDate(Instant var1);

        public Builder expirationDate(Instant var1);

        public Builder licenseQuantity(Integer var1);

        public Builder licenseType(String var1);

        public Builder licenseType(EksAnywhereSubscriptionLicenseType var1);

        public Builder term(EksAnywhereSubscriptionTerm var1);

        default public Builder term(Consumer<EksAnywhereSubscriptionTerm.Builder> term) {
            return this.term((EksAnywhereSubscriptionTerm)((EksAnywhereSubscriptionTerm.Builder)EksAnywhereSubscriptionTerm.builder().applyMutation(term)).build());
        }

        public Builder status(String var1);

        public Builder autoRenew(Boolean var1);

        public Builder licenseArns(Collection<String> var1);

        public Builder licenseArns(String ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

