/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.RemoteNodeNetwork;
import software.amazon.awssdk.services.eks.model.RemoteNodeNetworkListCopier;
import software.amazon.awssdk.services.eks.model.RemotePodNetwork;
import software.amazon.awssdk.services.eks.model.RemotePodNetworkListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoteNetworkConfigResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RemoteNetworkConfigResponse> {
    private static final SdkField<List<RemoteNodeNetwork>> REMOTE_NODE_NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("remoteNodeNetworks").getter(RemoteNetworkConfigResponse.getter(RemoteNetworkConfigResponse::remoteNodeNetworks)).setter(RemoteNetworkConfigResponse.setter(Builder::remoteNodeNetworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteNodeNetworks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemoteNodeNetwork::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RemotePodNetwork>> REMOTE_POD_NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("remotePodNetworks").getter(RemoteNetworkConfigResponse.getter(RemoteNetworkConfigResponse::remotePodNetworks)).setter(RemoteNetworkConfigResponse.setter(Builder::remotePodNetworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remotePodNetworks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemotePodNetwork::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOTE_NODE_NETWORKS_FIELD, REMOTE_POD_NETWORKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RemoteNetworkConfigResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<RemoteNodeNetwork> remoteNodeNetworks;
    private final List<RemotePodNetwork> remotePodNetworks;

    private RemoteNetworkConfigResponse(BuilderImpl builder) {
        this.remoteNodeNetworks = builder.remoteNodeNetworks;
        this.remotePodNetworks = builder.remotePodNetworks;
    }

    public final boolean hasRemoteNodeNetworks() {
        return this.remoteNodeNetworks != null && !(this.remoteNodeNetworks instanceof SdkAutoConstructList);
    }

    public final List<RemoteNodeNetwork> remoteNodeNetworks() {
        return this.remoteNodeNetworks;
    }

    public final boolean hasRemotePodNetworks() {
        return this.remotePodNetworks != null && !(this.remotePodNetworks instanceof SdkAutoConstructList);
    }

    public final List<RemotePodNetwork> remotePodNetworks() {
        return this.remotePodNetworks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoteNodeNetworks() ? this.remoteNodeNetworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemotePodNetworks() ? this.remotePodNetworks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteNetworkConfigResponse)) {
            return false;
        }
        RemoteNetworkConfigResponse other = (RemoteNetworkConfigResponse)obj;
        return this.hasRemoteNodeNetworks() == other.hasRemoteNodeNetworks() && Objects.equals(this.remoteNodeNetworks(), other.remoteNodeNetworks()) && this.hasRemotePodNetworks() == other.hasRemotePodNetworks() && Objects.equals(this.remotePodNetworks(), other.remotePodNetworks());
    }

    public final String toString() {
        return ToString.builder((String)"RemoteNetworkConfigResponse").add("RemoteNodeNetworks", this.hasRemoteNodeNetworks() ? this.remoteNodeNetworks() : null).add("RemotePodNetworks", this.hasRemotePodNetworks() ? this.remotePodNetworks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "remoteNodeNetworks": {
                return Optional.ofNullable(clazz.cast(this.remoteNodeNetworks()));
            }
            case "remotePodNetworks": {
                return Optional.ofNullable(clazz.cast(this.remotePodNetworks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("remoteNodeNetworks", REMOTE_NODE_NETWORKS_FIELD);
        map.put("remotePodNetworks", REMOTE_POD_NETWORKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoteNetworkConfigResponse, T> g) {
        return obj -> g.apply((RemoteNetworkConfigResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RemoteNodeNetwork> remoteNodeNetworks = DefaultSdkAutoConstructList.getInstance();
        private List<RemotePodNetwork> remotePodNetworks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteNetworkConfigResponse model) {
            this.remoteNodeNetworks(model.remoteNodeNetworks);
            this.remotePodNetworks(model.remotePodNetworks);
        }

        public final List<RemoteNodeNetwork.Builder> getRemoteNodeNetworks() {
            List<RemoteNodeNetwork.Builder> result = RemoteNodeNetworkListCopier.copyToBuilder(this.remoteNodeNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoteNodeNetworks(Collection<RemoteNodeNetwork.BuilderImpl> remoteNodeNetworks) {
            this.remoteNodeNetworks = RemoteNodeNetworkListCopier.copyFromBuilder(remoteNodeNetworks);
        }

        @Override
        public final Builder remoteNodeNetworks(Collection<RemoteNodeNetwork> remoteNodeNetworks) {
            this.remoteNodeNetworks = RemoteNodeNetworkListCopier.copy(remoteNodeNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteNodeNetworks(RemoteNodeNetwork ... remoteNodeNetworks) {
            this.remoteNodeNetworks(Arrays.asList(remoteNodeNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteNodeNetworks(Consumer<RemoteNodeNetwork.Builder> ... remoteNodeNetworks) {
            this.remoteNodeNetworks(Stream.of(remoteNodeNetworks).map(c -> (RemoteNodeNetwork)((RemoteNodeNetwork.Builder)RemoteNodeNetwork.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RemotePodNetwork.Builder> getRemotePodNetworks() {
            List<RemotePodNetwork.Builder> result = RemotePodNetworkListCopier.copyToBuilder(this.remotePodNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemotePodNetworks(Collection<RemotePodNetwork.BuilderImpl> remotePodNetworks) {
            this.remotePodNetworks = RemotePodNetworkListCopier.copyFromBuilder(remotePodNetworks);
        }

        @Override
        public final Builder remotePodNetworks(Collection<RemotePodNetwork> remotePodNetworks) {
            this.remotePodNetworks = RemotePodNetworkListCopier.copy(remotePodNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remotePodNetworks(RemotePodNetwork ... remotePodNetworks) {
            this.remotePodNetworks(Arrays.asList(remotePodNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remotePodNetworks(Consumer<RemotePodNetwork.Builder> ... remotePodNetworks) {
            this.remotePodNetworks(Stream.of(remotePodNetworks).map(c -> (RemotePodNetwork)((RemotePodNetwork.Builder)RemotePodNetwork.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RemoteNetworkConfigResponse build() {
            return new RemoteNetworkConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RemoteNetworkConfigResponse> {
        public Builder remoteNodeNetworks(Collection<RemoteNodeNetwork> var1);

        public Builder remoteNodeNetworks(RemoteNodeNetwork ... var1);

        public Builder remoteNodeNetworks(Consumer<RemoteNodeNetwork.Builder> ... var1);

        public Builder remotePodNetworks(Collection<RemotePodNetwork> var1);

        public Builder remotePodNetworks(RemotePodNetwork ... var1);

        public Builder remotePodNetworks(Consumer<RemotePodNetwork.Builder> ... var1);
    }
}

