/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.EksResponse;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessEntriesResponse
extends EksResponse
implements ToCopyableBuilder<Builder, ListAccessEntriesResponse> {
    private static final SdkField<List<String>> ACCESS_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accessEntries").getter(ListAccessEntriesResponse.getter(ListAccessEntriesResponse::accessEntries)).setter(ListAccessEntriesResponse.setter(Builder::accessEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAccessEntriesResponse.getter(ListAccessEntriesResponse::nextToken)).setter(ListAccessEntriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_ENTRIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAccessEntriesResponse.memberNameToFieldInitializer();
    private final List<String> accessEntries;
    private final String nextToken;

    private ListAccessEntriesResponse(BuilderImpl builder) {
        super(builder);
        this.accessEntries = builder.accessEntries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccessEntries() {
        return this.accessEntries != null && !(this.accessEntries instanceof SdkAutoConstructList);
    }

    public final List<String> accessEntries() {
        return this.accessEntries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessEntries() ? this.accessEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessEntriesResponse)) {
            return false;
        }
        ListAccessEntriesResponse other = (ListAccessEntriesResponse)((Object)obj);
        return this.hasAccessEntries() == other.hasAccessEntries() && Objects.equals(this.accessEntries(), other.accessEntries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccessEntriesResponse").add("AccessEntries", this.hasAccessEntries() ? this.accessEntries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessEntries": {
                return Optional.ofNullable(clazz.cast(this.accessEntries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accessEntries", ACCESS_ENTRIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccessEntriesResponse, T> g) {
        return obj -> g.apply((ListAccessEntriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksResponse.BuilderImpl
    implements Builder {
        private List<String> accessEntries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessEntriesResponse model) {
            super(model);
            this.accessEntries(model.accessEntries);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAccessEntries() {
            if (this.accessEntries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accessEntries;
        }

        public final void setAccessEntries(Collection<String> accessEntries) {
            this.accessEntries = StringListCopier.copy(accessEntries);
        }

        @Override
        public final Builder accessEntries(Collection<String> accessEntries) {
            this.accessEntries = StringListCopier.copy(accessEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEntries(String ... accessEntries) {
            this.accessEntries(Arrays.asList(accessEntries));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAccessEntriesResponse build() {
            return new ListAccessEntriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessEntriesResponse> {
        public Builder accessEntries(Collection<String> var1);

        public Builder accessEntries(String ... var1);

        public Builder nextToken(String var1);
    }
}

