/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodegroupIssueCode {
    AUTO_SCALING_GROUP_NOT_FOUND("AutoScalingGroupNotFound"),
    AUTO_SCALING_GROUP_INVALID_CONFIGURATION("AutoScalingGroupInvalidConfiguration"),
    EC2_SECURITY_GROUP_NOT_FOUND("Ec2SecurityGroupNotFound"),
    EC2_SECURITY_GROUP_DELETION_FAILURE("Ec2SecurityGroupDeletionFailure"),
    EC2_LAUNCH_TEMPLATE_NOT_FOUND("Ec2LaunchTemplateNotFound"),
    EC2_LAUNCH_TEMPLATE_VERSION_MISMATCH("Ec2LaunchTemplateVersionMismatch"),
    EC2_SUBNET_NOT_FOUND("Ec2SubnetNotFound"),
    EC2_SUBNET_INVALID_CONFIGURATION("Ec2SubnetInvalidConfiguration"),
    IAM_INSTANCE_PROFILE_NOT_FOUND("IamInstanceProfileNotFound"),
    EC2_SUBNET_MISSING_IPV6_ASSIGNMENT("Ec2SubnetMissingIpv6Assignment"),
    IAM_LIMIT_EXCEEDED("IamLimitExceeded"),
    IAM_NODE_ROLE_NOT_FOUND("IamNodeRoleNotFound"),
    NODE_CREATION_FAILURE("NodeCreationFailure"),
    ASG_INSTANCE_LAUNCH_FAILURES("AsgInstanceLaunchFailures"),
    INSTANCE_LIMIT_EXCEEDED("InstanceLimitExceeded"),
    INSUFFICIENT_FREE_ADDRESSES("InsufficientFreeAddresses"),
    ACCESS_DENIED("AccessDenied"),
    INTERNAL_FAILURE("InternalFailure"),
    CLUSTER_UNREACHABLE("ClusterUnreachable"),
    AMI_ID_NOT_FOUND("AmiIdNotFound"),
    AUTO_SCALING_GROUP_OPT_IN_REQUIRED("AutoScalingGroupOptInRequired"),
    AUTO_SCALING_GROUP_RATE_LIMIT_EXCEEDED("AutoScalingGroupRateLimitExceeded"),
    EC2_LAUNCH_TEMPLATE_DELETION_FAILURE("Ec2LaunchTemplateDeletionFailure"),
    EC2_LAUNCH_TEMPLATE_INVALID_CONFIGURATION("Ec2LaunchTemplateInvalidConfiguration"),
    EC2_LAUNCH_TEMPLATE_MAX_LIMIT_EXCEEDED("Ec2LaunchTemplateMaxLimitExceeded"),
    EC2_SUBNET_LIST_TOO_LONG("Ec2SubnetListTooLong"),
    IAM_THROTTLING("IamThrottling"),
    NODE_TERMINATION_FAILURE("NodeTerminationFailure"),
    POD_EVICTION_FAILURE("PodEvictionFailure"),
    SOURCE_EC2_LAUNCH_TEMPLATE_NOT_FOUND("SourceEc2LaunchTemplateNotFound"),
    LIMIT_EXCEEDED("LimitExceeded"),
    UNKNOWN("Unknown"),
    AUTO_SCALING_GROUP_INSTANCE_REFRESH_ACTIVE("AutoScalingGroupInstanceRefreshActive"),
    KUBERNETES_LABEL_INVALID("KubernetesLabelInvalid"),
    EC2_LAUNCH_TEMPLATE_VERSION_MAX_LIMIT_EXCEEDED("Ec2LaunchTemplateVersionMaxLimitExceeded"),
    EC2_INSTANCE_TYPE_DOES_NOT_EXIST("Ec2InstanceTypeDoesNotExist"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodegroupIssueCode> VALUE_MAP;
    private final String value;

    private NodegroupIssueCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodegroupIssueCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodegroupIssueCode> knownValues() {
        EnumSet<NodegroupIssueCode> knownValues = EnumSet.allOf(NodegroupIssueCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodegroupIssueCode.class, NodegroupIssueCode::toString);
    }
}

