/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.AddonVersionInfo;
import software.amazon.awssdk.services.eks.model.AddonVersionInfoListCopier;
import software.amazon.awssdk.services.eks.model.MarketplaceInformation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddonInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddonInfo> {
    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addonName").getter(AddonInfo.getter(AddonInfo::addonName)).setter(AddonInfo.setter(Builder::addonName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AddonInfo.getter(AddonInfo::type)).setter(AddonInfo.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<AddonVersionInfo>> ADDON_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("addonVersions").getter(AddonInfo.getter(AddonInfo::addonVersions)).setter(AddonInfo.setter(Builder::addonVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddonVersionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PUBLISHER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("publisher").getter(AddonInfo.getter(AddonInfo::publisher)).setter(AddonInfo.setter(Builder::publisher)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publisher").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(AddonInfo.getter(AddonInfo::owner)).setter(AddonInfo.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<MarketplaceInformation> MARKETPLACE_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("marketplaceInformation").getter(AddonInfo.getter(AddonInfo::marketplaceInformation)).setter(AddonInfo.setter(Builder::marketplaceInformation)).constructor(MarketplaceInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marketplaceInformation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_NAME_FIELD, TYPE_FIELD, ADDON_VERSIONS_FIELD, PUBLISHER_FIELD, OWNER_FIELD, MARKETPLACE_INFORMATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddonInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String addonName;
    private final String type;
    private final List<AddonVersionInfo> addonVersions;
    private final String publisher;
    private final String owner;
    private final MarketplaceInformation marketplaceInformation;

    private AddonInfo(BuilderImpl builder) {
        this.addonName = builder.addonName;
        this.type = builder.type;
        this.addonVersions = builder.addonVersions;
        this.publisher = builder.publisher;
        this.owner = builder.owner;
        this.marketplaceInformation = builder.marketplaceInformation;
    }

    public final String addonName() {
        return this.addonName;
    }

    public final String type() {
        return this.type;
    }

    public final boolean hasAddonVersions() {
        return this.addonVersions != null && !(this.addonVersions instanceof SdkAutoConstructList);
    }

    public final List<AddonVersionInfo> addonVersions() {
        return this.addonVersions;
    }

    public final String publisher() {
        return this.publisher;
    }

    public final String owner() {
        return this.owner;
    }

    public final MarketplaceInformation marketplaceInformation() {
        return this.marketplaceInformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addonName());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddonVersions() ? this.addonVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publisher());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.marketplaceInformation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonInfo)) {
            return false;
        }
        AddonInfo other = (AddonInfo)obj;
        return Objects.equals(this.addonName(), other.addonName()) && Objects.equals(this.type(), other.type()) && this.hasAddonVersions() == other.hasAddonVersions() && Objects.equals(this.addonVersions(), other.addonVersions()) && Objects.equals(this.publisher(), other.publisher()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.marketplaceInformation(), other.marketplaceInformation());
    }

    public final String toString() {
        return ToString.builder((String)"AddonInfo").add("AddonName", (Object)this.addonName()).add("Type", (Object)this.type()).add("AddonVersions", this.hasAddonVersions() ? this.addonVersions() : null).add("Publisher", (Object)this.publisher()).add("Owner", (Object)this.owner()).add("MarketplaceInformation", (Object)this.marketplaceInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "addonName": {
                return Optional.ofNullable(clazz.cast(this.addonName()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "addonVersions": {
                return Optional.ofNullable(clazz.cast(this.addonVersions()));
            }
            case "publisher": {
                return Optional.ofNullable(clazz.cast(this.publisher()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "marketplaceInformation": {
                return Optional.ofNullable(clazz.cast(this.marketplaceInformation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("addonName", ADDON_NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("addonVersions", ADDON_VERSIONS_FIELD);
        map.put("publisher", PUBLISHER_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("marketplaceInformation", MARKETPLACE_INFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddonInfo, T> g) {
        return obj -> g.apply((AddonInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String addonName;
        private String type;
        private List<AddonVersionInfo> addonVersions = DefaultSdkAutoConstructList.getInstance();
        private String publisher;
        private String owner;
        private MarketplaceInformation marketplaceInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(AddonInfo model) {
            this.addonName(model.addonName);
            this.type(model.type);
            this.addonVersions(model.addonVersions);
            this.publisher(model.publisher);
            this.owner(model.owner);
            this.marketplaceInformation(model.marketplaceInformation);
        }

        public final String getAddonName() {
            return this.addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final List<AddonVersionInfo.Builder> getAddonVersions() {
            List<AddonVersionInfo.Builder> result = AddonVersionInfoListCopier.copyToBuilder(this.addonVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddonVersions(Collection<AddonVersionInfo.BuilderImpl> addonVersions) {
            this.addonVersions = AddonVersionInfoListCopier.copyFromBuilder(addonVersions);
        }

        @Override
        public final Builder addonVersions(Collection<AddonVersionInfo> addonVersions) {
            this.addonVersions = AddonVersionInfoListCopier.copy(addonVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addonVersions(AddonVersionInfo ... addonVersions) {
            this.addonVersions(Arrays.asList(addonVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addonVersions(Consumer<AddonVersionInfo.Builder> ... addonVersions) {
            this.addonVersions(Stream.of(addonVersions).map(c -> (AddonVersionInfo)((AddonVersionInfo.Builder)AddonVersionInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPublisher() {
            return this.publisher;
        }

        public final void setPublisher(String publisher) {
            this.publisher = publisher;
        }

        @Override
        public final Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final MarketplaceInformation.Builder getMarketplaceInformation() {
            return this.marketplaceInformation != null ? this.marketplaceInformation.toBuilder() : null;
        }

        public final void setMarketplaceInformation(MarketplaceInformation.BuilderImpl marketplaceInformation) {
            this.marketplaceInformation = marketplaceInformation != null ? marketplaceInformation.build() : null;
        }

        @Override
        public final Builder marketplaceInformation(MarketplaceInformation marketplaceInformation) {
            this.marketplaceInformation = marketplaceInformation;
            return this;
        }

        public AddonInfo build() {
            return new AddonInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddonInfo> {
        public Builder addonName(String var1);

        public Builder type(String var1);

        public Builder addonVersions(Collection<AddonVersionInfo> var1);

        public Builder addonVersions(AddonVersionInfo ... var1);

        public Builder addonVersions(Consumer<AddonVersionInfo.Builder> ... var1);

        public Builder publisher(String var1);

        public Builder owner(String var1);

        public Builder marketplaceInformation(MarketplaceInformation var1);

        default public Builder marketplaceInformation(Consumer<MarketplaceInformation.Builder> marketplaceInformation) {
            return this.marketplaceInformation((MarketplaceInformation)((MarketplaceInformation.Builder)MarketplaceInformation.builder().applyMutation(marketplaceInformation)).build());
        }
    }
}

