/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the scaling configuration details for the Auto Scaling group that is associated with your node
 * group. When creating a node group, you must specify all or none of the properties. When updating a node group, you
 * can specify any or none of the properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodegroupScalingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<NodegroupScalingConfig.Builder, NodegroupScalingConfig> {
    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minSize").getter(getter(NodegroupScalingConfig::minSize)).setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minSize").build()).build();

    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxSize").getter(getter(NodegroupScalingConfig::maxSize)).setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSize").build()).build();

    private static final SdkField<Integer> DESIRED_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("desiredSize").getter(getter(NodegroupScalingConfig::desiredSize)).setter(setter(Builder::desiredSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_SIZE_FIELD,
            MAX_SIZE_FIELD, DESIRED_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer minSize;

    private final Integer maxSize;

    private final Integer desiredSize;

    private NodegroupScalingConfig(BuilderImpl builder) {
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredSize = builder.desiredSize;
    }

    /**
     * <p>
     * The minimum number of nodes that the managed node group can scale in to.
     * </p>
     * 
     * @return The minimum number of nodes that the managed node group can scale in to.
     */
    public final Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum number of nodes that the managed node group can scale out to. For information about the maximum
     * number that you can specify, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html">Amazon EKS service quotas</a> in the
     * <i>Amazon EKS User Guide</i>.
     * </p>
     * 
     * @return The maximum number of nodes that the managed node group can scale out to. For information about the
     *         maximum number that you can specify, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html">Amazon EKS service quotas</a>
     *         in the <i>Amazon EKS User Guide</i>.
     */
    public final Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The current number of nodes that the managed node group should maintain.
     * </p>
     * <important>
     * <p>
     * If you use the Kubernetes <a href="https://github.com/kubernetes/autoscaler#kubernetes-autoscaler">Cluster
     * Autoscaler</a>, you shouldn't change the <code>desiredSize</code> value directly, as this can cause the Cluster
     * Autoscaler to suddenly scale up or scale down.
     * </p>
     * </important>
     * <p>
     * Whenever this parameter changes, the number of worker nodes in the node group is updated to the specified size.
     * If this parameter is given a value that is smaller than the current number of running worker nodes, the necessary
     * number of worker nodes are terminated to match the given value. When using CloudFormation, no action occurs if
     * you remove this parameter from your CFN template.
     * </p>
     * <p>
     * This parameter can be different from <code>minSize</code> in some cases, such as when starting with extra hosts
     * for testing. This parameter can also be different when you want to start with an estimated number of needed
     * hosts, but let the Cluster Autoscaler reduce the number if there are too many. When the Cluster Autoscaler is
     * used, the <code>desiredSize</code> parameter is altered by the Cluster Autoscaler (but can be out-of-date for
     * short periods of time). the Cluster Autoscaler doesn't scale a managed node group lower than <code>minSize</code>
     * or higher than <code>maxSize</code>.
     * </p>
     * 
     * @return The current number of nodes that the managed node group should maintain.</p> <important>
     *         <p>
     *         If you use the Kubernetes <a
     *         href="https://github.com/kubernetes/autoscaler#kubernetes-autoscaler">Cluster Autoscaler</a>, you
     *         shouldn't change the <code>desiredSize</code> value directly, as this can cause the Cluster Autoscaler to
     *         suddenly scale up or scale down.
     *         </p>
     *         </important>
     *         <p>
     *         Whenever this parameter changes, the number of worker nodes in the node group is updated to the specified
     *         size. If this parameter is given a value that is smaller than the current number of running worker nodes,
     *         the necessary number of worker nodes are terminated to match the given value. When using CloudFormation,
     *         no action occurs if you remove this parameter from your CFN template.
     *         </p>
     *         <p>
     *         This parameter can be different from <code>minSize</code> in some cases, such as when starting with extra
     *         hosts for testing. This parameter can also be different when you want to start with an estimated number
     *         of needed hosts, but let the Cluster Autoscaler reduce the number if there are too many. When the Cluster
     *         Autoscaler is used, the <code>desiredSize</code> parameter is altered by the Cluster Autoscaler (but can
     *         be out-of-date for short periods of time). the Cluster Autoscaler doesn't scale a managed node group
     *         lower than <code>minSize</code> or higher than <code>maxSize</code>.
     */
    public final Integer desiredSize() {
        return desiredSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(desiredSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodegroupScalingConfig)) {
            return false;
        }
        NodegroupScalingConfig other = (NodegroupScalingConfig) obj;
        return Objects.equals(minSize(), other.minSize()) && Objects.equals(maxSize(), other.maxSize())
                && Objects.equals(desiredSize(), other.desiredSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodegroupScalingConfig").add("MinSize", minSize()).add("MaxSize", maxSize())
                .add("DesiredSize", desiredSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "minSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "maxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        case "desiredSize":
            return Optional.ofNullable(clazz.cast(desiredSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("minSize", MIN_SIZE_FIELD);
        map.put("maxSize", MAX_SIZE_FIELD);
        map.put("desiredSize", DESIRED_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodegroupScalingConfig, T> g) {
        return obj -> g.apply((NodegroupScalingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodegroupScalingConfig> {
        /**
         * <p>
         * The minimum number of nodes that the managed node group can scale in to.
         * </p>
         * 
         * @param minSize
         *        The minimum number of nodes that the managed node group can scale in to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum number of nodes that the managed node group can scale out to. For information about the maximum
         * number that you can specify, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html">Amazon EKS service quotas</a> in
         * the <i>Amazon EKS User Guide</i>.
         * </p>
         * 
         * @param maxSize
         *        The maximum number of nodes that the managed node group can scale out to. For information about the
         *        maximum number that you can specify, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html">Amazon EKS service
         *        quotas</a> in the <i>Amazon EKS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The current number of nodes that the managed node group should maintain.
         * </p>
         * <important>
         * <p>
         * If you use the Kubernetes <a href="https://github.com/kubernetes/autoscaler#kubernetes-autoscaler">Cluster
         * Autoscaler</a>, you shouldn't change the <code>desiredSize</code> value directly, as this can cause the
         * Cluster Autoscaler to suddenly scale up or scale down.
         * </p>
         * </important>
         * <p>
         * Whenever this parameter changes, the number of worker nodes in the node group is updated to the specified
         * size. If this parameter is given a value that is smaller than the current number of running worker nodes, the
         * necessary number of worker nodes are terminated to match the given value. When using CloudFormation, no
         * action occurs if you remove this parameter from your CFN template.
         * </p>
         * <p>
         * This parameter can be different from <code>minSize</code> in some cases, such as when starting with extra
         * hosts for testing. This parameter can also be different when you want to start with an estimated number of
         * needed hosts, but let the Cluster Autoscaler reduce the number if there are too many. When the Cluster
         * Autoscaler is used, the <code>desiredSize</code> parameter is altered by the Cluster Autoscaler (but can be
         * out-of-date for short periods of time). the Cluster Autoscaler doesn't scale a managed node group lower than
         * <code>minSize</code> or higher than <code>maxSize</code>.
         * </p>
         * 
         * @param desiredSize
         *        The current number of nodes that the managed node group should maintain.</p> <important>
         *        <p>
         *        If you use the Kubernetes <a
         *        href="https://github.com/kubernetes/autoscaler#kubernetes-autoscaler">Cluster Autoscaler</a>, you
         *        shouldn't change the <code>desiredSize</code> value directly, as this can cause the Cluster Autoscaler
         *        to suddenly scale up or scale down.
         *        </p>
         *        </important>
         *        <p>
         *        Whenever this parameter changes, the number of worker nodes in the node group is updated to the
         *        specified size. If this parameter is given a value that is smaller than the current number of running
         *        worker nodes, the necessary number of worker nodes are terminated to match the given value. When using
         *        CloudFormation, no action occurs if you remove this parameter from your CFN template.
         *        </p>
         *        <p>
         *        This parameter can be different from <code>minSize</code> in some cases, such as when starting with
         *        extra hosts for testing. This parameter can also be different when you want to start with an estimated
         *        number of needed hosts, but let the Cluster Autoscaler reduce the number if there are too many. When
         *        the Cluster Autoscaler is used, the <code>desiredSize</code> parameter is altered by the Cluster
         *        Autoscaler (but can be out-of-date for short periods of time). the Cluster Autoscaler doesn't scale a
         *        managed node group lower than <code>minSize</code> or higher than <code>maxSize</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredSize(Integer desiredSize);
    }

    static final class BuilderImpl implements Builder {
        private Integer minSize;

        private Integer maxSize;

        private Integer desiredSize;

        private BuilderImpl() {
        }

        private BuilderImpl(NodegroupScalingConfig model) {
            minSize(model.minSize);
            maxSize(model.maxSize);
            desiredSize(model.desiredSize);
        }

        public final Integer getMinSize() {
            return minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final Integer getDesiredSize() {
            return desiredSize;
        }

        public final void setDesiredSize(Integer desiredSize) {
            this.desiredSize = desiredSize;
        }

        @Override
        public final Builder desiredSize(Integer desiredSize) {
            this.desiredSize = desiredSize;
            return this;
        }

        @Override
        public NodegroupScalingConfig build() {
            return new NodegroupScalingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
