/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an add-on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddonInfo implements SdkPojo, Serializable, ToCopyableBuilder<AddonInfo.Builder, AddonInfo> {
    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addonName").getter(getter(AddonInfo::addonName)).setter(setter(Builder::addonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AddonInfo::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<AddonVersionInfo>> ADDON_VERSIONS_FIELD = SdkField
            .<List<AddonVersionInfo>> builder(MarshallingType.LIST)
            .memberName("addonVersions")
            .getter(getter(AddonInfo::addonVersions))
            .setter(setter(Builder::addonVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddonVersionInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddonVersionInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PUBLISHER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("publisher").getter(getter(AddonInfo::publisher)).setter(setter(Builder::publisher))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publisher").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(AddonInfo::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<MarketplaceInformation> MARKETPLACE_INFORMATION_FIELD = SdkField
            .<MarketplaceInformation> builder(MarshallingType.SDK_POJO).memberName("marketplaceInformation")
            .getter(getter(AddonInfo::marketplaceInformation)).setter(setter(Builder::marketplaceInformation))
            .constructor(MarketplaceInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marketplaceInformation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_NAME_FIELD, TYPE_FIELD,
            ADDON_VERSIONS_FIELD, PUBLISHER_FIELD, OWNER_FIELD, MARKETPLACE_INFORMATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String addonName;

    private final String type;

    private final List<AddonVersionInfo> addonVersions;

    private final String publisher;

    private final String owner;

    private final MarketplaceInformation marketplaceInformation;

    private AddonInfo(BuilderImpl builder) {
        this.addonName = builder.addonName;
        this.type = builder.type;
        this.addonVersions = builder.addonVersions;
        this.publisher = builder.publisher;
        this.owner = builder.owner;
        this.marketplaceInformation = builder.marketplaceInformation;
    }

    /**
     * <p>
     * The name of the add-on.
     * </p>
     * 
     * @return The name of the add-on.
     */
    public final String addonName() {
        return addonName;
    }

    /**
     * <p>
     * The type of the add-on.
     * </p>
     * 
     * @return The type of the add-on.
     */
    public final String type() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddonVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddonVersions() {
        return addonVersions != null && !(addonVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object representing information about available add-on versions and compatible Kubernetes versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddonVersions} method.
     * </p>
     * 
     * @return An object representing information about available add-on versions and compatible Kubernetes versions.
     */
    public final List<AddonVersionInfo> addonVersions() {
        return addonVersions;
    }

    /**
     * <p>
     * The publisher of the add-on.
     * </p>
     * 
     * @return The publisher of the add-on.
     */
    public final String publisher() {
        return publisher;
    }

    /**
     * <p>
     * The owner of the add-on.
     * </p>
     * 
     * @return The owner of the add-on.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * Information about the add-on from the Amazon Web Services Marketplace.
     * </p>
     * 
     * @return Information about the add-on from the Amazon Web Services Marketplace.
     */
    public final MarketplaceInformation marketplaceInformation() {
        return marketplaceInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addonName());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddonVersions() ? addonVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(publisher());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(marketplaceInformation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonInfo)) {
            return false;
        }
        AddonInfo other = (AddonInfo) obj;
        return Objects.equals(addonName(), other.addonName()) && Objects.equals(type(), other.type())
                && hasAddonVersions() == other.hasAddonVersions() && Objects.equals(addonVersions(), other.addonVersions())
                && Objects.equals(publisher(), other.publisher()) && Objects.equals(owner(), other.owner())
                && Objects.equals(marketplaceInformation(), other.marketplaceInformation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddonInfo").add("AddonName", addonName()).add("Type", type())
                .add("AddonVersions", hasAddonVersions() ? addonVersions() : null).add("Publisher", publisher())
                .add("Owner", owner()).add("MarketplaceInformation", marketplaceInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addonName":
            return Optional.ofNullable(clazz.cast(addonName()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "addonVersions":
            return Optional.ofNullable(clazz.cast(addonVersions()));
        case "publisher":
            return Optional.ofNullable(clazz.cast(publisher()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "marketplaceInformation":
            return Optional.ofNullable(clazz.cast(marketplaceInformation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("addonName", ADDON_NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("addonVersions", ADDON_VERSIONS_FIELD);
        map.put("publisher", PUBLISHER_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("marketplaceInformation", MARKETPLACE_INFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddonInfo, T> g) {
        return obj -> g.apply((AddonInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddonInfo> {
        /**
         * <p>
         * The name of the add-on.
         * </p>
         * 
         * @param addonName
         *        The name of the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonName(String addonName);

        /**
         * <p>
         * The type of the add-on.
         * </p>
         * 
         * @param type
         *        The type of the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * An object representing information about available add-on versions and compatible Kubernetes versions.
         * </p>
         * 
         * @param addonVersions
         *        An object representing information about available add-on versions and compatible Kubernetes versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonVersions(Collection<AddonVersionInfo> addonVersions);

        /**
         * <p>
         * An object representing information about available add-on versions and compatible Kubernetes versions.
         * </p>
         * 
         * @param addonVersions
         *        An object representing information about available add-on versions and compatible Kubernetes versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonVersions(AddonVersionInfo... addonVersions);

        /**
         * <p>
         * An object representing information about available add-on versions and compatible Kubernetes versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.AddonVersionInfo.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.eks.model.AddonVersionInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.AddonVersionInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #addonVersions(List<AddonVersionInfo>)}.
         * 
         * @param addonVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.AddonVersionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addonVersions(java.util.Collection<AddonVersionInfo>)
         */
        Builder addonVersions(Consumer<AddonVersionInfo.Builder>... addonVersions);

        /**
         * <p>
         * The publisher of the add-on.
         * </p>
         * 
         * @param publisher
         *        The publisher of the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publisher(String publisher);

        /**
         * <p>
         * The owner of the add-on.
         * </p>
         * 
         * @param owner
         *        The owner of the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * Information about the add-on from the Amazon Web Services Marketplace.
         * </p>
         * 
         * @param marketplaceInformation
         *        Information about the add-on from the Amazon Web Services Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketplaceInformation(MarketplaceInformation marketplaceInformation);

        /**
         * <p>
         * Information about the add-on from the Amazon Web Services Marketplace.
         * </p>
         * This is a convenience method that creates an instance of the {@link MarketplaceInformation.Builder} avoiding
         * the need to create one manually via {@link MarketplaceInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MarketplaceInformation.Builder#build()} is called immediately and
         * its result is passed to {@link #marketplaceInformation(MarketplaceInformation)}.
         * 
         * @param marketplaceInformation
         *        a consumer that will call methods on {@link MarketplaceInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #marketplaceInformation(MarketplaceInformation)
         */
        default Builder marketplaceInformation(Consumer<MarketplaceInformation.Builder> marketplaceInformation) {
            return marketplaceInformation(MarketplaceInformation.builder().applyMutation(marketplaceInformation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String addonName;

        private String type;

        private List<AddonVersionInfo> addonVersions = DefaultSdkAutoConstructList.getInstance();

        private String publisher;

        private String owner;

        private MarketplaceInformation marketplaceInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(AddonInfo model) {
            addonName(model.addonName);
            type(model.type);
            addonVersions(model.addonVersions);
            publisher(model.publisher);
            owner(model.owner);
            marketplaceInformation(model.marketplaceInformation);
        }

        public final String getAddonName() {
            return addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final List<AddonVersionInfo.Builder> getAddonVersions() {
            List<AddonVersionInfo.Builder> result = AddonVersionInfoListCopier.copyToBuilder(this.addonVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddonVersions(Collection<AddonVersionInfo.BuilderImpl> addonVersions) {
            this.addonVersions = AddonVersionInfoListCopier.copyFromBuilder(addonVersions);
        }

        @Override
        public final Builder addonVersions(Collection<AddonVersionInfo> addonVersions) {
            this.addonVersions = AddonVersionInfoListCopier.copy(addonVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addonVersions(AddonVersionInfo... addonVersions) {
            addonVersions(Arrays.asList(addonVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addonVersions(Consumer<AddonVersionInfo.Builder>... addonVersions) {
            addonVersions(Stream.of(addonVersions).map(c -> AddonVersionInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPublisher() {
            return publisher;
        }

        public final void setPublisher(String publisher) {
            this.publisher = publisher;
        }

        @Override
        public final Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final MarketplaceInformation.Builder getMarketplaceInformation() {
            return marketplaceInformation != null ? marketplaceInformation.toBuilder() : null;
        }

        public final void setMarketplaceInformation(MarketplaceInformation.BuilderImpl marketplaceInformation) {
            this.marketplaceInformation = marketplaceInformation != null ? marketplaceInformation.build() : null;
        }

        @Override
        public final Builder marketplaceInformation(MarketplaceInformation marketplaceInformation) {
            this.marketplaceInformation = marketplaceInformation;
            return this;
        }

        @Override
        public AddonInfo build() {
            return new AddonInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
