/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInsightsRequest extends EksRequest implements
        ToCopyableBuilder<ListInsightsRequest.Builder, ListInsightsRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(ListInsightsRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<InsightsFilter> FILTER_FIELD = SdkField.<InsightsFilter> builder(MarshallingType.SDK_POJO)
            .memberName("filter").getter(getter(ListInsightsRequest::filter)).setter(setter(Builder::filter))
            .constructor(InsightsFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListInsightsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListInsightsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterName;

    private final InsightsFilter filter;

    private final Integer maxResults;

    private final String nextToken;

    private ListInsightsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the Amazon EKS cluster associated with the insights.
     * </p>
     * 
     * @return The name of the Amazon EKS cluster associated with the insights.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The criteria to filter your list of insights for your cluster. You can filter which insights are returned by
     * category, associated Kubernetes version, and status.
     * </p>
     * 
     * @return The criteria to filter your list of insights for your cluster. You can filter which insights are returned
     *         by category, associated Kubernetes version, and status.
     */
    public final InsightsFilter filter() {
        return filter;
    }

    /**
     * <p>
     * The maximum number of identity provider configurations returned by <code>ListInsights</code> in paginated output.
     * When you use this parameter, <code>ListInsights</code> returns only <code>maxResults</code> results in a single
     * page along with a <code>nextToken</code> response element. You can see the remaining results of the initial
     * request by sending another <code>ListInsights</code> request with the returned <code>nextToken</code> value. This
     * value can be between 1 and 100. If you don't use this parameter, <code>ListInsights</code> returns up to 100
     * results and a <code>nextToken</code> value, if applicable.
     * </p>
     * 
     * @return The maximum number of identity provider configurations returned by <code>ListInsights</code> in paginated
     *         output. When you use this parameter, <code>ListInsights</code> returns only <code>maxResults</code>
     *         results in a single page along with a <code>nextToken</code> response element. You can see the remaining
     *         results of the initial request by sending another <code>ListInsights</code> request with the returned
     *         <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter,
     *         <code>ListInsights</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListInsights</code> request. When the
     * results of a <code>ListInsights</code> request exceed <code>maxResults</code>, you can use this value to retrieve
     * the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>ListInsights</code> request.
     *         When the results of a <code>ListInsights</code> request exceed <code>maxResults</code>, you can use this
     *         value to retrieve the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInsightsRequest)) {
            return false;
        }
        ListInsightsRequest other = (ListInsightsRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(filter(), other.filter())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInsightsRequest").add("ClusterName", clusterName()).add("Filter", filter())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", CLUSTER_NAME_FIELD);
        map.put("filter", FILTER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInsightsRequest, T> g) {
        return obj -> g.apply((ListInsightsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListInsightsRequest> {
        /**
         * <p>
         * The name of the Amazon EKS cluster associated with the insights.
         * </p>
         * 
         * @param clusterName
         *        The name of the Amazon EKS cluster associated with the insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The criteria to filter your list of insights for your cluster. You can filter which insights are returned by
         * category, associated Kubernetes version, and status.
         * </p>
         * 
         * @param filter
         *        The criteria to filter your list of insights for your cluster. You can filter which insights are
         *        returned by category, associated Kubernetes version, and status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(InsightsFilter filter);

        /**
         * <p>
         * The criteria to filter your list of insights for your cluster. You can filter which insights are returned by
         * category, associated Kubernetes version, and status.
         * </p>
         * This is a convenience method that creates an instance of the {@link InsightsFilter.Builder} avoiding the need
         * to create one manually via {@link InsightsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InsightsFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(InsightsFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link InsightsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(InsightsFilter)
         */
        default Builder filter(Consumer<InsightsFilter.Builder> filter) {
            return filter(InsightsFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The maximum number of identity provider configurations returned by <code>ListInsights</code> in paginated
         * output. When you use this parameter, <code>ListInsights</code> returns only <code>maxResults</code> results
         * in a single page along with a <code>nextToken</code> response element. You can see the remaining results of
         * the initial request by sending another <code>ListInsights</code> request with the returned
         * <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter,
         * <code>ListInsights</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of identity provider configurations returned by <code>ListInsights</code> in
         *        paginated output. When you use this parameter, <code>ListInsights</code> returns only
         *        <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
         *        You can see the remaining results of the initial request by sending another <code>ListInsights</code>
         *        request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you
         *        don't use this parameter, <code>ListInsights</code> returns up to 100 results and a
         *        <code>nextToken</code> value, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListInsights</code> request. When
         * the results of a <code>ListInsights</code> request exceed <code>maxResults</code>, you can use this value to
         * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>ListInsights</code> request.
         *        When the results of a <code>ListInsights</code> request exceed <code>maxResults</code>, you can use
         *        this value to retrieve the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterName;

        private InsightsFilter filter;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInsightsRequest model) {
            super(model);
            clusterName(model.clusterName);
            filter(model.filter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final InsightsFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(InsightsFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(InsightsFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInsightsRequest build() {
            return new ListInsightsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
