/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The full description of your connected cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorConfigResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorConfigResponse.Builder, ConnectorConfigResponse> {
    private static final SdkField<String> ACTIVATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activationId").getter(getter(ConnectorConfigResponse::activationId))
            .setter(setter(Builder::activationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activationId").build()).build();

    private static final SdkField<String> ACTIVATION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activationCode").getter(getter(ConnectorConfigResponse::activationCode))
            .setter(setter(Builder::activationCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activationCode").build()).build();

    private static final SdkField<Instant> ACTIVATION_EXPIRY_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("activationExpiry").getter(getter(ConnectorConfigResponse::activationExpiry))
            .setter(setter(Builder::activationExpiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activationExpiry").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(ConnectorConfigResponse::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(ConnectorConfigResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_ID_FIELD,
            ACTIVATION_CODE_FIELD, ACTIVATION_EXPIRY_FIELD, PROVIDER_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String activationId;

    private final String activationCode;

    private final Instant activationExpiry;

    private final String provider;

    private final String roleArn;

    private ConnectorConfigResponse(BuilderImpl builder) {
        this.activationId = builder.activationId;
        this.activationCode = builder.activationCode;
        this.activationExpiry = builder.activationExpiry;
        this.provider = builder.provider;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * A unique ID associated with the cluster for registration purposes.
     * </p>
     * 
     * @return A unique ID associated with the cluster for registration purposes.
     */
    public final String activationId() {
        return activationId;
    }

    /**
     * <p>
     * A unique code associated with the cluster for registration purposes.
     * </p>
     * 
     * @return A unique code associated with the cluster for registration purposes.
     */
    public final String activationCode() {
        return activationCode;
    }

    /**
     * <p>
     * The expiration time of the connected cluster. The cluster's YAML file must be applied through the native
     * provider.
     * </p>
     * 
     * @return The expiration time of the connected cluster. The cluster's YAML file must be applied through the native
     *         provider.
     */
    public final Instant activationExpiry() {
        return activationExpiry;
    }

    /**
     * <p>
     * The cluster's cloud service provider.
     * </p>
     * 
     * @return The cluster's cloud service provider.
     */
    public final String provider() {
        return provider;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role to communicate with services from the connected Kubernetes cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role to communicate with services from the connected Kubernetes
     *         cluster.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activationId());
        hashCode = 31 * hashCode + Objects.hashCode(activationCode());
        hashCode = 31 * hashCode + Objects.hashCode(activationExpiry());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorConfigResponse)) {
            return false;
        }
        ConnectorConfigResponse other = (ConnectorConfigResponse) obj;
        return Objects.equals(activationId(), other.activationId()) && Objects.equals(activationCode(), other.activationCode())
                && Objects.equals(activationExpiry(), other.activationExpiry()) && Objects.equals(provider(), other.provider())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorConfigResponse").add("ActivationId", activationId())
                .add("ActivationCode", activationCode()).add("ActivationExpiry", activationExpiry()).add("Provider", provider())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activationId":
            return Optional.ofNullable(clazz.cast(activationId()));
        case "activationCode":
            return Optional.ofNullable(clazz.cast(activationCode()));
        case "activationExpiry":
            return Optional.ofNullable(clazz.cast(activationExpiry()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("activationId", ACTIVATION_ID_FIELD);
        map.put("activationCode", ACTIVATION_CODE_FIELD);
        map.put("activationExpiry", ACTIVATION_EXPIRY_FIELD);
        map.put("provider", PROVIDER_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorConfigResponse, T> g) {
        return obj -> g.apply((ConnectorConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorConfigResponse> {
        /**
         * <p>
         * A unique ID associated with the cluster for registration purposes.
         * </p>
         * 
         * @param activationId
         *        A unique ID associated with the cluster for registration purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationId(String activationId);

        /**
         * <p>
         * A unique code associated with the cluster for registration purposes.
         * </p>
         * 
         * @param activationCode
         *        A unique code associated with the cluster for registration purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationCode(String activationCode);

        /**
         * <p>
         * The expiration time of the connected cluster. The cluster's YAML file must be applied through the native
         * provider.
         * </p>
         * 
         * @param activationExpiry
         *        The expiration time of the connected cluster. The cluster's YAML file must be applied through the
         *        native provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationExpiry(Instant activationExpiry);

        /**
         * <p>
         * The cluster's cloud service provider.
         * </p>
         * 
         * @param provider
         *        The cluster's cloud service provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role to communicate with services from the connected Kubernetes
         * cluster.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role to communicate with services from the connected Kubernetes
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String activationId;

        private String activationCode;

        private Instant activationExpiry;

        private String provider;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorConfigResponse model) {
            activationId(model.activationId);
            activationCode(model.activationCode);
            activationExpiry(model.activationExpiry);
            provider(model.provider);
            roleArn(model.roleArn);
        }

        public final String getActivationId() {
            return activationId;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        @Override
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final String getActivationCode() {
            return activationCode;
        }

        public final void setActivationCode(String activationCode) {
            this.activationCode = activationCode;
        }

        @Override
        public final Builder activationCode(String activationCode) {
            this.activationCode = activationCode;
            return this;
        }

        public final Instant getActivationExpiry() {
            return activationExpiry;
        }

        public final void setActivationExpiry(Instant activationExpiry) {
            this.activationExpiry = activationExpiry;
        }

        @Override
        public final Builder activationExpiry(Instant activationExpiry) {
            this.activationExpiry = activationExpiry;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public ConnectorConfigResponse build() {
            return new ConnectorConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
