/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration sent to a cluster for configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorConfigRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorConfigRequest.Builder, ConnectorConfigRequest> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(ConnectorConfigRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(ConnectorConfigRequest::providerAsString)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ROLE_ARN_FIELD, PROVIDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String provider;

    private ConnectorConfigRequest(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.provider = builder.provider;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role that is authorized to request the connector configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role that is authorized to request the connector configuration.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The cloud provider for the target cluster to connect.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link ConnectorConfigProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #providerAsString}.
     * </p>
     * 
     * @return The cloud provider for the target cluster to connect.
     * @see ConnectorConfigProvider
     */
    public final ConnectorConfigProvider provider() {
        return ConnectorConfigProvider.fromValue(provider);
    }

    /**
     * <p>
     * The cloud provider for the target cluster to connect.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link ConnectorConfigProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #providerAsString}.
     * </p>
     * 
     * @return The cloud provider for the target cluster to connect.
     * @see ConnectorConfigProvider
     */
    public final String providerAsString() {
        return provider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(providerAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorConfigRequest)) {
            return false;
        }
        ConnectorConfigRequest other = (ConnectorConfigRequest) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(providerAsString(), other.providerAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorConfigRequest").add("RoleArn", roleArn()).add("Provider", providerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "provider":
            return Optional.ofNullable(clazz.cast(providerAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("provider", PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorConfigRequest, T> g) {
        return obj -> g.apply((ConnectorConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorConfigRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role that is authorized to request the connector configuration.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role that is authorized to request the connector configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The cloud provider for the target cluster to connect.
         * </p>
         * 
         * @param provider
         *        The cloud provider for the target cluster to connect.
         * @see ConnectorConfigProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorConfigProvider
         */
        Builder provider(String provider);

        /**
         * <p>
         * The cloud provider for the target cluster to connect.
         * </p>
         * 
         * @param provider
         *        The cloud provider for the target cluster to connect.
         * @see ConnectorConfigProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorConfigProvider
         */
        Builder provider(ConnectorConfigProvider provider);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String provider;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorConfigRequest model) {
            roleArn(model.roleArn);
            provider(model.provider);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(ConnectorConfigProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        @Override
        public ConnectorConfigRequest build() {
            return new ConnectorConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
