/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateEncryptionConfigRequest extends EksRequest implements
        ToCopyableBuilder<AssociateEncryptionConfigRequest.Builder, AssociateEncryptionConfigRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(AssociateEncryptionConfigRequest::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<List<EncryptionConfig>> ENCRYPTION_CONFIG_FIELD = SdkField
            .<List<EncryptionConfig>> builder(MarshallingType.LIST)
            .memberName("encryptionConfig")
            .getter(getter(AssociateEncryptionConfigRequest::encryptionConfig))
            .setter(setter(Builder::encryptionConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EncryptionConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(EncryptionConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(AssociateEncryptionConfigRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            ENCRYPTION_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterName;

    private final List<EncryptionConfig> encryptionConfig;

    private final String clientRequestToken;

    private AssociateEncryptionConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.encryptionConfig = builder.encryptionConfig;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of your cluster.
     * </p>
     * 
     * @return The name of your cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the EncryptionConfig property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEncryptionConfig() {
        return encryptionConfig != null && !(encryptionConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration you are using for encryption.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEncryptionConfig} method.
     * </p>
     * 
     * @return The configuration you are using for encryption.
     */
    public final List<EncryptionConfig> encryptionConfig() {
        return encryptionConfig;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(hasEncryptionConfig() ? encryptionConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateEncryptionConfigRequest)) {
            return false;
        }
        AssociateEncryptionConfigRequest other = (AssociateEncryptionConfigRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && hasEncryptionConfig() == other.hasEncryptionConfig()
                && Objects.equals(encryptionConfig(), other.encryptionConfig())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateEncryptionConfigRequest").add("ClusterName", clusterName())
                .add("EncryptionConfig", hasEncryptionConfig() ? encryptionConfig() : null)
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "encryptionConfig":
            return Optional.ofNullable(clazz.cast(encryptionConfig()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", CLUSTER_NAME_FIELD);
        map.put("encryptionConfig", ENCRYPTION_CONFIG_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateEncryptionConfigRequest, T> g) {
        return obj -> g.apply((AssociateEncryptionConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateEncryptionConfigRequest> {
        /**
         * <p>
         * The name of your cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The configuration you are using for encryption.
         * </p>
         * 
         * @param encryptionConfig
         *        The configuration you are using for encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfig(Collection<EncryptionConfig> encryptionConfig);

        /**
         * <p>
         * The configuration you are using for encryption.
         * </p>
         * 
         * @param encryptionConfig
         *        The configuration you are using for encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfig(EncryptionConfig... encryptionConfig);

        /**
         * <p>
         * The configuration you are using for encryption.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.EncryptionConfig.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.eks.model.EncryptionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.EncryptionConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #encryptionConfig(List<EncryptionConfig>)}.
         * 
         * @param encryptionConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.EncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfig(java.util.Collection<EncryptionConfig>)
         */
        Builder encryptionConfig(Consumer<EncryptionConfig.Builder>... encryptionConfig);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterName;

        private List<EncryptionConfig> encryptionConfig = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateEncryptionConfigRequest model) {
            super(model);
            clusterName(model.clusterName);
            encryptionConfig(model.encryptionConfig);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final List<EncryptionConfig.Builder> getEncryptionConfig() {
            List<EncryptionConfig.Builder> result = EncryptionConfigListCopier.copyToBuilder(this.encryptionConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEncryptionConfig(Collection<EncryptionConfig.BuilderImpl> encryptionConfig) {
            this.encryptionConfig = EncryptionConfigListCopier.copyFromBuilder(encryptionConfig);
        }

        @Override
        public final Builder encryptionConfig(Collection<EncryptionConfig> encryptionConfig) {
            this.encryptionConfig = EncryptionConfigListCopier.copy(encryptionConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encryptionConfig(EncryptionConfig... encryptionConfig) {
            encryptionConfig(Arrays.asList(encryptionConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encryptionConfig(Consumer<EncryptionConfig.Builder>... encryptionConfig) {
            encryptionConfig(Stream.of(encryptionConfig).map(c -> EncryptionConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateEncryptionConfigRequest build() {
            return new AssociateEncryptionConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
