/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A property that allows a node to repel a <code>Pod</code>. For more information, see <a
 * href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node taints on managed
 * node groups</a> in the <i>Amazon EKS User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Taint implements SdkPojo, Serializable, ToCopyableBuilder<Taint.Builder, Taint> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(Taint::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(Taint::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> EFFECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("effect")
            .getter(getter(Taint::effectAsString)).setter(setter(Builder::effect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effect").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD,
            EFFECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("key", KEY_FIELD);
                    put("value", VALUE_FIELD);
                    put("effect", EFFECT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private final String effect;

    private Taint(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.effect = builder.effect;
    }

    /**
     * <p>
     * The key of the taint.
     * </p>
     * 
     * @return The key of the taint.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The value of the taint.
     * </p>
     * 
     * @return The value of the taint.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The effect of the taint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link TaintEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #effectAsString}.
     * </p>
     * 
     * @return The effect of the taint.
     * @see TaintEffect
     */
    public final TaintEffect effect() {
        return TaintEffect.fromValue(effect);
    }

    /**
     * <p>
     * The effect of the taint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link TaintEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #effectAsString}.
     * </p>
     * 
     * @return The effect of the taint.
     * @see TaintEffect
     */
    public final String effectAsString() {
        return effect;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(effectAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Taint)) {
            return false;
        }
        Taint other = (Taint) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value())
                && Objects.equals(effectAsString(), other.effectAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Taint").add("Key", key()).add("Value", value()).add("Effect", effectAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "effect":
            return Optional.ofNullable(clazz.cast(effectAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Taint, T> g) {
        return obj -> g.apply((Taint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Taint> {
        /**
         * <p>
         * The key of the taint.
         * </p>
         * 
         * @param key
         *        The key of the taint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value of the taint.
         * </p>
         * 
         * @param value
         *        The value of the taint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The effect of the taint.
         * </p>
         * 
         * @param effect
         *        The effect of the taint.
         * @see TaintEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaintEffect
         */
        Builder effect(String effect);

        /**
         * <p>
         * The effect of the taint.
         * </p>
         * 
         * @param effect
         *        The effect of the taint.
         * @see TaintEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaintEffect
         */
        Builder effect(TaintEffect effect);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private String effect;

        private BuilderImpl() {
        }

        private BuilderImpl(Taint model) {
            key(model.key);
            value(model.value);
            effect(model.effect);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getEffect() {
            return effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(TaintEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        @Override
        public Taint build() {
            return new Taint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
