/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an error when an asynchronous operation fails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorDetail implements SdkPojo, Serializable, ToCopyableBuilder<ErrorDetail.Builder, ErrorDetail> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(ErrorDetail::errorCodeAsString)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(ErrorDetail::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<List<String>> RESOURCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceIds")
            .getter(getter(ErrorDetail::resourceIds))
            .setter(setter(Builder::resourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_MESSAGE_FIELD, RESOURCE_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("errorCode", ERROR_CODE_FIELD);
                    put("errorMessage", ERROR_MESSAGE_FIELD);
                    put("resourceIds", RESOURCE_IDS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String errorMessage;

    private final List<String> resourceIds;

    private ErrorDetail(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.resourceIds = builder.resourceIds;
    }

    /**
     * <p>
     * A brief description of the error.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SubnetNotFound</b>: We couldn't find one of the subnets associated with the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SecurityGroupNotFound</b>: We couldn't find one of the security groups associated with the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EniLimitReached</b>: You have reached the elastic network interface limit for your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>IpNotAvailable</b>: A subnet associated with the cluster doesn't have any available IP addresses.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AccessDenied</b>: You don't have permissions to perform the specified operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OperationNotPermitted</b>: The service role associated with the cluster doesn't have the required access
     * permissions for Amazon EKS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>VpcIdNotFound</b>: We couldn't find the VPC associated with the cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return A brief description of the error. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>SubnetNotFound</b>: We couldn't find one of the subnets associated with the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SecurityGroupNotFound</b>: We couldn't find one of the security groups associated with the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EniLimitReached</b>: You have reached the elastic network interface limit for your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>IpNotAvailable</b>: A subnet associated with the cluster doesn't have any available IP addresses.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AccessDenied</b>: You don't have permissions to perform the specified operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>OperationNotPermitted</b>: The service role associated with the cluster doesn't have the required
     *         access permissions for Amazon EKS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>VpcIdNotFound</b>: We couldn't find the VPC associated with the cluster.
     *         </p>
     *         </li>
     * @see ErrorCode
     */
    public final ErrorCode errorCode() {
        return ErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * A brief description of the error.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SubnetNotFound</b>: We couldn't find one of the subnets associated with the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SecurityGroupNotFound</b>: We couldn't find one of the security groups associated with the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EniLimitReached</b>: You have reached the elastic network interface limit for your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>IpNotAvailable</b>: A subnet associated with the cluster doesn't have any available IP addresses.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AccessDenied</b>: You don't have permissions to perform the specified operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OperationNotPermitted</b>: The service role associated with the cluster doesn't have the required access
     * permissions for Amazon EKS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>VpcIdNotFound</b>: We couldn't find the VPC associated with the cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return A brief description of the error. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>SubnetNotFound</b>: We couldn't find one of the subnets associated with the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SecurityGroupNotFound</b>: We couldn't find one of the security groups associated with the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EniLimitReached</b>: You have reached the elastic network interface limit for your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>IpNotAvailable</b>: A subnet associated with the cluster doesn't have any available IP addresses.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AccessDenied</b>: You don't have permissions to perform the specified operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>OperationNotPermitted</b>: The service role associated with the cluster doesn't have the required
     *         access permissions for Amazon EKS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>VpcIdNotFound</b>: We couldn't find the VPC associated with the cluster.
     *         </p>
     *         </li>
     * @see ErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * A more complete description of the error.
     * </p>
     * 
     * @return A more complete description of the error.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceIds() {
        return resourceIds != null && !(resourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional field that contains the resource IDs associated with the error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceIds} method.
     * </p>
     * 
     * @return An optional field that contains the resource IDs associated with the error.
     */
    public final List<String> resourceIds() {
        return resourceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceIds() ? resourceIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorDetail)) {
            return false;
        }
        ErrorDetail other = (ErrorDetail) obj;
        return Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorMessage(), other.errorMessage()) && hasResourceIds() == other.hasResourceIds()
                && Objects.equals(resourceIds(), other.resourceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ErrorDetail").add("ErrorCode", errorCodeAsString()).add("ErrorMessage", errorMessage())
                .add("ResourceIds", hasResourceIds() ? resourceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "resourceIds":
            return Optional.ofNullable(clazz.cast(resourceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ErrorDetail, T> g) {
        return obj -> g.apply((ErrorDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorDetail> {
        /**
         * <p>
         * A brief description of the error.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>SubnetNotFound</b>: We couldn't find one of the subnets associated with the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SecurityGroupNotFound</b>: We couldn't find one of the security groups associated with the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EniLimitReached</b>: You have reached the elastic network interface limit for your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>IpNotAvailable</b>: A subnet associated with the cluster doesn't have any available IP addresses.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AccessDenied</b>: You don't have permissions to perform the specified operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>OperationNotPermitted</b>: The service role associated with the cluster doesn't have the required access
         * permissions for Amazon EKS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VpcIdNotFound</b>: We couldn't find the VPC associated with the cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param errorCode
         *        A brief description of the error. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>SubnetNotFound</b>: We couldn't find one of the subnets associated with the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SecurityGroupNotFound</b>: We couldn't find one of the security groups associated with the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EniLimitReached</b>: You have reached the elastic network interface limit for your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>IpNotAvailable</b>: A subnet associated with the cluster doesn't have any available IP addresses.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AccessDenied</b>: You don't have permissions to perform the specified operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>OperationNotPermitted</b>: The service role associated with the cluster doesn't have the required
         *        access permissions for Amazon EKS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VpcIdNotFound</b>: We couldn't find the VPC associated with the cluster.
         *        </p>
         *        </li>
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * A brief description of the error.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>SubnetNotFound</b>: We couldn't find one of the subnets associated with the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SecurityGroupNotFound</b>: We couldn't find one of the security groups associated with the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EniLimitReached</b>: You have reached the elastic network interface limit for your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>IpNotAvailable</b>: A subnet associated with the cluster doesn't have any available IP addresses.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AccessDenied</b>: You don't have permissions to perform the specified operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>OperationNotPermitted</b>: The service role associated with the cluster doesn't have the required access
         * permissions for Amazon EKS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VpcIdNotFound</b>: We couldn't find the VPC associated with the cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param errorCode
         *        A brief description of the error. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>SubnetNotFound</b>: We couldn't find one of the subnets associated with the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SecurityGroupNotFound</b>: We couldn't find one of the security groups associated with the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EniLimitReached</b>: You have reached the elastic network interface limit for your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>IpNotAvailable</b>: A subnet associated with the cluster doesn't have any available IP addresses.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AccessDenied</b>: You don't have permissions to perform the specified operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>OperationNotPermitted</b>: The service role associated with the cluster doesn't have the required
         *        access permissions for Amazon EKS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VpcIdNotFound</b>: We couldn't find the VPC associated with the cluster.
         *        </p>
         *        </li>
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder errorCode(ErrorCode errorCode);

        /**
         * <p>
         * A more complete description of the error.
         * </p>
         * 
         * @param errorMessage
         *        A more complete description of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * An optional field that contains the resource IDs associated with the error.
         * </p>
         * 
         * @param resourceIds
         *        An optional field that contains the resource IDs associated with the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(Collection<String> resourceIds);

        /**
         * <p>
         * An optional field that contains the resource IDs associated with the error.
         * </p>
         * 
         * @param resourceIds
         *        An optional field that contains the resource IDs associated with the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(String... resourceIds);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private String errorMessage;

        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorDetail model) {
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            resourceIds(model.resourceIds);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Collection<String> getResourceIds() {
            if (resourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceIds;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = StringListCopier.copy(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = StringListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String... resourceIds) {
            resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        @Override
        public ErrorDetail build() {
            return new ErrorDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
