/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFargateProfileRequest extends EksRequest implements
        ToCopyableBuilder<DescribeFargateProfileRequest.Builder, DescribeFargateProfileRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(DescribeFargateProfileRequest::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> FARGATE_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fargateProfileName").getter(getter(DescribeFargateProfileRequest::fargateProfileName))
            .setter(setter(Builder::fargateProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("fargateProfileName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            FARGATE_PROFILE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("name", CLUSTER_NAME_FIELD);
                    put("fargateProfileName", FARGATE_PROFILE_NAME_FIELD);
                }
            });

    private final String clusterName;

    private final String fargateProfileName;

    private DescribeFargateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.fargateProfileName = builder.fargateProfileName;
    }

    /**
     * <p>
     * The name of your cluster.
     * </p>
     * 
     * @return The name of your cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The name of the Fargate profile to describe.
     * </p>
     * 
     * @return The name of the Fargate profile to describe.
     */
    public final String fargateProfileName() {
        return fargateProfileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(fargateProfileName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFargateProfileRequest)) {
            return false;
        }
        DescribeFargateProfileRequest other = (DescribeFargateProfileRequest) obj;
        return Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(fargateProfileName(), other.fargateProfileName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFargateProfileRequest").add("ClusterName", clusterName())
                .add("FargateProfileName", fargateProfileName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "fargateProfileName":
            return Optional.ofNullable(clazz.cast(fargateProfileName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFargateProfileRequest, T> g) {
        return obj -> g.apply((DescribeFargateProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFargateProfileRequest> {
        /**
         * <p>
         * The name of your cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The name of the Fargate profile to describe.
         * </p>
         * 
         * @param fargateProfileName
         *        The name of the Fargate profile to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fargateProfileName(String fargateProfileName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String fargateProfileName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFargateProfileRequest model) {
            super(model);
            clusterName(model.clusterName);
            fargateProfileName(model.fargateProfileName);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getFargateProfileName() {
            return fargateProfileName;
        }

        public final void setFargateProfileName(String fargateProfileName) {
            this.fargateProfileName = fargateProfileName;
        }

        @Override
        public final Builder fargateProfileName(String fargateProfileName) {
            this.fargateProfileName = fargateProfileName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFargateProfileRequest build() {
            return new DescribeFargateProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
