/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEksAnywhereSubscriptionResponse extends EksResponse implements
        ToCopyableBuilder<DescribeEksAnywhereSubscriptionResponse.Builder, DescribeEksAnywhereSubscriptionResponse> {
    private static final SdkField<EksAnywhereSubscription> SUBSCRIPTION_FIELD = SdkField
            .<EksAnywhereSubscription> builder(MarshallingType.SDK_POJO).memberName("subscription")
            .getter(getter(DescribeEksAnywhereSubscriptionResponse::subscription)).setter(setter(Builder::subscription))
            .constructor(EksAnywhereSubscription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("subscription", SUBSCRIPTION_FIELD);
                }
            });

    private final EksAnywhereSubscription subscription;

    private DescribeEksAnywhereSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.subscription = builder.subscription;
    }

    /**
     * <p>
     * The full description of the subscription.
     * </p>
     * 
     * @return The full description of the subscription.
     */
    public final EksAnywhereSubscription subscription() {
        return subscription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEksAnywhereSubscriptionResponse)) {
            return false;
        }
        DescribeEksAnywhereSubscriptionResponse other = (DescribeEksAnywhereSubscriptionResponse) obj;
        return Objects.equals(subscription(), other.subscription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEksAnywhereSubscriptionResponse").add("Subscription", subscription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subscription":
            return Optional.ofNullable(clazz.cast(subscription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEksAnywhereSubscriptionResponse, T> g) {
        return obj -> g.apply((DescribeEksAnywhereSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEksAnywhereSubscriptionResponse> {
        /**
         * <p>
         * The full description of the subscription.
         * </p>
         * 
         * @param subscription
         *        The full description of the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscription(EksAnywhereSubscription subscription);

        /**
         * <p>
         * The full description of the subscription.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksAnywhereSubscription.Builder} avoiding
         * the need to create one manually via {@link EksAnywhereSubscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksAnywhereSubscription.Builder#build()} is called immediately
         * and its result is passed to {@link #subscription(EksAnywhereSubscription)}.
         * 
         * @param subscription
         *        a consumer that will call methods on {@link EksAnywhereSubscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscription(EksAnywhereSubscription)
         */
        default Builder subscription(Consumer<EksAnywhereSubscription.Builder> subscription) {
            return subscription(EksAnywhereSubscription.builder().applyMutation(subscription).build());
        }
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private EksAnywhereSubscription subscription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEksAnywhereSubscriptionResponse model) {
            super(model);
            subscription(model.subscription);
        }

        public final EksAnywhereSubscription.Builder getSubscription() {
            return subscription != null ? subscription.toBuilder() : null;
        }

        public final void setSubscription(EksAnywhereSubscription.BuilderImpl subscription) {
            this.subscription = subscription != null ? subscription.build() : null;
        }

        @Override
        public final Builder subscription(EksAnywhereSubscription subscription) {
            this.subscription = subscription;
            return this;
        }

        @Override
        public DescribeEksAnywhereSubscriptionResponse build() {
            return new DescribeEksAnywhereSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
