/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePodIdentityAssociationResponse extends EksResponse implements
        ToCopyableBuilder<DeletePodIdentityAssociationResponse.Builder, DeletePodIdentityAssociationResponse> {
    private static final SdkField<PodIdentityAssociation> ASSOCIATION_FIELD = SdkField
            .<PodIdentityAssociation> builder(MarshallingType.SDK_POJO).memberName("association")
            .getter(getter(DeletePodIdentityAssociationResponse::association)).setter(setter(Builder::association))
            .constructor(PodIdentityAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("association").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("association", ASSOCIATION_FIELD);
                }
            });

    private final PodIdentityAssociation association;

    private DeletePodIdentityAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.association = builder.association;
    }

    /**
     * <p>
     * The full description of the EKS Pod Identity association that was deleted.
     * </p>
     * 
     * @return The full description of the EKS Pod Identity association that was deleted.
     */
    public final PodIdentityAssociation association() {
        return association;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(association());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePodIdentityAssociationResponse)) {
            return false;
        }
        DeletePodIdentityAssociationResponse other = (DeletePodIdentityAssociationResponse) obj;
        return Objects.equals(association(), other.association());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletePodIdentityAssociationResponse").add("Association", association()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "association":
            return Optional.ofNullable(clazz.cast(association()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeletePodIdentityAssociationResponse, T> g) {
        return obj -> g.apply((DeletePodIdentityAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeletePodIdentityAssociationResponse> {
        /**
         * <p>
         * The full description of the EKS Pod Identity association that was deleted.
         * </p>
         * 
         * @param association
         *        The full description of the EKS Pod Identity association that was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder association(PodIdentityAssociation association);

        /**
         * <p>
         * The full description of the EKS Pod Identity association that was deleted.
         * </p>
         * This is a convenience method that creates an instance of the {@link PodIdentityAssociation.Builder} avoiding
         * the need to create one manually via {@link PodIdentityAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PodIdentityAssociation.Builder#build()} is called immediately and
         * its result is passed to {@link #association(PodIdentityAssociation)}.
         * 
         * @param association
         *        a consumer that will call methods on {@link PodIdentityAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #association(PodIdentityAssociation)
         */
        default Builder association(Consumer<PodIdentityAssociation.Builder> association) {
            return association(PodIdentityAssociation.builder().applyMutation(association).build());
        }
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private PodIdentityAssociation association;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePodIdentityAssociationResponse model) {
            super(model);
            association(model.association);
        }

        public final PodIdentityAssociation.Builder getAssociation() {
            return association != null ? association.toBuilder() : null;
        }

        public final void setAssociation(PodIdentityAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        @Override
        public final Builder association(PodIdentityAssociation association) {
            this.association = association;
            return this;
        }

        @Override
        public DeletePodIdentityAssociationResponse build() {
            return new DeletePodIdentityAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
