/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AddonStatus {
    CREATING("CREATING"),
    ACTIVE("ACTIVE"),
    CREATE_FAILED("CREATE_FAILED"),
    UPDATING("UPDATING"),
    DELETING("DELETING"),
    DELETE_FAILED("DELETE_FAILED"),
    DEGRADED("DEGRADED"),
    UPDATE_FAILED("UPDATE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AddonStatus> VALUE_MAP;
    private final String value;

    private AddonStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AddonStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AddonStatus> knownValues() {
        EnumSet<AddonStatus> knownValues = EnumSet.allOf(AddonStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AddonStatus.class, AddonStatus::toString);
    }
}

