/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An access entry allows an IAM principal (user or role) to access your cluster. Access entries can replace the need to
 * maintain the <code>aws-auth</code> <code>ConfigMap</code> for authentication. For more information about access
 * entries, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html">Access entries</a> in the
 * <i>Amazon EKS User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessEntry implements SdkPojo, Serializable, ToCopyableBuilder<AccessEntry.Builder, AccessEntry> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(AccessEntry::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalArn").getter(getter(AccessEntry::principalArn)).setter(setter(Builder::principalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()).build();

    private static final SdkField<List<String>> KUBERNETES_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("kubernetesGroups")
            .getter(getter(AccessEntry::kubernetesGroups))
            .setter(setter(Builder::kubernetesGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ACCESS_ENTRY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessEntryArn").getter(getter(AccessEntry::accessEntryArn)).setter(setter(Builder::accessEntryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessEntryArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(AccessEntry::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt").getter(getter(AccessEntry::modifiedAt)).setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(AccessEntry::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("username").getter(getter(AccessEntry::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AccessEntry::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            PRINCIPAL_ARN_FIELD, KUBERNETES_GROUPS_FIELD, ACCESS_ENTRY_ARN_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD,
            TAGS_FIELD, USERNAME_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clusterName;

    private final String principalArn;

    private final List<String> kubernetesGroups;

    private final String accessEntryArn;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final Map<String, String> tags;

    private final String username;

    private final String type;

    private AccessEntry(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.principalArn = builder.principalArn;
        this.kubernetesGroups = builder.kubernetesGroups;
        this.accessEntryArn = builder.accessEntryArn;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.tags = builder.tags;
        this.username = builder.username;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of your cluster.
     * </p>
     * 
     * @return The name of your cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The ARN of the IAM principal for the access entry. If you ever delete the IAM principal with this ARN, the access
     * entry isn't automatically deleted. We recommend that you delete the access entry with an ARN for an IAM principal
     * that you delete. If you don't delete the access entry and ever recreate the IAM principal, even if it has the
     * same ARN, the access entry won't work. This is because even though the ARN is the same for the recreated IAM
     * principal, the <code>roleID</code> or <code>userID</code> (you can see this with the Security Token Service
     * <code>GetCallerIdentity</code> API) is different for the recreated IAM principal than it was for the original IAM
     * principal. Even though you don't see the IAM principal's <code>roleID</code> or <code>userID</code> for an access
     * entry, Amazon EKS stores it with the access entry.
     * </p>
     * 
     * @return The ARN of the IAM principal for the access entry. If you ever delete the IAM principal with this ARN,
     *         the access entry isn't automatically deleted. We recommend that you delete the access entry with an ARN
     *         for an IAM principal that you delete. If you don't delete the access entry and ever recreate the IAM
     *         principal, even if it has the same ARN, the access entry won't work. This is because even though the ARN
     *         is the same for the recreated IAM principal, the <code>roleID</code> or <code>userID</code> (you can see
     *         this with the Security Token Service <code>GetCallerIdentity</code> API) is different for the recreated
     *         IAM principal than it was for the original IAM principal. Even though you don't see the IAM principal's
     *         <code>roleID</code> or <code>userID</code> for an access entry, Amazon EKS stores it with the access
     *         entry.
     */
    public final String principalArn() {
        return principalArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the KubernetesGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKubernetesGroups() {
        return kubernetesGroups != null && !(kubernetesGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A <code>name</code> that you've specified in a Kubernetes <code>RoleBinding</code> or
     * <code>ClusterRoleBinding</code> object so that Kubernetes authorizes the <code>principalARN</code> access to
     * cluster objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKubernetesGroups} method.
     * </p>
     * 
     * @return A <code>name</code> that you've specified in a Kubernetes <code>RoleBinding</code> or
     *         <code>ClusterRoleBinding</code> object so that Kubernetes authorizes the <code>principalARN</code> access
     *         to cluster objects.
     */
    public final List<String> kubernetesGroups() {
        return kubernetesGroups;
    }

    /**
     * <p>
     * The ARN of the access entry.
     * </p>
     * 
     * @return The ARN of the access entry.
     */
    public final String accessEntryArn() {
        return accessEntryArn;
    }

    /**
     * <p>
     * The Unix epoch timestamp at object creation.
     * </p>
     * 
     * @return The Unix epoch timestamp at object creation.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix epoch timestamp for the last modification to the object.
     * </p>
     * 
     * @return The Unix epoch timestamp for the last modification to the object.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You
     * define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata that assists with categorization and organization. Each tag consists of a key and an optional
     *         value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The <code>name</code> of a user that can authenticate to your cluster.
     * </p>
     * 
     * @return The <code>name</code> of a user that can authenticate to your cluster.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The type of the access entry.
     * </p>
     * 
     * @return The type of the access entry.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasKubernetesGroups() ? kubernetesGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accessEntryArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessEntry)) {
            return false;
        }
        AccessEntry other = (AccessEntry) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(principalArn(), other.principalArn())
                && hasKubernetesGroups() == other.hasKubernetesGroups()
                && Objects.equals(kubernetesGroups(), other.kubernetesGroups())
                && Objects.equals(accessEntryArn(), other.accessEntryArn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(username(), other.username())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessEntry").add("ClusterName", clusterName()).add("PrincipalArn", principalArn())
                .add("KubernetesGroups", hasKubernetesGroups() ? kubernetesGroups() : null)
                .add("AccessEntryArn", accessEntryArn()).add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt())
                .add("Tags", hasTags() ? tags() : null).add("Username", username()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "principalArn":
            return Optional.ofNullable(clazz.cast(principalArn()));
        case "kubernetesGroups":
            return Optional.ofNullable(clazz.cast(kubernetesGroups()));
        case "accessEntryArn":
            return Optional.ofNullable(clazz.cast(accessEntryArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "username":
            return Optional.ofNullable(clazz.cast(username()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessEntry, T> g) {
        return obj -> g.apply((AccessEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessEntry> {
        /**
         * <p>
         * The name of your cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The ARN of the IAM principal for the access entry. If you ever delete the IAM principal with this ARN, the
         * access entry isn't automatically deleted. We recommend that you delete the access entry with an ARN for an
         * IAM principal that you delete. If you don't delete the access entry and ever recreate the IAM principal, even
         * if it has the same ARN, the access entry won't work. This is because even though the ARN is the same for the
         * recreated IAM principal, the <code>roleID</code> or <code>userID</code> (you can see this with the Security
         * Token Service <code>GetCallerIdentity</code> API) is different for the recreated IAM principal than it was
         * for the original IAM principal. Even though you don't see the IAM principal's <code>roleID</code> or
         * <code>userID</code> for an access entry, Amazon EKS stores it with the access entry.
         * </p>
         * 
         * @param principalArn
         *        The ARN of the IAM principal for the access entry. If you ever delete the IAM principal with this ARN,
         *        the access entry isn't automatically deleted. We recommend that you delete the access entry with an
         *        ARN for an IAM principal that you delete. If you don't delete the access entry and ever recreate the
         *        IAM principal, even if it has the same ARN, the access entry won't work. This is because even though
         *        the ARN is the same for the recreated IAM principal, the <code>roleID</code> or <code>userID</code>
         *        (you can see this with the Security Token Service <code>GetCallerIdentity</code> API) is different for
         *        the recreated IAM principal than it was for the original IAM principal. Even though you don't see the
         *        IAM principal's <code>roleID</code> or <code>userID</code> for an access entry, Amazon EKS stores it
         *        with the access entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);

        /**
         * <p>
         * A <code>name</code> that you've specified in a Kubernetes <code>RoleBinding</code> or
         * <code>ClusterRoleBinding</code> object so that Kubernetes authorizes the <code>principalARN</code> access to
         * cluster objects.
         * </p>
         * 
         * @param kubernetesGroups
         *        A <code>name</code> that you've specified in a Kubernetes <code>RoleBinding</code> or
         *        <code>ClusterRoleBinding</code> object so that Kubernetes authorizes the <code>principalARN</code>
         *        access to cluster objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesGroups(Collection<String> kubernetesGroups);

        /**
         * <p>
         * A <code>name</code> that you've specified in a Kubernetes <code>RoleBinding</code> or
         * <code>ClusterRoleBinding</code> object so that Kubernetes authorizes the <code>principalARN</code> access to
         * cluster objects.
         * </p>
         * 
         * @param kubernetesGroups
         *        A <code>name</code> that you've specified in a Kubernetes <code>RoleBinding</code> or
         *        <code>ClusterRoleBinding</code> object so that Kubernetes authorizes the <code>principalARN</code>
         *        access to cluster objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesGroups(String... kubernetesGroups);

        /**
         * <p>
         * The ARN of the access entry.
         * </p>
         * 
         * @param accessEntryArn
         *        The ARN of the access entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEntryArn(String accessEntryArn);

        /**
         * <p>
         * The Unix epoch timestamp at object creation.
         * </p>
         * 
         * @param createdAt
         *        The Unix epoch timestamp at object creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix epoch timestamp for the last modification to the object.
         * </p>
         * 
         * @param modifiedAt
         *        The Unix epoch timestamp for the last modification to the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value.
         * You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         * </p>
         * 
         * @param tags
         *        Metadata that assists with categorization and organization. Each tag consists of a key and an optional
         *        value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The <code>name</code> of a user that can authenticate to your cluster.
         * </p>
         * 
         * @param username
         *        The <code>name</code> of a user that can authenticate to your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The type of the access entry.
         * </p>
         * 
         * @param type
         *        The type of the access entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String clusterName;

        private String principalArn;

        private List<String> kubernetesGroups = DefaultSdkAutoConstructList.getInstance();

        private String accessEntryArn;

        private Instant createdAt;

        private Instant modifiedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String username;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessEntry model) {
            clusterName(model.clusterName);
            principalArn(model.principalArn);
            kubernetesGroups(model.kubernetesGroups);
            accessEntryArn(model.accessEntryArn);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            tags(model.tags);
            username(model.username);
            type(model.type);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final Collection<String> getKubernetesGroups() {
            if (kubernetesGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return kubernetesGroups;
        }

        public final void setKubernetesGroups(Collection<String> kubernetesGroups) {
            this.kubernetesGroups = StringListCopier.copy(kubernetesGroups);
        }

        @Override
        public final Builder kubernetesGroups(Collection<String> kubernetesGroups) {
            this.kubernetesGroups = StringListCopier.copy(kubernetesGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kubernetesGroups(String... kubernetesGroups) {
            kubernetesGroups(Arrays.asList(kubernetesGroups));
            return this;
        }

        public final String getAccessEntryArn() {
            return accessEntryArn;
        }

        public final void setAccessEntryArn(String accessEntryArn) {
            this.accessEntryArn = accessEntryArn;
        }

        @Override
        public final Builder accessEntryArn(String accessEntryArn) {
            this.accessEntryArn = accessEntryArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AccessEntry build() {
            return new AccessEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
