/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.model.ListAddonsRequest;
import software.amazon.awssdk.services.eks.model.ListAddonsResponse;

public class ListAddonsPublisher
implements SdkPublisher<ListAddonsResponse> {
    private final EksAsyncClient client;
    private final ListAddonsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAddonsPublisher(EksAsyncClient client, ListAddonsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAddonsPublisher(EksAsyncClient client, ListAddonsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAddonsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAddonsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> addons() {
        Function<ListAddonsResponse, Iterator> getIterator = response -> {
            if (response != null && response.addons() != null) {
                return response.addons().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAddonsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAddonsResponseFetcher
    implements AsyncPageFetcher<ListAddonsResponse> {
        private ListAddonsResponseFetcher() {
        }

        public boolean hasNextPage(ListAddonsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAddonsResponse> nextPage(ListAddonsResponse previousPage) {
            if (previousPage == null) {
                return ListAddonsPublisher.this.client.listAddons(ListAddonsPublisher.this.firstRequest);
            }
            return ListAddonsPublisher.this.client.listAddons((ListAddonsRequest)((Object)ListAddonsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

