/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.Logging;
import software.amazon.awssdk.services.eks.model.VpcConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateClusterConfigRequest
extends EksRequest
implements ToCopyableBuilder<Builder, UpdateClusterConfigRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateClusterConfigRequest.getter(UpdateClusterConfigRequest::name)).setter(UpdateClusterConfigRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<VpcConfigRequest> RESOURCES_VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourcesVpcConfig").getter(UpdateClusterConfigRequest.getter(UpdateClusterConfigRequest::resourcesVpcConfig)).setter(UpdateClusterConfigRequest.setter(Builder::resourcesVpcConfig)).constructor(VpcConfigRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesVpcConfig").build()}).build();
    private static final SdkField<Logging> LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logging").getter(UpdateClusterConfigRequest.getter(UpdateClusterConfigRequest::logging)).setter(UpdateClusterConfigRequest.setter(Builder::logging)).constructor(Logging::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(UpdateClusterConfigRequest.getter(UpdateClusterConfigRequest::clientRequestToken)).setter(UpdateClusterConfigRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RESOURCES_VPC_CONFIG_FIELD, LOGGING_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String name;
    private final VpcConfigRequest resourcesVpcConfig;
    private final Logging logging;
    private final String clientRequestToken;

    private UpdateClusterConfigRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.resourcesVpcConfig = builder.resourcesVpcConfig;
        this.logging = builder.logging;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String name() {
        return this.name;
    }

    public final VpcConfigRequest resourcesVpcConfig() {
        return this.resourcesVpcConfig;
    }

    public final Logging logging() {
        return this.logging;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesVpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.logging());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterConfigRequest)) {
            return false;
        }
        UpdateClusterConfigRequest other = (UpdateClusterConfigRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.resourcesVpcConfig(), other.resourcesVpcConfig()) && Objects.equals(this.logging(), other.logging()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateClusterConfigRequest").add("Name", (Object)this.name()).add("ResourcesVpcConfig", (Object)this.resourcesVpcConfig()).add("Logging", (Object)this.logging()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "resourcesVpcConfig": {
                return Optional.ofNullable(clazz.cast(this.resourcesVpcConfig()));
            }
            case "logging": {
                return Optional.ofNullable(clazz.cast(this.logging()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterConfigRequest, T> g) {
        return obj -> g.apply((UpdateClusterConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String name;
        private VpcConfigRequest resourcesVpcConfig;
        private Logging logging;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterConfigRequest model) {
            super(model);
            this.name(model.name);
            this.resourcesVpcConfig(model.resourcesVpcConfig);
            this.logging(model.logging);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final VpcConfigRequest.Builder getResourcesVpcConfig() {
            return this.resourcesVpcConfig != null ? this.resourcesVpcConfig.toBuilder() : null;
        }

        public final void setResourcesVpcConfig(VpcConfigRequest.BuilderImpl resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig != null ? resourcesVpcConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder resourcesVpcConfig(VpcConfigRequest resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig;
            return this;
        }

        public final Logging.Builder getLogging() {
            return this.logging != null ? this.logging.toBuilder() : null;
        }

        public final void setLogging(Logging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        @Override
        @Transient
        public final Builder logging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterConfigRequest build() {
            return new UpdateClusterConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateClusterConfigRequest> {
        public Builder name(String var1);

        public Builder resourcesVpcConfig(VpcConfigRequest var1);

        default public Builder resourcesVpcConfig(Consumer<VpcConfigRequest.Builder> resourcesVpcConfig) {
            return this.resourcesVpcConfig((VpcConfigRequest)((VpcConfigRequest.Builder)VpcConfigRequest.builder().applyMutation(resourcesVpcConfig)).build());
        }

        public Builder logging(Logging var1);

        default public Builder logging(Consumer<Logging.Builder> logging) {
            return this.logging((Logging)((Logging.Builder)Logging.builder().applyMutation(logging)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

