/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNodegroupsResponse extends EksResponse implements
        ToCopyableBuilder<ListNodegroupsResponse.Builder, ListNodegroupsResponse> {
    private static final SdkField<List<String>> NODEGROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("nodegroups")
            .getter(getter(ListNodegroupsResponse::nodegroups))
            .setter(setter(Builder::nodegroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodegroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListNodegroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODEGROUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> nodegroups;

    private final String nextToken;

    private ListNodegroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nodegroups = builder.nodegroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Nodegroups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNodegroups() {
        return nodegroups != null && !(nodegroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all of the node groups associated with the specified cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodegroups} method.
     * </p>
     * 
     * @return A list of all of the node groups associated with the specified cluster.
     */
    public final List<String> nodegroups() {
        return nodegroups;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListNodegroups</code> request. When the results of
     * a <code>ListNodegroups</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next
     * page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListNodegroups</code> request. When the
     *         results of a <code>ListNodegroups</code> request exceed <code>maxResults</code>, you can use this value
     *         to retrieve the next page of results. This value is <code>null</code> when there are no more results to
     *         return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNodegroups() ? nodegroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNodegroupsResponse)) {
            return false;
        }
        ListNodegroupsResponse other = (ListNodegroupsResponse) obj;
        return hasNodegroups() == other.hasNodegroups() && Objects.equals(nodegroups(), other.nodegroups())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNodegroupsResponse").add("Nodegroups", hasNodegroups() ? nodegroups() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodegroups":
            return Optional.ofNullable(clazz.cast(nodegroups()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNodegroupsResponse, T> g) {
        return obj -> g.apply((ListNodegroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListNodegroupsResponse> {
        /**
         * <p>
         * A list of all of the node groups associated with the specified cluster.
         * </p>
         * 
         * @param nodegroups
         *        A list of all of the node groups associated with the specified cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodegroups(Collection<String> nodegroups);

        /**
         * <p>
         * A list of all of the node groups associated with the specified cluster.
         * </p>
         * 
         * @param nodegroups
         *        A list of all of the node groups associated with the specified cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodegroups(String... nodegroups);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListNodegroups</code> request. When the results
         * of a <code>ListNodegroups</code> request exceed <code>maxResults</code>, you can use this value to retrieve
         * the next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListNodegroups</code> request. When the
         *        results of a <code>ListNodegroups</code> request exceed <code>maxResults</code>, you can use this
         *        value to retrieve the next page of results. This value is <code>null</code> when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private List<String> nodegroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNodegroupsResponse model) {
            super(model);
            nodegroups(model.nodegroups);
            nextToken(model.nextToken);
        }

        public final Collection<String> getNodegroups() {
            if (nodegroups instanceof SdkAutoConstructList) {
                return null;
            }
            return nodegroups;
        }

        public final void setNodegroups(Collection<String> nodegroups) {
            this.nodegroups = StringListCopier.copy(nodegroups);
        }

        @Override
        @Transient
        public final Builder nodegroups(Collection<String> nodegroups) {
            this.nodegroups = StringListCopier.copy(nodegroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder nodegroups(String... nodegroups) {
            nodegroups(Arrays.asList(nodegroups));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNodegroupsResponse build() {
            return new ListNodegroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
