/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterClusterRequest extends EksRequest implements
        ToCopyableBuilder<RegisterClusterRequest.Builder, RegisterClusterRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RegisterClusterRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ConnectorConfigRequest> CONNECTOR_CONFIG_FIELD = SdkField
            .<ConnectorConfigRequest> builder(MarshallingType.SDK_POJO).memberName("connectorConfig")
            .getter(getter(RegisterClusterRequest::connectorConfig)).setter(setter(Builder::connectorConfig))
            .constructor(ConnectorConfigRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorConfig").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(RegisterClusterRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(RegisterClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CONNECTOR_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));

    private final String name;

    private final ConnectorConfigRequest connectorConfig;

    private final String clientRequestToken;

    private final Map<String, String> tags;

    private RegisterClusterRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.connectorConfig = builder.connectorConfig;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Define a unique name for this cluster for your Region.
     * </p>
     * 
     * @return Define a unique name for this cluster for your Region.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The configuration settings required to connect the Kubernetes cluster to the Amazon EKS control plane.
     * </p>
     * 
     * @return The configuration settings required to connect the Kubernetes cluster to the Amazon EKS control plane.
     */
    public final ConnectorConfigRequest connectorConfig() {
        return connectorConfig;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata that you apply to the cluster to assist with categorization and organization. Each tag consists of a
     * key and an optional value, both of which you define. Cluster tags do not propagate to any other resources
     * associated with the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The metadata that you apply to the cluster to assist with categorization and organization. Each tag
     *         consists of a key and an optional value, both of which you define. Cluster tags do not propagate to any
     *         other resources associated with the cluster.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(connectorConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterClusterRequest)) {
            return false;
        }
        RegisterClusterRequest other = (RegisterClusterRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(connectorConfig(), other.connectorConfig())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterClusterRequest").add("Name", name()).add("ConnectorConfig", connectorConfig())
                .add("ClientRequestToken", clientRequestToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "connectorConfig":
            return Optional.ofNullable(clazz.cast(connectorConfig()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterClusterRequest, T> g) {
        return obj -> g.apply((RegisterClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterClusterRequest> {
        /**
         * <p>
         * Define a unique name for this cluster for your Region.
         * </p>
         * 
         * @param name
         *        Define a unique name for this cluster for your Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The configuration settings required to connect the Kubernetes cluster to the Amazon EKS control plane.
         * </p>
         * 
         * @param connectorConfig
         *        The configuration settings required to connect the Kubernetes cluster to the Amazon EKS control plane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorConfig(ConnectorConfigRequest connectorConfig);

        /**
         * <p>
         * The configuration settings required to connect the Kubernetes cluster to the Amazon EKS control plane.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectorConfigRequest.Builder} avoiding
         * the need to create one manually via {@link ConnectorConfigRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectorConfigRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #connectorConfig(ConnectorConfigRequest)}.
         * 
         * @param connectorConfig
         *        a consumer that will call methods on {@link ConnectorConfigRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorConfig(ConnectorConfigRequest)
         */
        default Builder connectorConfig(Consumer<ConnectorConfigRequest.Builder> connectorConfig) {
            return connectorConfig(ConnectorConfigRequest.builder().applyMutation(connectorConfig).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The metadata that you apply to the cluster to assist with categorization and organization. Each tag consists
         * of a key and an optional value, both of which you define. Cluster tags do not propagate to any other
         * resources associated with the cluster.
         * </p>
         * 
         * @param tags
         *        The metadata that you apply to the cluster to assist with categorization and organization. Each tag
         *        consists of a key and an optional value, both of which you define. Cluster tags do not propagate to
         *        any other resources associated with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String name;

        private ConnectorConfigRequest connectorConfig;

        private String clientRequestToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterClusterRequest model) {
            super(model);
            name(model.name);
            connectorConfig(model.connectorConfig);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ConnectorConfigRequest.Builder getConnectorConfig() {
            return connectorConfig != null ? connectorConfig.toBuilder() : null;
        }

        public final void setConnectorConfig(ConnectorConfigRequest.BuilderImpl connectorConfig) {
            this.connectorConfig = connectorConfig != null ? connectorConfig.build() : null;
        }

        @Override
        public final Builder connectorConfig(ConnectorConfigRequest connectorConfig) {
            this.connectorConfig = connectorConfig;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterClusterRequest build() {
            return new RegisterClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
