/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIdentityProviderConfigsResponse extends EksResponse implements
        ToCopyableBuilder<ListIdentityProviderConfigsResponse.Builder, ListIdentityProviderConfigsResponse> {
    private static final SdkField<List<IdentityProviderConfig>> IDENTITY_PROVIDER_CONFIGS_FIELD = SdkField
            .<List<IdentityProviderConfig>> builder(MarshallingType.LIST)
            .memberName("identityProviderConfigs")
            .getter(getter(ListIdentityProviderConfigsResponse::identityProviderConfigs))
            .setter(setter(Builder::identityProviderConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdentityProviderConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentityProviderConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListIdentityProviderConfigsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IDENTITY_PROVIDER_CONFIGS_FIELD, NEXT_TOKEN_FIELD));

    private final List<IdentityProviderConfig> identityProviderConfigs;

    private final String nextToken;

    private ListIdentityProviderConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.identityProviderConfigs = builder.identityProviderConfigs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdentityProviderConfigs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIdentityProviderConfigs() {
        return identityProviderConfigs != null && !(identityProviderConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identity provider configurations for the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentityProviderConfigs} method.
     * </p>
     * 
     * @return The identity provider configurations for the cluster.
     */
    public final List<IdentityProviderConfig> identityProviderConfigs() {
        return identityProviderConfigs;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated
     * <code>ListIdentityProviderConfigsResponse</code> where <code>maxResults</code> was used and the results exceeded
     * the value of that parameter. Pagination continues from the end of the previous results that returned the
     * <code>nextToken</code> value.
     * </p>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated
     *         <code>ListIdentityProviderConfigsResponse</code> where <code>maxResults</code> was used and the results
     *         exceeded the value of that parameter. Pagination continues from the end of the previous results that
     *         returned the <code>nextToken</code> value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentityProviderConfigs() ? identityProviderConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityProviderConfigsResponse)) {
            return false;
        }
        ListIdentityProviderConfigsResponse other = (ListIdentityProviderConfigsResponse) obj;
        return hasIdentityProviderConfigs() == other.hasIdentityProviderConfigs()
                && Objects.equals(identityProviderConfigs(), other.identityProviderConfigs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIdentityProviderConfigsResponse")
                .add("IdentityProviderConfigs", hasIdentityProviderConfigs() ? identityProviderConfigs() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identityProviderConfigs":
            return Optional.ofNullable(clazz.cast(identityProviderConfigs()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIdentityProviderConfigsResponse, T> g) {
        return obj -> g.apply((ListIdentityProviderConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListIdentityProviderConfigsResponse> {
        /**
         * <p>
         * The identity provider configurations for the cluster.
         * </p>
         * 
         * @param identityProviderConfigs
         *        The identity provider configurations for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderConfigs(Collection<IdentityProviderConfig> identityProviderConfigs);

        /**
         * <p>
         * The identity provider configurations for the cluster.
         * </p>
         * 
         * @param identityProviderConfigs
         *        The identity provider configurations for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderConfigs(IdentityProviderConfig... identityProviderConfigs);

        /**
         * <p>
         * The identity provider configurations for the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<IdentityProviderConfig>.Builder}
         * avoiding the need to create one manually via {@link List<IdentityProviderConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IdentityProviderConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link #identityProviderConfigs(List<IdentityProviderConfig>)}.
         * 
         * @param identityProviderConfigs
         *        a consumer that will call methods on {@link List<IdentityProviderConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProviderConfigs(List<IdentityProviderConfig>)
         */
        Builder identityProviderConfigs(Consumer<IdentityProviderConfig.Builder>... identityProviderConfigs);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated
         * <code>ListIdentityProviderConfigsResponse</code> where <code>maxResults</code> was used and the results
         * exceeded the value of that parameter. Pagination continues from the end of the previous results that returned
         * the <code>nextToken</code> value.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated
         *        <code>ListIdentityProviderConfigsResponse</code> where <code>maxResults</code> was used and the
         *        results exceeded the value of that parameter. Pagination continues from the end of the previous
         *        results that returned the <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private List<IdentityProviderConfig> identityProviderConfigs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityProviderConfigsResponse model) {
            super(model);
            identityProviderConfigs(model.identityProviderConfigs);
            nextToken(model.nextToken);
        }

        public final List<IdentityProviderConfig.Builder> getIdentityProviderConfigs() {
            List<IdentityProviderConfig.Builder> result = IdentityProviderConfigsCopier
                    .copyToBuilder(this.identityProviderConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentityProviderConfigs(Collection<IdentityProviderConfig.BuilderImpl> identityProviderConfigs) {
            this.identityProviderConfigs = IdentityProviderConfigsCopier.copyFromBuilder(identityProviderConfigs);
        }

        @Override
        public final Builder identityProviderConfigs(Collection<IdentityProviderConfig> identityProviderConfigs) {
            this.identityProviderConfigs = IdentityProviderConfigsCopier.copy(identityProviderConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityProviderConfigs(IdentityProviderConfig... identityProviderConfigs) {
            identityProviderConfigs(Arrays.asList(identityProviderConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityProviderConfigs(Consumer<IdentityProviderConfig.Builder>... identityProviderConfigs) {
            identityProviderConfigs(Stream.of(identityProviderConfigs)
                    .map(c -> IdentityProviderConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIdentityProviderConfigsResponse build() {
            return new ListIdentityProviderConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
