/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the logging configuration for resources in your cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Logging implements SdkPojo, Serializable, ToCopyableBuilder<Logging.Builder, Logging> {
    private static final SdkField<List<LogSetup>> CLUSTER_LOGGING_FIELD = SdkField
            .<List<LogSetup>> builder(MarshallingType.LIST)
            .memberName("clusterLogging")
            .getter(getter(Logging::clusterLogging))
            .setter(setter(Builder::clusterLogging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterLogging").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogSetup> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogSetup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_LOGGING_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<LogSetup> clusterLogging;

    private Logging(BuilderImpl builder) {
        this.clusterLogging = builder.clusterLogging;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterLogging property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterLogging() {
        return clusterLogging != null && !(clusterLogging instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The cluster control plane logging configuration for your cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterLogging} method.
     * </p>
     * 
     * @return The cluster control plane logging configuration for your cluster.
     */
    public final List<LogSetup> clusterLogging() {
        return clusterLogging;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterLogging() ? clusterLogging() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Logging)) {
            return false;
        }
        Logging other = (Logging) obj;
        return hasClusterLogging() == other.hasClusterLogging() && Objects.equals(clusterLogging(), other.clusterLogging());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Logging").add("ClusterLogging", hasClusterLogging() ? clusterLogging() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterLogging":
            return Optional.ofNullable(clazz.cast(clusterLogging()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Logging, T> g) {
        return obj -> g.apply((Logging) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Logging> {
        /**
         * <p>
         * The cluster control plane logging configuration for your cluster.
         * </p>
         * 
         * @param clusterLogging
         *        The cluster control plane logging configuration for your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterLogging(Collection<LogSetup> clusterLogging);

        /**
         * <p>
         * The cluster control plane logging configuration for your cluster.
         * </p>
         * 
         * @param clusterLogging
         *        The cluster control plane logging configuration for your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterLogging(LogSetup... clusterLogging);

        /**
         * <p>
         * The cluster control plane logging configuration for your cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<LogSetup>.Builder} avoiding the need
         * to create one manually via {@link List<LogSetup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LogSetup>.Builder#build()} is called immediately and its
         * result is passed to {@link #clusterLogging(List<LogSetup>)}.
         * 
         * @param clusterLogging
         *        a consumer that will call methods on {@link List<LogSetup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterLogging(List<LogSetup>)
         */
        Builder clusterLogging(Consumer<LogSetup.Builder>... clusterLogging);
    }

    static final class BuilderImpl implements Builder {
        private List<LogSetup> clusterLogging = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Logging model) {
            clusterLogging(model.clusterLogging);
        }

        public final List<LogSetup.Builder> getClusterLogging() {
            List<LogSetup.Builder> result = LogSetupsCopier.copyToBuilder(this.clusterLogging);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterLogging(Collection<LogSetup.BuilderImpl> clusterLogging) {
            this.clusterLogging = LogSetupsCopier.copyFromBuilder(clusterLogging);
        }

        @Override
        public final Builder clusterLogging(Collection<LogSetup> clusterLogging) {
            this.clusterLogging = LogSetupsCopier.copy(clusterLogging);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterLogging(LogSetup... clusterLogging) {
            clusterLogging(Arrays.asList(clusterLogging));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterLogging(Consumer<LogSetup.Builder>... clusterLogging) {
            clusterLogging(Stream.of(clusterLogging).map(c -> LogSetup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Logging build() {
            return new Logging(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
