/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNodegroupVersionRequest extends EksRequest implements
        ToCopyableBuilder<UpdateNodegroupVersionRequest.Builder, UpdateNodegroupVersionRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(UpdateNodegroupVersionRequest::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> NODEGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodegroupName").getter(getter(UpdateNodegroupVersionRequest::nodegroupName))
            .setter(setter(Builder::nodegroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("nodegroupName").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(UpdateNodegroupVersionRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> RELEASE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("releaseVersion").getter(getter(UpdateNodegroupVersionRequest::releaseVersion))
            .setter(setter(Builder::releaseVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseVersion").build()).build();

    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField
            .<LaunchTemplateSpecification> builder(MarshallingType.SDK_POJO).memberName("launchTemplate")
            .getter(getter(UpdateNodegroupVersionRequest::launchTemplate)).setter(setter(Builder::launchTemplate))
            .constructor(LaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplate").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("force")
            .getter(getter(UpdateNodegroupVersionRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("force").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(UpdateNodegroupVersionRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            NODEGROUP_NAME_FIELD, VERSION_FIELD, RELEASE_VERSION_FIELD, LAUNCH_TEMPLATE_FIELD, FORCE_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD));

    private final String clusterName;

    private final String nodegroupName;

    private final String version;

    private final String releaseVersion;

    private final LaunchTemplateSpecification launchTemplate;

    private final Boolean force;

    private final String clientRequestToken;

    private UpdateNodegroupVersionRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodegroupName = builder.nodegroupName;
        this.version = builder.version;
        this.releaseVersion = builder.releaseVersion;
        this.launchTemplate = builder.launchTemplate;
        this.force = builder.force;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of the Amazon EKS cluster that is associated with the managed node group to update.
     * </p>
     * 
     * @return The name of the Amazon EKS cluster that is associated with the managed node group to update.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The name of the managed node group to update.
     * </p>
     * 
     * @return The name of the managed node group to update.
     */
    public final String nodegroupName() {
        return nodegroupName;
    }

    /**
     * <p>
     * The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the node group
     * does not change. You can specify the Kubernetes version of the cluster to update the node group to the latest AMI
     * version of the cluster's Kubernetes version. If you specify <code>launchTemplate</code>, and your launch template
     * uses a custom AMI, then don't specify <code>version</code>, or the node group update will fail. For more
     * information about using launch templates with Amazon EKS, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the
     * Amazon EKS User Guide.
     * </p>
     * 
     * @return The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the node
     *         group does not change. You can specify the Kubernetes version of the cluster to update the node group to
     *         the latest AMI version of the cluster's Kubernetes version. If you specify <code>launchTemplate</code>,
     *         and your launch template uses a custom AMI, then don't specify <code>version</code>, or the node group
     *         update will fail. For more information about using launch templates with Amazon EKS, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a>
     *         in the Amazon EKS User Guide.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The AMI version of the Amazon EKS optimized AMI to use for the update. By default, the latest available AMI
     * version for the node group's Kubernetes version is used. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized Amazon
     * Linux 2 AMI versions </a> in the <i>Amazon EKS User Guide</i>. If you specify <code>launchTemplate</code>, and
     * your launch template uses a custom AMI, then don't specify <code>releaseVersion</code>, or the node group update
     * will fail. For more information about using launch templates with Amazon EKS, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the
     * Amazon EKS User Guide.
     * </p>
     * 
     * @return The AMI version of the Amazon EKS optimized AMI to use for the update. By default, the latest available
     *         AMI version for the node group's Kubernetes version is used. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized
     *         Amazon Linux 2 AMI versions </a> in the <i>Amazon EKS User Guide</i>. If you specify
     *         <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify
     *         <code>releaseVersion</code>, or the node group update will fail. For more information about using launch
     *         templates with Amazon EKS, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a>
     *         in the Amazon EKS User Guide.
     */
    public final String releaseVersion() {
        return releaseVersion;
    }

    /**
     * <p>
     * An object representing a node group's launch template specification. You can only update a node group using a
     * launch template if the node group was originally deployed with a launch template.
     * </p>
     * 
     * @return An object representing a node group's launch template specification. You can only update a node group
     *         using a launch template if the node group was originally deployed with a launch template.
     */
    public final LaunchTemplateSpecification launchTemplate() {
        return launchTemplate;
    }

    /**
     * <p>
     * Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue.
     * If an update fails because pods could not be drained, you can force the update after it fails to terminate the
     * old node whether or not any pods are running on the node.
     * </p>
     * 
     * @return Force the update if the existing node group's pods are unable to be drained due to a pod disruption
     *         budget issue. If an update fails because pods could not be drained, you can force the update after it
     *         fails to terminate the old node whether or not any pods are running on the node.
     */
    public final Boolean force() {
        return force;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(nodegroupName());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(releaseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNodegroupVersionRequest)) {
            return false;
        }
        UpdateNodegroupVersionRequest other = (UpdateNodegroupVersionRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(nodegroupName(), other.nodegroupName())
                && Objects.equals(version(), other.version()) && Objects.equals(releaseVersion(), other.releaseVersion())
                && Objects.equals(launchTemplate(), other.launchTemplate()) && Objects.equals(force(), other.force())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateNodegroupVersionRequest").add("ClusterName", clusterName())
                .add("NodegroupName", nodegroupName()).add("Version", version()).add("ReleaseVersion", releaseVersion())
                .add("LaunchTemplate", launchTemplate()).add("Force", force()).add("ClientRequestToken", clientRequestToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "nodegroupName":
            return Optional.ofNullable(clazz.cast(nodegroupName()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "releaseVersion":
            return Optional.ofNullable(clazz.cast(releaseVersion()));
        case "launchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "force":
            return Optional.ofNullable(clazz.cast(force()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNodegroupVersionRequest, T> g) {
        return obj -> g.apply((UpdateNodegroupVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateNodegroupVersionRequest> {
        /**
         * <p>
         * The name of the Amazon EKS cluster that is associated with the managed node group to update.
         * </p>
         * 
         * @param clusterName
         *        The name of the Amazon EKS cluster that is associated with the managed node group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The name of the managed node group to update.
         * </p>
         * 
         * @param nodegroupName
         *        The name of the managed node group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodegroupName(String nodegroupName);

        /**
         * <p>
         * The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the node
         * group does not change. You can specify the Kubernetes version of the cluster to update the node group to the
         * latest AMI version of the cluster's Kubernetes version. If you specify <code>launchTemplate</code>, and your
         * launch template uses a custom AMI, then don't specify <code>version</code>, or the node group update will
         * fail. For more information about using launch templates with Amazon EKS, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in
         * the Amazon EKS User Guide.
         * </p>
         * 
         * @param version
         *        The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the
         *        node group does not change. You can specify the Kubernetes version of the cluster to update the node
         *        group to the latest AMI version of the cluster's Kubernetes version. If you specify
         *        <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify
         *        <code>version</code>, or the node group update will fail. For more information about using launch
         *        templates with Amazon EKS, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template
         *        support</a> in the Amazon EKS User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The AMI version of the Amazon EKS optimized AMI to use for the update. By default, the latest available AMI
         * version for the node group's Kubernetes version is used. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized
         * Amazon Linux 2 AMI versions </a> in the <i>Amazon EKS User Guide</i>. If you specify
         * <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify
         * <code>releaseVersion</code>, or the node group update will fail. For more information about using launch
         * templates with Amazon EKS, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in
         * the Amazon EKS User Guide.
         * </p>
         * 
         * @param releaseVersion
         *        The AMI version of the Amazon EKS optimized AMI to use for the update. By default, the latest
         *        available AMI version for the node group's Kubernetes version is used. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS
         *        optimized Amazon Linux 2 AMI versions </a> in the <i>Amazon EKS User Guide</i>. If you specify
         *        <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify
         *        <code>releaseVersion</code>, or the node group update will fail. For more information about using
         *        launch templates with Amazon EKS, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template
         *        support</a> in the Amazon EKS User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseVersion(String releaseVersion);

        /**
         * <p>
         * An object representing a node group's launch template specification. You can only update a node group using a
         * launch template if the node group was originally deployed with a launch template.
         * </p>
         * 
         * @param launchTemplate
         *        An object representing a node group's launch template specification. You can only update a node group
         *        using a launch template if the node group was originally deployed with a launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(LaunchTemplateSpecification launchTemplate);

        /**
         * <p>
         * An object representing a node group's launch template specification. You can only update a node group using a
         * launch template if the node group was originally deployed with a launch template.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchTemplateSpecification.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplateSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplate(LaunchTemplateSpecification)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link LaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(LaunchTemplateSpecification)
         */
        default Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return launchTemplate(LaunchTemplateSpecification.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget
         * issue. If an update fails because pods could not be drained, you can force the update after it fails to
         * terminate the old node whether or not any pods are running on the node.
         * </p>
         * 
         * @param force
         *        Force the update if the existing node group's pods are unable to be drained due to a pod disruption
         *        budget issue. If an update fails because pods could not be drained, you can force the update after it
         *        fails to terminate the old node whether or not any pods are running on the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String nodegroupName;

        private String version;

        private String releaseVersion;

        private LaunchTemplateSpecification launchTemplate;

        private Boolean force;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNodegroupVersionRequest model) {
            super(model);
            clusterName(model.clusterName);
            nodegroupName(model.nodegroupName);
            version(model.version);
            releaseVersion(model.releaseVersion);
            launchTemplate(model.launchTemplate);
            force(model.force);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getNodegroupName() {
            return nodegroupName;
        }

        public final void setNodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
        }

        @Override
        public final Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getReleaseVersion() {
            return releaseVersion;
        }

        public final void setReleaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
        }

        @Override
        public final Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final Boolean getForce() {
            return force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNodegroupVersionRequest build() {
            return new UpdateNodegroupVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
