/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateIdentityProviderConfigRequest extends EksRequest implements
        ToCopyableBuilder<DisassociateIdentityProviderConfigRequest.Builder, DisassociateIdentityProviderConfigRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(DisassociateIdentityProviderConfigRequest::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<IdentityProviderConfig> IDENTITY_PROVIDER_CONFIG_FIELD = SdkField
            .<IdentityProviderConfig> builder(MarshallingType.SDK_POJO).memberName("identityProviderConfig")
            .getter(getter(DisassociateIdentityProviderConfigRequest::identityProviderConfig))
            .setter(setter(Builder::identityProviderConfig)).constructor(IdentityProviderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderConfig").build())
            .build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(DisassociateIdentityProviderConfigRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            IDENTITY_PROVIDER_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String clusterName;

    private final IdentityProviderConfig identityProviderConfig;

    private final String clientRequestToken;

    private DisassociateIdentityProviderConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.identityProviderConfig = builder.identityProviderConfig;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of the cluster to disassociate an identity provider from.
     * </p>
     * 
     * @return The name of the cluster to disassociate an identity provider from.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * An object that represents an identity provider configuration.
     * </p>
     * 
     * @return An object that represents an identity provider configuration.
     */
    public final IdentityProviderConfig identityProviderConfig() {
        return identityProviderConfig;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateIdentityProviderConfigRequest)) {
            return false;
        }
        DisassociateIdentityProviderConfigRequest other = (DisassociateIdentityProviderConfigRequest) obj;
        return Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(identityProviderConfig(), other.identityProviderConfig())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateIdentityProviderConfigRequest").add("ClusterName", clusterName())
                .add("IdentityProviderConfig", identityProviderConfig()).add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "identityProviderConfig":
            return Optional.ofNullable(clazz.cast(identityProviderConfig()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateIdentityProviderConfigRequest, T> g) {
        return obj -> g.apply((DisassociateIdentityProviderConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateIdentityProviderConfigRequest> {
        /**
         * <p>
         * The name of the cluster to disassociate an identity provider from.
         * </p>
         * 
         * @param clusterName
         *        The name of the cluster to disassociate an identity provider from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * An object that represents an identity provider configuration.
         * </p>
         * 
         * @param identityProviderConfig
         *        An object that represents an identity provider configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderConfig(IdentityProviderConfig identityProviderConfig);

        /**
         * <p>
         * An object that represents an identity provider configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityProviderConfig.Builder} avoiding
         * the need to create one manually via {@link IdentityProviderConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link IdentityProviderConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #identityProviderConfig(IdentityProviderConfig)}.
         * 
         * @param identityProviderConfig
         *        a consumer that will call methods on {@link IdentityProviderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProviderConfig(IdentityProviderConfig)
         */
        default Builder identityProviderConfig(Consumer<IdentityProviderConfig.Builder> identityProviderConfig) {
            return identityProviderConfig(IdentityProviderConfig.builder().applyMutation(identityProviderConfig).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterName;

        private IdentityProviderConfig identityProviderConfig;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateIdentityProviderConfigRequest model) {
            super(model);
            clusterName(model.clusterName);
            identityProviderConfig(model.identityProviderConfig);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final IdentityProviderConfig.Builder getIdentityProviderConfig() {
            return identityProviderConfig != null ? identityProviderConfig.toBuilder() : null;
        }

        public final void setIdentityProviderConfig(IdentityProviderConfig.BuilderImpl identityProviderConfig) {
            this.identityProviderConfig = identityProviderConfig != null ? identityProviderConfig.build() : null;
        }

        @Override
        public final Builder identityProviderConfig(IdentityProviderConfig identityProviderConfig) {
            this.identityProviderConfig = identityProviderConfig;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateIdentityProviderConfigRequest build() {
            return new DisassociateIdentityProviderConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
