/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClustersResponse extends EksResponse implements
        ToCopyableBuilder<ListClustersResponse.Builder, ListClustersResponse> {
    private static final SdkField<List<String>> CLUSTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("clusters")
            .getter(getter(ListClustersResponse::clusters))
            .setter(setter(Builder::clusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListClustersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> clusters;

    private final String nextToken;

    private ListClustersResponse(BuilderImpl builder) {
        super(builder);
        this.clusters = builder.clusters;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Clusters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasClusters() {
        return clusters != null && !(clusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all of the clusters for your account in the specified Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClusters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of all of the clusters for your account in the specified Region.
     */
    public final List<String> clusters() {
        return clusters;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListClusters</code> request. When the results of a
     * <code>ListClusters</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next
     * page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListClusters</code> request. When the
     *         results of a <code>ListClusters</code> request exceed <code>maxResults</code>, you can use this value to
     *         retrieve the next page of results. This value is <code>null</code> when there are no more results to
     *         return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasClusters() ? clusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResponse)) {
            return false;
        }
        ListClustersResponse other = (ListClustersResponse) obj;
        return hasClusters() == other.hasClusters() && Objects.equals(clusters(), other.clusters())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClustersResponse").add("Clusters", hasClusters() ? clusters() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusters":
            return Optional.ofNullable(clazz.cast(clusters()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClustersResponse, T> g) {
        return obj -> g.apply((ListClustersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListClustersResponse> {
        /**
         * <p>
         * A list of all of the clusters for your account in the specified Region.
         * </p>
         * 
         * @param clusters
         *        A list of all of the clusters for your account in the specified Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(Collection<String> clusters);

        /**
         * <p>
         * A list of all of the clusters for your account in the specified Region.
         * </p>
         * 
         * @param clusters
         *        A list of all of the clusters for your account in the specified Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(String... clusters);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListClusters</code> request. When the results
         * of a <code>ListClusters</code> request exceed <code>maxResults</code>, you can use this value to retrieve the
         * next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListClusters</code> request. When the
         *        results of a <code>ListClusters</code> request exceed <code>maxResults</code>, you can use this value
         *        to retrieve the next page of results. This value is <code>null</code> when there are no more results
         *        to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private List<String> clusters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersResponse model) {
            super(model);
            clusters(model.clusters);
            nextToken(model.nextToken);
        }

        public final Collection<String> getClusters() {
            if (clusters instanceof SdkAutoConstructList) {
                return null;
            }
            return clusters;
        }

        @Override
        public final Builder clusters(Collection<String> clusters) {
            this.clusters = StringListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(String... clusters) {
            clusters(Arrays.asList(clusters));
            return this;
        }

        public final void setClusters(Collection<String> clusters) {
            this.clusters = StringListCopier.copy(clusters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListClustersResponse build() {
            return new ListClustersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
