/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an asynchronous update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Update implements SdkPojo, Serializable, ToCopyableBuilder<Update.Builder, Update> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Update::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Update::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Update::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<UpdateParam>> PARAMS_FIELD = SdkField
            .<List<UpdateParam>> builder(MarshallingType.LIST)
            .memberName("params")
            .getter(getter(Update::params))
            .setter(setter(Builder::params))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("params").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateParam> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateParam::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Update::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<List<ErrorDetail>> ERRORS_FIELD = SdkField
            .<List<ErrorDetail>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(Update::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ErrorDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD,
            TYPE_FIELD, PARAMS_FIELD, CREATED_AT_FIELD, ERRORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String status;

    private final String type;

    private final List<UpdateParam> params;

    private final Instant createdAt;

    private final List<ErrorDetail> errors;

    private Update(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.type = builder.type;
        this.params = builder.params;
        this.createdAt = builder.createdAt;
        this.errors = builder.errors;
    }

    /**
     * <p>
     * A UUID that is used to track the update.
     * </p>
     * 
     * @return A UUID that is used to track the update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The current status of the update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the update.
     * @see UpdateStatus
     */
    public final UpdateStatus status() {
        return UpdateStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the update.
     * @see UpdateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of the update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the update.
     * @see UpdateType
     */
    public final UpdateType type() {
        return UpdateType.fromValue(type);
    }

    /**
     * <p>
     * The type of the update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the update.
     * @see UpdateType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * Returns true if the Params property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasParams() {
        return params != null && !(params instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A key-value map that contains the parameters associated with the update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParams()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A key-value map that contains the parameters associated with the update.
     */
    public final List<UpdateParam> params() {
        return params;
    }

    /**
     * <p>
     * The Unix epoch timestamp in seconds for when the update was created.
     * </p>
     * 
     * @return The Unix epoch timestamp in seconds for when the update was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any errors associated with a <code>Failed</code> update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any errors associated with a <code>Failed</code> update.
     */
    public final List<ErrorDetail> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasParams() ? params() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Update)) {
            return false;
        }
        Update other = (Update) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && hasParams() == other.hasParams()
                && Objects.equals(params(), other.params()) && Objects.equals(createdAt(), other.createdAt())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Update").add("Id", id()).add("Status", statusAsString()).add("Type", typeAsString())
                .add("Params", hasParams() ? params() : null).add("CreatedAt", createdAt())
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "params":
            return Optional.ofNullable(clazz.cast(params()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Update, T> g) {
        return obj -> g.apply((Update) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Update> {
        /**
         * <p>
         * A UUID that is used to track the update.
         * </p>
         * 
         * @param id
         *        A UUID that is used to track the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The current status of the update.
         * </p>
         * 
         * @param status
         *        The current status of the update.
         * @see UpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the update.
         * </p>
         * 
         * @param status
         *        The current status of the update.
         * @see UpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateStatus
         */
        Builder status(UpdateStatus status);

        /**
         * <p>
         * The type of the update.
         * </p>
         * 
         * @param type
         *        The type of the update.
         * @see UpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the update.
         * </p>
         * 
         * @param type
         *        The type of the update.
         * @see UpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateType
         */
        Builder type(UpdateType type);

        /**
         * <p>
         * A key-value map that contains the parameters associated with the update.
         * </p>
         * 
         * @param params
         *        A key-value map that contains the parameters associated with the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder params(Collection<UpdateParam> params);

        /**
         * <p>
         * A key-value map that contains the parameters associated with the update.
         * </p>
         * 
         * @param params
         *        A key-value map that contains the parameters associated with the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder params(UpdateParam... params);

        /**
         * <p>
         * A key-value map that contains the parameters associated with the update.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UpdateParam>.Builder} avoiding the need to
         * create one manually via {@link List<UpdateParam>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpdateParam>.Builder#build()} is called immediately and its
         * result is passed to {@link #params(List<UpdateParam>)}.
         * 
         * @param params
         *        a consumer that will call methods on {@link List<UpdateParam>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #params(List<UpdateParam>)
         */
        Builder params(Consumer<UpdateParam.Builder>... params);

        /**
         * <p>
         * The Unix epoch timestamp in seconds for when the update was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix epoch timestamp in seconds for when the update was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Any errors associated with a <code>Failed</code> update.
         * </p>
         * 
         * @param errors
         *        Any errors associated with a <code>Failed</code> update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<ErrorDetail> errors);

        /**
         * <p>
         * Any errors associated with a <code>Failed</code> update.
         * </p>
         * 
         * @param errors
         *        Any errors associated with a <code>Failed</code> update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(ErrorDetail... errors);

        /**
         * <p>
         * Any errors associated with a <code>Failed</code> update.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ErrorDetail>.Builder} avoiding the need to
         * create one manually via {@link List<ErrorDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ErrorDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #errors(List<ErrorDetail>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<ErrorDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<ErrorDetail>)
         */
        Builder errors(Consumer<ErrorDetail.Builder>... errors);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String status;

        private String type;

        private List<UpdateParam> params = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private List<ErrorDetail> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Update model) {
            id(model.id);
            status(model.status);
            type(model.type);
            params(model.params);
            createdAt(model.createdAt);
            errors(model.errors);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UpdateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UpdateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final List<UpdateParam.Builder> getParams() {
            List<UpdateParam.Builder> result = UpdateParamsCopier.copyToBuilder(this.params);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder params(Collection<UpdateParam> params) {
            this.params = UpdateParamsCopier.copy(params);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder params(UpdateParam... params) {
            params(Arrays.asList(params));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder params(Consumer<UpdateParam.Builder>... params) {
            params(Stream.of(params).map(c -> UpdateParam.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParams(Collection<UpdateParam.BuilderImpl> params) {
            this.params = UpdateParamsCopier.copyFromBuilder(params);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final List<ErrorDetail.Builder> getErrors() {
            List<ErrorDetail.Builder> result = ErrorDetailsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder errors(Collection<ErrorDetail> errors) {
            this.errors = ErrorDetailsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(ErrorDetail... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<ErrorDetail.Builder>... errors) {
            errors(Stream.of(errors).map(c -> ErrorDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<ErrorDetail.BuilderImpl> errors) {
            this.errors = ErrorDetailsCopier.copyFromBuilder(errors);
        }

        @Override
        public Update build() {
            return new Update(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
