/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodegroupUpdateConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<NodegroupUpdateConfig.Builder, NodegroupUpdateConfig> {
    private static final SdkField<Integer> MAX_UNAVAILABLE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxUnavailable").getter(getter(NodegroupUpdateConfig::maxUnavailable))
            .setter(setter(Builder::maxUnavailable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxUnavailable").build()).build();

    private static final SdkField<Integer> MAX_UNAVAILABLE_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxUnavailablePercentage").getter(getter(NodegroupUpdateConfig::maxUnavailablePercentage))
            .setter(setter(Builder::maxUnavailablePercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxUnavailablePercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_UNAVAILABLE_FIELD,
            MAX_UNAVAILABLE_PERCENTAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxUnavailable;

    private final Integer maxUnavailablePercentage;

    private NodegroupUpdateConfig(BuilderImpl builder) {
        this.maxUnavailable = builder.maxUnavailable;
        this.maxUnavailablePercentage = builder.maxUnavailablePercentage;
    }

    /**
     * Returns the value of the MaxUnavailable property for this object.
     * 
     * @return The value of the MaxUnavailable property for this object.
     */
    public final Integer maxUnavailable() {
        return maxUnavailable;
    }

    /**
     * Returns the value of the MaxUnavailablePercentage property for this object.
     * 
     * @return The value of the MaxUnavailablePercentage property for this object.
     */
    public final Integer maxUnavailablePercentage() {
        return maxUnavailablePercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxUnavailable());
        hashCode = 31 * hashCode + Objects.hashCode(maxUnavailablePercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodegroupUpdateConfig)) {
            return false;
        }
        NodegroupUpdateConfig other = (NodegroupUpdateConfig) obj;
        return Objects.equals(maxUnavailable(), other.maxUnavailable())
                && Objects.equals(maxUnavailablePercentage(), other.maxUnavailablePercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodegroupUpdateConfig").add("MaxUnavailable", maxUnavailable())
                .add("MaxUnavailablePercentage", maxUnavailablePercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxUnavailable":
            return Optional.ofNullable(clazz.cast(maxUnavailable()));
        case "maxUnavailablePercentage":
            return Optional.ofNullable(clazz.cast(maxUnavailablePercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodegroupUpdateConfig, T> g) {
        return obj -> g.apply((NodegroupUpdateConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodegroupUpdateConfig> {
        /**
         * Sets the value of the MaxUnavailable property for this object.
         *
         * @param maxUnavailable
         *        The new value for the MaxUnavailable property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUnavailable(Integer maxUnavailable);

        /**
         * Sets the value of the MaxUnavailablePercentage property for this object.
         *
         * @param maxUnavailablePercentage
         *        The new value for the MaxUnavailablePercentage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUnavailablePercentage(Integer maxUnavailablePercentage);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxUnavailable;

        private Integer maxUnavailablePercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(NodegroupUpdateConfig model) {
            maxUnavailable(model.maxUnavailable);
            maxUnavailablePercentage(model.maxUnavailablePercentage);
        }

        public final Integer getMaxUnavailable() {
            return maxUnavailable;
        }

        @Override
        public final Builder maxUnavailable(Integer maxUnavailable) {
            this.maxUnavailable = maxUnavailable;
            return this;
        }

        public final void setMaxUnavailable(Integer maxUnavailable) {
            this.maxUnavailable = maxUnavailable;
        }

        public final Integer getMaxUnavailablePercentage() {
            return maxUnavailablePercentage;
        }

        @Override
        public final Builder maxUnavailablePercentage(Integer maxUnavailablePercentage) {
            this.maxUnavailablePercentage = maxUnavailablePercentage;
            return this;
        }

        public final void setMaxUnavailablePercentage(Integer maxUnavailablePercentage) {
            this.maxUnavailablePercentage = maxUnavailablePercentage;
        }

        @Override
        public NodegroupUpdateConfig build() {
            return new NodegroupUpdateConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
