/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.Issue;
import software.amazon.awssdk.services.eks.model.IssueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodegroupHealth
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodegroupHealth> {
    private static final SdkField<List<Issue>> ISSUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("issues").getter(NodegroupHealth.getter(NodegroupHealth::issues)).setter(NodegroupHealth.setter(Builder::issues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Issue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Issue> issues;

    private NodegroupHealth(BuilderImpl builder) {
        this.issues = builder.issues;
    }

    public final boolean hasIssues() {
        return this.issues != null && !(this.issues instanceof SdkAutoConstructList);
    }

    public final List<Issue> issues() {
        return this.issues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIssues() ? this.issues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodegroupHealth)) {
            return false;
        }
        NodegroupHealth other = (NodegroupHealth)obj;
        return this.hasIssues() == other.hasIssues() && Objects.equals(this.issues(), other.issues());
    }

    public final String toString() {
        return ToString.builder((String)"NodegroupHealth").add("Issues", this.hasIssues() ? this.issues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "issues": {
                return Optional.ofNullable(clazz.cast(this.issues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodegroupHealth, T> g) {
        return obj -> g.apply((NodegroupHealth)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Issue> issues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodegroupHealth model) {
            this.issues(model.issues);
        }

        public final List<Issue.Builder> getIssues() {
            List<Issue.Builder> result = IssueListCopier.copyToBuilder(this.issues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder issues(Collection<Issue> issues) {
            this.issues = IssueListCopier.copy(issues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issues(Issue ... issues) {
            this.issues(Arrays.asList(issues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issues(Consumer<Issue.Builder> ... issues) {
            this.issues(Stream.of(issues).map(c -> (Issue)((Issue.Builder)Issue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIssues(Collection<Issue.BuilderImpl> issues) {
            this.issues = IssueListCopier.copyFromBuilder(issues);
        }

        public NodegroupHealth build() {
            return new NodegroupHealth(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodegroupHealth> {
        public Builder issues(Collection<Issue> var1);

        public Builder issues(Issue ... var1);

        public Builder issues(Consumer<Issue.Builder> ... var1);
    }
}

