/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.OidcIdentityProviderConfigRequest;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateIdentityProviderConfigRequest
extends EksRequest
implements ToCopyableBuilder<Builder, AssociateIdentityProviderConfigRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(AssociateIdentityProviderConfigRequest.getter(AssociateIdentityProviderConfigRequest::clusterName)).setter(AssociateIdentityProviderConfigRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<OidcIdentityProviderConfigRequest> OIDC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oidc").getter(AssociateIdentityProviderConfigRequest.getter(AssociateIdentityProviderConfigRequest::oidc)).setter(AssociateIdentityProviderConfigRequest.setter(Builder::oidc)).constructor(OidcIdentityProviderConfigRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oidc").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(AssociateIdentityProviderConfigRequest.getter(AssociateIdentityProviderConfigRequest::tags)).setter(AssociateIdentityProviderConfigRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(AssociateIdentityProviderConfigRequest.getter(AssociateIdentityProviderConfigRequest::clientRequestToken)).setter(AssociateIdentityProviderConfigRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, OIDC_FIELD, TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String clusterName;
    private final OidcIdentityProviderConfigRequest oidc;
    private final Map<String, String> tags;
    private final String clientRequestToken;

    private AssociateIdentityProviderConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.oidc = builder.oidc;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final OidcIdentityProviderConfigRequest oidc() {
        return this.oidc;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.oidc());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateIdentityProviderConfigRequest)) {
            return false;
        }
        AssociateIdentityProviderConfigRequest other = (AssociateIdentityProviderConfigRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.oidc(), other.oidc()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateIdentityProviderConfigRequest").add("ClusterName", (Object)this.clusterName()).add("Oidc", (Object)this.oidc()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "oidc": {
                return Optional.ofNullable(clazz.cast(this.oidc()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateIdentityProviderConfigRequest, T> g) {
        return obj -> g.apply((AssociateIdentityProviderConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private OidcIdentityProviderConfigRequest oidc;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateIdentityProviderConfigRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.oidc(model.oidc);
            this.tags(model.tags);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final OidcIdentityProviderConfigRequest.Builder getOidc() {
            return this.oidc != null ? this.oidc.toBuilder() : null;
        }

        @Override
        public final Builder oidc(OidcIdentityProviderConfigRequest oidc) {
            this.oidc = oidc;
            return this;
        }

        public final void setOidc(OidcIdentityProviderConfigRequest.BuilderImpl oidc) {
            this.oidc = oidc != null ? oidc.build() : null;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateIdentityProviderConfigRequest build() {
            return new AssociateIdentityProviderConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateIdentityProviderConfigRequest> {
        public Builder clusterName(String var1);

        public Builder oidc(OidcIdentityProviderConfigRequest var1);

        default public Builder oidc(Consumer<OidcIdentityProviderConfigRequest.Builder> oidc) {
            return this.oidc((OidcIdentityProviderConfigRequest)((OidcIdentityProviderConfigRequest.Builder)OidcIdentityProviderConfigRequest.builder().applyMutation(oidc)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

