/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The encryption configuration for the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionConfig.Builder, EncryptionConfig> {
    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resources")
            .getter(getter(EncryptionConfig::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Provider> PROVIDER_FIELD = SdkField.<Provider> builder(MarshallingType.SDK_POJO)
            .memberName("provider").getter(getter(EncryptionConfig::provider)).setter(setter(Builder::provider))
            .constructor(Provider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCES_FIELD,
            PROVIDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> resources;

    private final Provider provider;

    private EncryptionConfig(BuilderImpl builder) {
        this.resources = builder.resources;
        this.provider = builder.provider;
    }

    /**
     * Returns true if the Resources property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the resources to be encrypted. The only supported value is "secrets".
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the resources to be encrypted. The only supported value is "secrets".
     */
    public final List<String> resources() {
        return resources;
    }

    /**
     * <p>
     * AWS Key Management Service (AWS KMS) key. Either the ARN or the alias can be used.
     * </p>
     * 
     * @return AWS Key Management Service (AWS KMS) key. Either the ARN or the alias can be used.
     */
    public final Provider provider() {
        return provider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfig)) {
            return false;
        }
        EncryptionConfig other = (EncryptionConfig) obj;
        return hasResources() == other.hasResources() && Objects.equals(resources(), other.resources())
                && Objects.equals(provider(), other.provider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionConfig").add("Resources", hasResources() ? resources() : null)
                .add("Provider", provider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionConfig, T> g) {
        return obj -> g.apply((EncryptionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionConfig> {
        /**
         * <p>
         * Specifies the resources to be encrypted. The only supported value is "secrets".
         * </p>
         * 
         * @param resources
         *        Specifies the resources to be encrypted. The only supported value is "secrets".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<String> resources);

        /**
         * <p>
         * Specifies the resources to be encrypted. The only supported value is "secrets".
         * </p>
         * 
         * @param resources
         *        Specifies the resources to be encrypted. The only supported value is "secrets".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(String... resources);

        /**
         * <p>
         * AWS Key Management Service (AWS KMS) key. Either the ARN or the alias can be used.
         * </p>
         * 
         * @param provider
         *        AWS Key Management Service (AWS KMS) key. Either the ARN or the alias can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(Provider provider);

        /**
         * <p>
         * AWS Key Management Service (AWS KMS) key. Either the ARN or the alias can be used.
         * </p>
         * This is a convenience that creates an instance of the {@link Provider.Builder} avoiding the need to create
         * one manually via {@link Provider#builder()}.
         *
         * When the {@link Consumer} completes, {@link Provider.Builder#build()} is called immediately and its result is
         * passed to {@link #provider(Provider)}.
         * 
         * @param provider
         *        a consumer that will call methods on {@link Provider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provider(Provider)
         */
        default Builder provider(Consumer<Provider.Builder> provider) {
            return provider(Provider.builder().applyMutation(provider).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> resources = DefaultSdkAutoConstructList.getInstance();

        private Provider provider;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfig model) {
            resources(model.resources);
            provider(model.provider);
        }

        public final Collection<String> getResources() {
            if (resources instanceof SdkAutoConstructList) {
                return null;
            }
            return resources;
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = StringListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = StringListCopier.copy(resources);
        }

        public final Provider.Builder getProvider() {
            return provider != null ? provider.toBuilder() : null;
        }

        @Override
        public final Builder provider(Provider provider) {
            this.provider = provider;
            return this;
        }

        public final void setProvider(Provider.BuilderImpl provider) {
            this.provider = provider != null ? provider.build() : null;
        }

        @Override
        public EncryptionConfig build() {
            return new EncryptionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
