/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.FargateProfileSelector;
import software.amazon.awssdk.services.eks.model.FargateProfileSelectorsCopier;
import software.amazon.awssdk.services.eks.model.FargateProfileStatus;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FargateProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FargateProfile> {
    private static final SdkField<String> FARGATE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fargateProfileName").getter(FargateProfile.getter(FargateProfile::fargateProfileName)).setter(FargateProfile.setter(Builder::fargateProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargateProfileName").build()}).build();
    private static final SdkField<String> FARGATE_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fargateProfileArn").getter(FargateProfile.getter(FargateProfile::fargateProfileArn)).setter(FargateProfile.setter(Builder::fargateProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargateProfileArn").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(FargateProfile.getter(FargateProfile::clusterName)).setter(FargateProfile.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(FargateProfile.getter(FargateProfile::createdAt)).setter(FargateProfile.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> POD_EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("podExecutionRoleArn").getter(FargateProfile.getter(FargateProfile::podExecutionRoleArn)).setter(FargateProfile.setter(Builder::podExecutionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("podExecutionRoleArn").build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnets").getter(FargateProfile.getter(FargateProfile::subnets)).setter(FargateProfile.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FargateProfileSelector>> SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("selectors").getter(FargateProfile.getter(FargateProfile::selectors)).setter(FargateProfile.setter(Builder::selectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FargateProfileSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(FargateProfile.getter(FargateProfile::statusAsString)).setter(FargateProfile.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(FargateProfile.getter(FargateProfile::tags)).setter(FargateProfile.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARGATE_PROFILE_NAME_FIELD, FARGATE_PROFILE_ARN_FIELD, CLUSTER_NAME_FIELD, CREATED_AT_FIELD, POD_EXECUTION_ROLE_ARN_FIELD, SUBNETS_FIELD, SELECTORS_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fargateProfileName;
    private final String fargateProfileArn;
    private final String clusterName;
    private final Instant createdAt;
    private final String podExecutionRoleArn;
    private final List<String> subnets;
    private final List<FargateProfileSelector> selectors;
    private final String status;
    private final Map<String, String> tags;

    private FargateProfile(BuilderImpl builder) {
        this.fargateProfileName = builder.fargateProfileName;
        this.fargateProfileArn = builder.fargateProfileArn;
        this.clusterName = builder.clusterName;
        this.createdAt = builder.createdAt;
        this.podExecutionRoleArn = builder.podExecutionRoleArn;
        this.subnets = builder.subnets;
        this.selectors = builder.selectors;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final String fargateProfileName() {
        return this.fargateProfileName;
    }

    public final String fargateProfileArn() {
        return this.fargateProfileArn;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String podExecutionRoleArn() {
        return this.podExecutionRoleArn;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<String> subnets() {
        return this.subnets;
    }

    public final boolean hasSelectors() {
        return this.selectors != null && !(this.selectors instanceof SdkAutoConstructList);
    }

    public final List<FargateProfileSelector> selectors() {
        return this.selectors;
    }

    public final FargateProfileStatus status() {
        return FargateProfileStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fargateProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fargateProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.podExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectors() ? this.selectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FargateProfile)) {
            return false;
        }
        FargateProfile other = (FargateProfile)obj;
        return Objects.equals(this.fargateProfileName(), other.fargateProfileName()) && Objects.equals(this.fargateProfileArn(), other.fargateProfileArn()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.podExecutionRoleArn(), other.podExecutionRoleArn()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && this.hasSelectors() == other.hasSelectors() && Objects.equals(this.selectors(), other.selectors()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"FargateProfile").add("FargateProfileName", (Object)this.fargateProfileName()).add("FargateProfileArn", (Object)this.fargateProfileArn()).add("ClusterName", (Object)this.clusterName()).add("CreatedAt", (Object)this.createdAt()).add("PodExecutionRoleArn", (Object)this.podExecutionRoleArn()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("Selectors", this.hasSelectors() ? this.selectors() : null).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fargateProfileName": {
                return Optional.ofNullable(clazz.cast(this.fargateProfileName()));
            }
            case "fargateProfileArn": {
                return Optional.ofNullable(clazz.cast(this.fargateProfileArn()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "podExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.podExecutionRoleArn()));
            }
            case "subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "selectors": {
                return Optional.ofNullable(clazz.cast(this.selectors()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FargateProfile, T> g) {
        return obj -> g.apply((FargateProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fargateProfileName;
        private String fargateProfileArn;
        private String clusterName;
        private Instant createdAt;
        private String podExecutionRoleArn;
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<FargateProfileSelector> selectors = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FargateProfile model) {
            this.fargateProfileName(model.fargateProfileName);
            this.fargateProfileArn(model.fargateProfileArn);
            this.clusterName(model.clusterName);
            this.createdAt(model.createdAt);
            this.podExecutionRoleArn(model.podExecutionRoleArn);
            this.subnets(model.subnets);
            this.selectors(model.selectors);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final String getFargateProfileName() {
            return this.fargateProfileName;
        }

        @Override
        public final Builder fargateProfileName(String fargateProfileName) {
            this.fargateProfileName = fargateProfileName;
            return this;
        }

        public final void setFargateProfileName(String fargateProfileName) {
            this.fargateProfileName = fargateProfileName;
        }

        public final String getFargateProfileArn() {
            return this.fargateProfileArn;
        }

        @Override
        public final Builder fargateProfileArn(String fargateProfileArn) {
            this.fargateProfileArn = fargateProfileArn;
            return this;
        }

        public final void setFargateProfileArn(String fargateProfileArn) {
            this.fargateProfileArn = fargateProfileArn;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getPodExecutionRoleArn() {
            return this.podExecutionRoleArn;
        }

        @Override
        public final Builder podExecutionRoleArn(String podExecutionRoleArn) {
            this.podExecutionRoleArn = podExecutionRoleArn;
            return this;
        }

        public final void setPodExecutionRoleArn(String podExecutionRoleArn) {
            this.podExecutionRoleArn = podExecutionRoleArn;
        }

        public final Collection<String> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        public final Collection<FargateProfileSelector.Builder> getSelectors() {
            if (this.selectors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectors != null ? (Collection)this.selectors.stream().map(FargateProfileSelector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder selectors(Collection<FargateProfileSelector> selectors) {
            this.selectors = FargateProfileSelectorsCopier.copy(selectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(FargateProfileSelector ... selectors) {
            this.selectors(Arrays.asList(selectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(Consumer<FargateProfileSelector.Builder> ... selectors) {
            this.selectors(Stream.of(selectors).map(c -> (FargateProfileSelector)((FargateProfileSelector.Builder)FargateProfileSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSelectors(Collection<FargateProfileSelector.BuilderImpl> selectors) {
            this.selectors = FargateProfileSelectorsCopier.copyFromBuilder(selectors);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FargateProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public FargateProfile build() {
            return new FargateProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FargateProfile> {
        public Builder fargateProfileName(String var1);

        public Builder fargateProfileArn(String var1);

        public Builder clusterName(String var1);

        public Builder createdAt(Instant var1);

        public Builder podExecutionRoleArn(String var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder selectors(Collection<FargateProfileSelector> var1);

        public Builder selectors(FargateProfileSelector ... var1);

        public Builder selectors(Consumer<FargateProfileSelector.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(FargateProfileStatus var1);

        public Builder tags(Map<String, String> var1);
    }
}

