/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Kubernetes network configuration for the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KubernetesNetworkConfigResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<KubernetesNetworkConfigResponse.Builder, KubernetesNetworkConfigResponse> {
    private static final SdkField<String> SERVICE_IPV4_CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceIpv4Cidr").getter(getter(KubernetesNetworkConfigResponse::serviceIpv4Cidr))
            .setter(setter(Builder::serviceIpv4Cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceIpv4Cidr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_IPV4_CIDR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceIpv4Cidr;

    private KubernetesNetworkConfigResponse(BuilderImpl builder) {
        this.serviceIpv4Cidr = builder.serviceIpv4Cidr;
    }

    /**
     * <p>
     * The CIDR block that Kubernetes service IP addresses are assigned from. If you didn't specify a CIDR block when
     * you created the cluster, then Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR
     * blocks. If this was specified, then it was specified when the cluster was created and it cannot be changed.
     * </p>
     * 
     * @return The CIDR block that Kubernetes service IP addresses are assigned from. If you didn't specify a CIDR block
     *         when you created the cluster, then Kubernetes assigns addresses from either the 10.100.0.0/16 or
     *         172.20.0.0/16 CIDR blocks. If this was specified, then it was specified when the cluster was created and
     *         it cannot be changed.
     */
    public String serviceIpv4Cidr() {
        return serviceIpv4Cidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceIpv4Cidr());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesNetworkConfigResponse)) {
            return false;
        }
        KubernetesNetworkConfigResponse other = (KubernetesNetworkConfigResponse) obj;
        return Objects.equals(serviceIpv4Cidr(), other.serviceIpv4Cidr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("KubernetesNetworkConfigResponse").add("ServiceIpv4Cidr", serviceIpv4Cidr()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceIpv4Cidr":
            return Optional.ofNullable(clazz.cast(serviceIpv4Cidr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KubernetesNetworkConfigResponse, T> g) {
        return obj -> g.apply((KubernetesNetworkConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KubernetesNetworkConfigResponse> {
        /**
         * <p>
         * The CIDR block that Kubernetes service IP addresses are assigned from. If you didn't specify a CIDR block
         * when you created the cluster, then Kubernetes assigns addresses from either the 10.100.0.0/16 or
         * 172.20.0.0/16 CIDR blocks. If this was specified, then it was specified when the cluster was created and it
         * cannot be changed.
         * </p>
         * 
         * @param serviceIpv4Cidr
         *        The CIDR block that Kubernetes service IP addresses are assigned from. If you didn't specify a CIDR
         *        block when you created the cluster, then Kubernetes assigns addresses from either the 10.100.0.0/16 or
         *        172.20.0.0/16 CIDR blocks. If this was specified, then it was specified when the cluster was created
         *        and it cannot be changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIpv4Cidr(String serviceIpv4Cidr);
    }

    static final class BuilderImpl implements Builder {
        private String serviceIpv4Cidr;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesNetworkConfigResponse model) {
            serviceIpv4Cidr(model.serviceIpv4Cidr);
        }

        public final String getServiceIpv4Cidr() {
            return serviceIpv4Cidr;
        }

        @Override
        public final Builder serviceIpv4Cidr(String serviceIpv4Cidr) {
            this.serviceIpv4Cidr = serviceIpv4Cidr;
            return this;
        }

        public final void setServiceIpv4Cidr(String serviceIpv4Cidr) {
            this.serviceIpv4Cidr = serviceIpv4Cidr;
        }

        @Override
        public KubernetesNetworkConfigResponse build() {
            return new KubernetesNetworkConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
