/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNodegroupConfigRequest extends EksRequest implements
        ToCopyableBuilder<UpdateNodegroupConfigRequest.Builder, UpdateNodegroupConfigRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateNodegroupConfigRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> NODEGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateNodegroupConfigRequest::nodegroupName)).setter(setter(Builder::nodegroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("nodegroupName").build()).build();

    private static final SdkField<UpdateLabelsPayload> LABELS_FIELD = SdkField
            .<UpdateLabelsPayload> builder(MarshallingType.SDK_POJO).getter(getter(UpdateNodegroupConfigRequest::labels))
            .setter(setter(Builder::labels)).constructor(UpdateLabelsPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build()).build();

    private static final SdkField<NodegroupScalingConfig> SCALING_CONFIG_FIELD = SdkField
            .<NodegroupScalingConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateNodegroupConfigRequest::scalingConfig)).setter(setter(Builder::scalingConfig))
            .constructor(NodegroupScalingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingConfig").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateNodegroupConfigRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            NODEGROUP_NAME_FIELD, LABELS_FIELD, SCALING_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String clusterName;

    private final String nodegroupName;

    private final UpdateLabelsPayload labels;

    private final NodegroupScalingConfig scalingConfig;

    private final String clientRequestToken;

    private UpdateNodegroupConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodegroupName = builder.nodegroupName;
        this.labels = builder.labels;
        this.scalingConfig = builder.scalingConfig;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of the Amazon EKS cluster that the managed node group resides in.
     * </p>
     * 
     * @return The name of the Amazon EKS cluster that the managed node group resides in.
     */
    public String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The name of the managed node group to update.
     * </p>
     * 
     * @return The name of the managed node group to update.
     */
    public String nodegroupName() {
        return nodegroupName;
    }

    /**
     * <p>
     * The Kubernetes labels to be applied to the nodes in the node group after the update.
     * </p>
     * 
     * @return The Kubernetes labels to be applied to the nodes in the node group after the update.
     */
    public UpdateLabelsPayload labels() {
        return labels;
    }

    /**
     * <p>
     * The scaling configuration details for the Auto Scaling group after the update.
     * </p>
     * 
     * @return The scaling configuration details for the Auto Scaling group after the update.
     */
    public NodegroupScalingConfig scalingConfig() {
        return scalingConfig;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(nodegroupName());
        hashCode = 31 * hashCode + Objects.hashCode(labels());
        hashCode = 31 * hashCode + Objects.hashCode(scalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNodegroupConfigRequest)) {
            return false;
        }
        UpdateNodegroupConfigRequest other = (UpdateNodegroupConfigRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(nodegroupName(), other.nodegroupName())
                && Objects.equals(labels(), other.labels()) && Objects.equals(scalingConfig(), other.scalingConfig())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateNodegroupConfigRequest").add("ClusterName", clusterName())
                .add("NodegroupName", nodegroupName()).add("Labels", labels()).add("ScalingConfig", scalingConfig())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "nodegroupName":
            return Optional.ofNullable(clazz.cast(nodegroupName()));
        case "labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "scalingConfig":
            return Optional.ofNullable(clazz.cast(scalingConfig()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNodegroupConfigRequest, T> g) {
        return obj -> g.apply((UpdateNodegroupConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateNodegroupConfigRequest> {
        /**
         * <p>
         * The name of the Amazon EKS cluster that the managed node group resides in.
         * </p>
         * 
         * @param clusterName
         *        The name of the Amazon EKS cluster that the managed node group resides in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The name of the managed node group to update.
         * </p>
         * 
         * @param nodegroupName
         *        The name of the managed node group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodegroupName(String nodegroupName);

        /**
         * <p>
         * The Kubernetes labels to be applied to the nodes in the node group after the update.
         * </p>
         * 
         * @param labels
         *        The Kubernetes labels to be applied to the nodes in the node group after the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(UpdateLabelsPayload labels);

        /**
         * <p>
         * The Kubernetes labels to be applied to the nodes in the node group after the update.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateLabelsPayload.Builder} avoiding the need
         * to create one manually via {@link UpdateLabelsPayload#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateLabelsPayload.Builder#build()} is called immediately and
         * its result is passed to {@link #labels(UpdateLabelsPayload)}.
         * 
         * @param labels
         *        a consumer that will call methods on {@link UpdateLabelsPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labels(UpdateLabelsPayload)
         */
        default Builder labels(Consumer<UpdateLabelsPayload.Builder> labels) {
            return labels(UpdateLabelsPayload.builder().applyMutation(labels).build());
        }

        /**
         * <p>
         * The scaling configuration details for the Auto Scaling group after the update.
         * </p>
         * 
         * @param scalingConfig
         *        The scaling configuration details for the Auto Scaling group after the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingConfig(NodegroupScalingConfig scalingConfig);

        /**
         * <p>
         * The scaling configuration details for the Auto Scaling group after the update.
         * </p>
         * This is a convenience that creates an instance of the {@link NodegroupScalingConfig.Builder} avoiding the
         * need to create one manually via {@link NodegroupScalingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodegroupScalingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #scalingConfig(NodegroupScalingConfig)}.
         * 
         * @param scalingConfig
         *        a consumer that will call methods on {@link NodegroupScalingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingConfig(NodegroupScalingConfig)
         */
        default Builder scalingConfig(Consumer<NodegroupScalingConfig.Builder> scalingConfig) {
            return scalingConfig(NodegroupScalingConfig.builder().applyMutation(scalingConfig).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String nodegroupName;

        private UpdateLabelsPayload labels;

        private NodegroupScalingConfig scalingConfig;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNodegroupConfigRequest model) {
            super(model);
            clusterName(model.clusterName);
            nodegroupName(model.nodegroupName);
            labels(model.labels);
            scalingConfig(model.scalingConfig);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getClusterName() {
            return clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getNodegroupName() {
            return nodegroupName;
        }

        @Override
        public final Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public final void setNodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
        }

        public final UpdateLabelsPayload.Builder getLabels() {
            return labels != null ? labels.toBuilder() : null;
        }

        @Override
        public final Builder labels(UpdateLabelsPayload labels) {
            this.labels = labels;
            return this;
        }

        public final void setLabels(UpdateLabelsPayload.BuilderImpl labels) {
            this.labels = labels != null ? labels.build() : null;
        }

        public final NodegroupScalingConfig.Builder getScalingConfig() {
            return scalingConfig != null ? scalingConfig.toBuilder() : null;
        }

        @Override
        public final Builder scalingConfig(NodegroupScalingConfig scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        public final void setScalingConfig(NodegroupScalingConfig.BuilderImpl scalingConfig) {
            this.scalingConfig = scalingConfig != null ? scalingConfig.build() : null;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNodegroupConfigRequest build() {
            return new UpdateNodegroupConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
